/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common.worker;

import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.common.Metric;
import com.google.cloud.dataflow.sdk.util.common.worker.Reader;
import com.google.cloud.dataflow.sdk.util.common.worker.StateSampler;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;

public abstract class WorkExecutor
implements AutoCloseable {
    private final CounterSet outputCounters;
    private final OperatingSystemMXBean os;

    public WorkExecutor(CounterSet outputCounters) {
        this.outputCounters = outputCounters;
        this.os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    }

    public CounterSet getOutputCounters() {
        return this.outputCounters;
    }

    public Collection<Metric<?>> getOutputMetrics() {
        ArrayList outputMetrics = new ArrayList();
        outputMetrics.add(new Metric.DoubleMetric("CPU", this.os.getProcessCpuLoad()));
        return outputMetrics;
    }

    public abstract void execute() throws Exception;

    public Reader.Progress getWorkerProgress() throws Exception {
        return null;
    }

    public Reader.DynamicSplitResult requestDynamicSplit(Reader.DynamicSplitRequest splitRequest) throws Exception {
        return null;
    }

    @Nullable
    public StateSampler.StateSamplerInfo getWorkerStateSamplerInfo() throws Exception {
        return null;
    }

    @Override
    public void close() throws Exception {
    }
}

