/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.state;

import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.util.state.CombiningValueStateInternal;
import com.google.cloud.dataflow.sdk.util.state.State;
import com.google.cloud.dataflow.sdk.util.state.StateContents;
import java.util.ArrayList;
import java.util.Collection;

class MergedCombiningValue<InputT, AccumT, OutputT>
implements CombiningValueStateInternal<InputT, AccumT, OutputT> {
    private final Collection<CombiningValueStateInternal<InputT, AccumT, OutputT>> sources;
    private final CombiningValueStateInternal<InputT, AccumT, OutputT> result;
    private final Combine.CombineFn<InputT, AccumT, OutputT> combineFn;

    public MergedCombiningValue(Collection<CombiningValueStateInternal<InputT, AccumT, OutputT>> sources, CombiningValueStateInternal<InputT, AccumT, OutputT> result, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        this.sources = sources;
        this.result = result;
        this.combineFn = combineFn;
    }

    @Override
    public void clear() {
        for (State state : this.sources) {
            state.clear();
        }
        this.result.clear();
    }

    @Override
    public StateContents<OutputT> get() {
        final StateContents<AccumT> accum = this.getAccum();
        return new StateContents<OutputT>(){

            @Override
            public OutputT read() {
                return MergedCombiningValue.this.combineFn.extractOutput(accum.read());
            }
        };
    }

    @Override
    public void add(InputT input) {
        this.result.add(input);
    }

    @Override
    public void addAccum(AccumT accum) {
        this.result.addAccum(accum);
    }

    @Override
    public StateContents<AccumT> getAccum() {
        final ArrayList<StateContents<AccumT>> futures = new ArrayList<StateContents<AccumT>>(this.sources.size());
        for (CombiningValueStateInternal<InputT, AccumT, OutputT> source : this.sources) {
            futures.add(source.getAccum());
        }
        return new StateContents<AccumT>(){

            @Override
            public AccumT read() {
                ArrayList accumulators = new ArrayList(futures.size());
                for (StateContents future : futures) {
                    accumulators.add(future.read());
                }
                Object combined = MergedCombiningValue.this.combineFn.mergeAccumulators(accumulators);
                MergedCombiningValue.this.clear();
                MergedCombiningValue.this.addAccum(combined);
                return MergedCombiningValue.this.result.getAccum().read();
            }
        };
    }

    @Override
    public StateContents<Boolean> isEmpty() {
        final ArrayList<StateContents<Boolean>> futures = new ArrayList<StateContents<Boolean>>(this.sources.size());
        for (CombiningValueStateInternal<InputT, AccumT, OutputT> source : this.sources) {
            futures.add(source.isEmpty());
        }
        return new StateContents<Boolean>(){

            @Override
            public Boolean read() {
                for (StateContents future : futures) {
                    if (((Boolean)future.read()).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

