/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.state;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.util.state.BagState;
import com.google.cloud.dataflow.sdk.util.state.CombiningValueStateInternal;
import com.google.cloud.dataflow.sdk.util.state.MergeableState;
import com.google.cloud.dataflow.sdk.util.state.MergedBag;
import com.google.cloud.dataflow.sdk.util.state.MergedCombiningValue;
import com.google.cloud.dataflow.sdk.util.state.MergedWatermarkStateInternal;
import com.google.cloud.dataflow.sdk.util.state.StateInternals;
import com.google.cloud.dataflow.sdk.util.state.StateNamespace;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import com.google.cloud.dataflow.sdk.util.state.ValueState;
import com.google.cloud.dataflow.sdk.util.state.WatermarkStateInternal;
import java.util.ArrayList;

public abstract class MergingStateInternals
implements StateInternals {
    @Override
    public <T extends MergeableState<?, ?>> T mergedState(final Iterable<StateNamespace> sourceNamespaces, final StateNamespace resultNamespace, StateTag<T> address) {
        return (T)((MergeableState)address.bind(new StateTag.StateBinder(){

            @Override
            public <T> ValueState<T> bindValue(StateTag<ValueState<T>> address, Coder<T> coder) {
                throw new IllegalStateException("Value is not mergable. Should not be passed to mergedState");
            }

            @Override
            public <T> BagState<T> bindBag(StateTag<BagState<T>> address, Coder<T> elemCoder) {
                ArrayList sources = new ArrayList();
                for (StateNamespace sourceNamespace : sourceNamespaces) {
                    if (sourceNamespace.equals(resultNamespace)) continue;
                    sources.add(MergingStateInternals.this.state(sourceNamespace, address));
                }
                BagState<T> results = MergingStateInternals.this.state(resultNamespace, address);
                sources.add(results);
                return new MergedBag(sources, results);
            }

            @Override
            public <InputT, AccumT, OutputT> CombiningValueStateInternal<InputT, AccumT, OutputT> bindCombiningValue(StateTag<CombiningValueStateInternal<InputT, AccumT, OutputT>> address, Coder<AccumT> accumCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
                ArrayList sources = new ArrayList();
                for (StateNamespace sourceNamespace : sourceNamespaces) {
                    if (sourceNamespace.equals(resultNamespace)) continue;
                    sources.add(MergingStateInternals.this.state(sourceNamespace, address));
                }
                CombiningValueStateInternal<InputT, AccumT, OutputT> result = MergingStateInternals.this.state(resultNamespace, address);
                sources.add(result);
                return new MergedCombiningValue(sources, result, combineFn);
            }

            @Override
            public <T> WatermarkStateInternal bindWatermark(StateTag<WatermarkStateInternal> address) {
                ArrayList<WatermarkStateInternal> sources = new ArrayList<WatermarkStateInternal>();
                for (StateNamespace sourceNamespace : sourceNamespaces) {
                    if (sourceNamespace.equals(resultNamespace)) continue;
                    sources.add(MergingStateInternals.this.state(sourceNamespace, address));
                }
                WatermarkStateInternal result = MergingStateInternals.this.state(resultNamespace, address);
                sources.add(result);
                return new MergedWatermarkStateInternal(sources, result);
            }
        }));
    }
}

