/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.state;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.coders.CannotProvideCoderException;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.util.state.BagState;
import com.google.cloud.dataflow.sdk.util.state.CombiningValueState;
import com.google.cloud.dataflow.sdk.util.state.CombiningValueStateInternal;
import com.google.cloud.dataflow.sdk.util.state.State;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import com.google.cloud.dataflow.sdk.util.state.ValueState;
import com.google.cloud.dataflow.sdk.util.state.WatermarkStateInternal;
import java.io.Serializable;
import java.util.Objects;

@Experimental(value=Experimental.Kind.STATE)
public class StateTags {
    private static final CoderRegistry STANDARD_REGISTRY = new CoderRegistry();

    private StateTags() {
    }

    public static <T> StateTag<ValueState<T>> value(String id, Coder<T> valueCoder) {
        return new ValueStateTag(new StructuredId(id), valueCoder);
    }

    public static <InputT, AccumT, OutputT> StateTag<CombiningValueState<InputT, OutputT>> combiningValue(String id, Coder<AccumT> accumCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        return StateTags.combiningValueInternal(id, accumCoder, combineFn);
    }

    public static <InputT, AccumT, OutputT> StateTag<CombiningValueState<InputT, OutputT>> combiningValueFromInputInternal(String id, Coder<InputT> inputCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        try {
            Coder<AccumT> accumCoder = combineFn.getAccumulatorCoder(STANDARD_REGISTRY, inputCoder);
            return StateTags.combiningValueInternal(id, accumCoder, combineFn);
        }
        catch (CannotProvideCoderException e) {
            String string = String.valueOf(combineFn.getClass().getSimpleName());
            String string2 = String.valueOf(inputCoder);
            throw new IllegalArgumentException(new StringBuilder(48 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unable to determine accumulator coder for ").append(string).append(" from ").append(string2).toString(), e);
        }
    }

    private static <InputT, AccumT, OutputT> StateTag<CombiningValueState<InputT, OutputT>> combiningValueInternal(String id, Coder<AccumT> accumCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
        CombiningValueStateTag internal;
        CombiningValueStateTag external = internal = new CombiningValueStateTag(new StructuredId(id), accumCoder, combineFn);
        return external;
    }

    public static <T> StateTag<BagState<T>> bag(String id, Coder<T> elemCoder) {
        return new BagStateTag(new StructuredId(id), elemCoder);
    }

    public static <T> StateTag<WatermarkStateInternal> watermarkStateInternal(String id) {
        return new WatermarkStateTagInternal(new StructuredId(id));
    }

    public static <StateT extends State> StateTag<StateT> makeSystemTagInternal(StateTag<StateT> tag) {
        if (!(tag instanceof StateTagBase)) {
            String string = String.valueOf(tag);
            throw new IllegalArgumentException(new StringBuilder(20 + String.valueOf(string).length()).append("Unexpected StateTag ").append(string).toString());
        }
        return ((StateTagBase)tag).asKind(StateKind.SYSTEM);
    }

    static {
        STANDARD_REGISTRY.registerStandardCoders();
    }

    private static class WatermarkStateTagInternal
    extends StateTagBase<WatermarkStateInternal> {
        private WatermarkStateTagInternal(StructuredId id) {
            super(id);
        }

        @Override
        public WatermarkStateInternal bind(StateTag.StateBinder visitor) {
            return visitor.bindWatermark(this);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof WatermarkStateTagInternal)) {
                return false;
            }
            WatermarkStateTagInternal that = (WatermarkStateTagInternal)obj;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.id);
        }

        @Override
        protected StateTag<WatermarkStateInternal> asKind(StateKind kind) {
            return new WatermarkStateTagInternal(this.id.asKind(kind));
        }
    }

    private static class BagStateTag<T>
    extends StateTagBase<BagState<T>> {
        private final Coder<T> elemCoder;

        private BagStateTag(StructuredId id, Coder<T> elemCoder) {
            super(id);
            this.elemCoder = elemCoder;
        }

        @Override
        public BagState<T> bind(StateTag.StateBinder visitor) {
            return visitor.bindBag(this, this.elemCoder);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BagStateTag)) {
                return false;
            }
            BagStateTag that = (BagStateTag)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.elemCoder, that.elemCoder);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.id, this.elemCoder);
        }

        @Override
        protected StateTag<BagState<T>> asKind(StateKind kind) {
            return new BagStateTag<T>(this.id.asKind(kind), this.elemCoder);
        }
    }

    private static class CombiningValueStateTag<InputT, AccumT, OutputT>
    extends StateTagBase<CombiningValueStateInternal<InputT, AccumT, OutputT>> {
        private final Coder<AccumT> accumCoder;
        private final Combine.CombineFn<InputT, AccumT, OutputT> combineFn;

        private CombiningValueStateTag(StructuredId id, Coder<AccumT> accumCoder, Combine.CombineFn<InputT, AccumT, OutputT> combineFn) {
            super(id);
            this.combineFn = combineFn;
            this.accumCoder = accumCoder;
        }

        @Override
        public CombiningValueStateInternal<InputT, AccumT, OutputT> bind(StateTag.StateBinder visitor) {
            return visitor.bindCombiningValue(this, this.accumCoder, this.combineFn);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CombiningValueStateTag)) {
                return false;
            }
            CombiningValueStateTag that = (CombiningValueStateTag)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.accumCoder, that.accumCoder);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.id, this.accumCoder);
        }

        @Override
        protected StateTag<CombiningValueStateInternal<InputT, AccumT, OutputT>> asKind(StateKind kind) {
            return new CombiningValueStateTag<InputT, AccumT, OutputT>(this.id.asKind(kind), this.accumCoder, this.combineFn);
        }
    }

    private static class ValueStateTag<T>
    extends StateTagBase<ValueState<T>> {
        private final Coder<T> coder;

        private ValueStateTag(StructuredId id, Coder<T> coder) {
            super(id);
            this.coder = coder;
        }

        @Override
        public ValueState<T> bind(StateTag.StateBinder visitor) {
            return visitor.bindValue(this, this.coder);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ValueStateTag)) {
                return false;
            }
            ValueStateTag that = (ValueStateTag)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.coder, that.coder);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.id, this.coder);
        }

        @Override
        protected StateTag<ValueState<T>> asKind(StateKind kind) {
            return new ValueStateTag<T>(this.id.asKind(kind), this.coder);
        }
    }

    private static abstract class StateTagBase<StateT extends State>
    implements StateTag<StateT> {
        protected final StructuredId id;

        protected StateTagBase(StructuredId id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id.getIdString();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("id", this.id).toString();
        }

        protected abstract StateTag<StateT> asKind(StateKind var1);
    }

    private static class StructuredId
    implements Serializable {
        private final StateKind kind;
        private final String rawId;

        private StructuredId(String rawId) {
            this(StateKind.USER, rawId);
        }

        private StructuredId(StateKind kind, String rawId) {
            this.kind = kind;
            this.rawId = rawId;
        }

        public StructuredId asKind(StateKind kind) {
            return new StructuredId(kind, this.rawId);
        }

        public String getIdString() {
            char c = this.kind.prefix;
            String string = this.rawId;
            return new StringBuilder(1 + String.valueOf(string).length()).append(c).append(string).toString();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("id", this.rawId).add("kind", (Object)this.kind).toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StructuredId)) {
                return false;
            }
            StructuredId that = (StructuredId)obj;
            return Objects.equals((Object)this.kind, (Object)that.kind) && Objects.equals(this.rawId, that.rawId);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.rawId});
        }
    }

    private static enum StateKind {
        SYSTEM('s'),
        USER('u');

        private char prefix;

        private StateKind(char prefix) {
            this.prefix = prefix;
        }
    }
}

