/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.values;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.util.StringUtils;
import com.google.cloud.dataflow.sdk.values.POutputValueBase;
import com.google.cloud.dataflow.sdk.values.PValue;
import java.util.Collection;
import java.util.Collections;

public abstract class PValueBase
extends POutputValueBase
implements PValue {
    private String name;
    private boolean finishedSpecifying = false;

    @Override
    public String getName() {
        if (this.name == null) {
            throw new IllegalStateException("name not set");
        }
        return this.name;
    }

    public PValueBase setName(String name) {
        if (this.finishedSpecifying) {
            String string = String.valueOf(this);
            throw new IllegalStateException(new StringBuilder(46 + String.valueOf(string).length()).append("cannot change the name of ").append(string).append(" once it's been used").toString());
        }
        this.name = name;
        return this;
    }

    protected PValueBase(Pipeline pipeline) {
        super(pipeline);
    }

    protected PValueBase() {
    }

    @Override
    public void recordAsOutput(AppliedPTransform<?, ?, ?> transform) {
        this.recordAsOutput(transform, "out");
    }

    protected void recordAsOutput(AppliedPTransform<?, ?, ?> transform, String outName) {
        super.recordAsOutput(transform);
        if (this.name == null) {
            String string = transform.getFullName();
            this.name = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(outName).length()).append(string).append(".").append(outName).toString();
        }
    }

    public boolean isFinishedSpecifyingInternal() {
        return this.finishedSpecifying;
    }

    @Override
    public Collection<? extends PValue> expand() {
        return Collections.singletonList(this);
    }

    @Override
    public void finishSpecifying() {
        this.finishSpecifyingOutput();
        this.finishedSpecifying = true;
    }

    public String toString() {
        String string = this.name == null ? "<unnamed>" : this.getName();
        String string2 = this.getKindString();
        return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" [").append(string2).append("]").toString();
    }

    protected String getKindString() {
        return StringUtils.approximateSimpleName(this.getClass());
    }
}

