/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.InstantCoder;
import com.google.cloud.dataflow.sdk.coders.StandardCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.joda.time.Instant;

public class TimestampedValue<V> {
    private final V value;
    private final Instant timestamp;

    public static <V> TimestampedValue<V> of(V value, Instant timestamp) {
        return new TimestampedValue<V>(value, timestamp);
    }

    public V getValue() {
        return this.value;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TimestampedValue)) {
            return false;
        }
        TimestampedValue that = (TimestampedValue)other;
        return Objects.equals(this.value, that.value) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.timestamp);
    }

    public String toString() {
        String string = String.valueOf(this.value);
        String string2 = String.valueOf(this.timestamp);
        return new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length()).append("TimestampedValue(").append(string).append(", ").append(string2).append(")").toString();
    }

    protected TimestampedValue(V value, Instant timestamp) {
        this.value = value;
        this.timestamp = timestamp;
    }

    public static class TimestampedValueCoder<T>
    extends StandardCoder<TimestampedValue<T>> {
        private final Coder<T> valueCoder;

        public static <T> TimestampedValueCoder<T> of(Coder<T> valueCoder) {
            return new TimestampedValueCoder<T>(valueCoder);
        }

        @JsonCreator
        public static TimestampedValueCoder<?> of(@JsonProperty(value="component_encodings") List<Object> components) {
            int n = components.size();
            Preconditions.checkArgument(components.size() == 1, new StringBuilder(38).append("Expecting 1 component, got ").append(n).toString());
            return TimestampedValueCoder.of((Coder)components.get(0));
        }

        TimestampedValueCoder(Coder<T> valueCoder) {
            this.valueCoder = Preconditions.checkNotNull(valueCoder);
        }

        @Override
        public void encode(TimestampedValue<T> windowedElem, OutputStream outStream, Coder.Context context) throws IOException {
            this.valueCoder.encode(windowedElem.getValue(), outStream, context.nested());
            InstantCoder.of().encode(windowedElem.getTimestamp(), outStream, context);
        }

        @Override
        public TimestampedValue<T> decode(InputStream inStream, Coder.Context context) throws IOException {
            T value = this.valueCoder.decode(inStream, context.nested());
            Instant timestamp = InstantCoder.of().decode(inStream, context);
            return TimestampedValue.of(value, timestamp);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.verifyDeterministic("TimestampedValueCoder requires a deterministic valueCoder", this.valueCoder);
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.valueCoder);
        }

        public static <T> List<Object> getInstanceComponents(TimestampedValue<T> exampleValue) {
            return Arrays.asList(exampleValue.getValue());
        }
    }
}

