/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.HashMultiset;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Multiset;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import java.io.Serializable;
import java.util.Map;
import java.util.Random;

public class TupleTag<V>
implements Serializable {
    static final Random RANDOM = new Random(0L);
    private static final Multiset<String> staticInits = HashMultiset.create();
    final String id;
    final boolean generated;

    public TupleTag() {
        this(TupleTag.genId(), true);
    }

    public TupleTag(String id) {
        this(id, false);
    }

    public String getId() {
        return this.id;
    }

    public String getOutName(int outIndex) {
        if (this.generated) {
            return new StringBuilder(14).append("out").append(outIndex).toString();
        }
        return this.id;
    }

    public TypeDescriptor<V> getTypeDescriptor() {
        return new TypeDescriptor<V>(this.getClass()){};
    }

    static synchronized String genId() {
        String string;
        StackTraceElement[] stackTrace;
        for (StackTraceElement frame : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!frame.getMethodName().equals("<clinit>")) continue;
            int counter = staticInits.add(frame.getClassName(), 1);
            String string2 = String.valueOf(frame.getClassName());
            return new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append("#").append(counter).toString();
        }
        String nonce = Long.toHexString(RANDOM.nextLong());
        if (stackTrace.length >= 4) {
            String string3 = String.valueOf(stackTrace[3].getClassName());
            String string4 = String.valueOf(stackTrace[3].getMethodName());
            int n = stackTrace[3].getLineNumber();
            string = new StringBuilder(13 + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string3).append(".").append(string4).append(":").append(n).toString();
        } else {
            string = "unknown";
        }
        String caller = string;
        return new StringBuilder(1 + String.valueOf(caller).length() + String.valueOf(nonce).length()).append(caller).append("#").append(nonce).toString();
    }

    @JsonCreator
    private static TupleTag<?> fromJson(@JsonProperty(value="value") String id, @JsonProperty(value="is_generated") boolean generated) {
        return new TupleTag(id, generated);
    }

    private TupleTag(String id, boolean generated) {
        this.id = id;
        this.generated = generated;
    }

    public CloudObject asCloudObject() {
        CloudObject result = CloudObject.forClass(this.getClass());
        Structs.addString((Map<String, Object>)((Object)result), "value", this.id);
        Structs.addBoolean((Map<String, Object>)((Object)result), "is_generated", this.generated);
        return result;
    }

    public boolean equals(Object that) {
        if (that instanceof TupleTag) {
            return this.id.equals(((TupleTag)that).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        String string = this.id;
        return new StringBuilder(5 + String.valueOf(string).length()).append("Tag<").append(string).append(">").toString();
    }
}

