/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.hsql;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.Schema;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.dbsupport.hsql.HsqlSchema;
import com.googlecode.flyway.core.dbsupport.hsql.HsqlSqlStatementBuilder;
import com.googlecode.flyway.core.util.jdbc.JdbcUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class HsqlDbSupport
extends DbSupport {
    public HsqlDbSupport(Connection connection) {
        super(new JdbcTemplate(connection, 12));
    }

    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/hsql/";
    }

    public String getCurrentUserFunction() {
        return "USER()";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doGetCurrentSchema() throws SQLException {
        ResultSet resultSet = null;
        String schema = null;
        try {
            resultSet = this.jdbcTemplate.getMetaData().getSchemas();
            while (resultSet.next()) {
                if (!resultSet.getBoolean("IS_DEFAULT")) continue;
                schema = resultSet.getString("TABLE_SCHEM");
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        return schema;
    }

    protected void doSetCurrentSchema(Schema schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + schema, new Object[0]);
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    public SqlStatementBuilder createSqlStatementBuilder() {
        return new HsqlSqlStatementBuilder();
    }

    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    public Schema getSchema(String name) {
        return new HsqlSchema(this.jdbcTemplate, this, name);
    }

    public boolean catalogIsSchema() {
        return false;
    }
}

