/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util.jdbc;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.util.ClassUtils;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.jdbc.JdbcUtils;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverDataSource
implements DataSource {
    private Driver driver;
    private String url;
    private String user;
    private String password;
    private String[] initSqls = new String[0];

    public DriverDataSource() {
    }

    public DriverDataSource(String driverClass, String url, String user, String password, String ... initSqls) throws FlywayException {
        if (!StringUtils.hasText(url)) {
            throw new FlywayException("Missing required JDBC URL. Unable to create DataSource!");
        }
        if (!url.toLowerCase().startsWith("jdbc:")) {
            throw new FlywayException("Invalid JDBC URL (should start with jdbc:) : " + url);
        }
        this.url = url;
        if (driverClass == null) {
            if (url.startsWith("jdbc:db2:")) {
                driverClass = "com.ibm.db2.jcc.DB2Driver";
            } else if (url.startsWith("jdbc:derby:")) {
                driverClass = "org.apache.derby.jdbc.EmbeddedDriver";
            } else if (url.startsWith("jdbc:h2:")) {
                driverClass = "org.h2.Driver";
            } else if (url.startsWith("jdbc:hsqldb:")) {
                driverClass = "org.hsqldb.jdbcDriver";
            } else if (url.startsWith("jdbc:mysql:")) {
                driverClass = "com.mysql.jdbc.Driver";
            } else if (url.startsWith("jdbc:google:")) {
                driverClass = "com.google.appengine.api.rdbms.AppEngineDriver";
            } else if (url.startsWith("jdbc:oracle:")) {
                driverClass = "oracle.jdbc.OracleDriver";
            } else if (url.startsWith("jdbc:postgresql:")) {
                driverClass = "org.postgresql.Driver";
            } else if (url.startsWith("jdbc:jtds:")) {
                driverClass = "net.sourceforge.jtds.jdbc.Driver";
            } else if (url.startsWith("jdbc:sqlserver:")) {
                driverClass = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            } else {
                throw new FlywayException("Unable to autodetect Jdbc driver for url: " + url);
            }
        }
        try {
            this.driver = (Driver)ClassUtils.instantiate(driverClass);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to instantiate jdbc driver: " + driverClass);
        }
        this.user = user;
        this.password = password;
        this.initSqls = initSqls;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String[] getInitSqls() {
        return this.initSqls;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnectionFromDriver(this.getUser(), this.getPassword());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnectionFromDriver(username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnectionFromDriver(String username, String password) throws SQLException {
        Properties props = new Properties();
        if (username != null) {
            props.setProperty("user", username);
        }
        if (password != null) {
            props.setProperty("password", password);
        }
        Connection connection = this.driver.connect(this.url, props);
        for (String initSql : this.initSqls) {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                statement.execute(initSql);
            }
            finally {
                JdbcUtils.closeStatement(statement);
            }
        }
        return connection;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        throw new UnsupportedOperationException("setLoginTimeout");
    }

    @Override
    public PrintWriter getLogWriter() {
        throw new UnsupportedOperationException("getLogWriter");
    }

    @Override
    public void setLogWriter(PrintWriter pw) throws SQLException {
        throw new UnsupportedOperationException("setLogWriter");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return DataSource.class.equals(iface);
    }

    @Override
    public Logger getParentLogger() {
        throw new UnsupportedOperationException("getParentLogger");
    }
}

