/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.conflict;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.server.distributed.ODistributedException;

public class OReplicationConflictException
extends ODistributedException {
    private static final String MESSAGE_LOCAL_VERSION = "local=v";
    private static final String MESSAGE_ORIGINAL_VERSION = "original=v";
    private static final long serialVersionUID = 1L;
    private final ORID originalRID;
    private final int originalVersion;
    private final ORID localRID;
    private final int localVersion;

    public OReplicationConflictException(String message) {
        super(message);
        int beginPos = message.indexOf(35);
        int endPos = message.indexOf(32, beginPos);
        this.originalRID = new ORecordId(message.substring(beginPos, endPos));
        beginPos = message.indexOf(MESSAGE_ORIGINAL_VERSION, endPos) + MESSAGE_ORIGINAL_VERSION.length();
        endPos = message.indexOf(32, beginPos);
        this.originalVersion = Integer.parseInt(message.substring(beginPos, endPos));
        beginPos = message.indexOf(MESSAGE_LOCAL_VERSION, endPos) + MESSAGE_LOCAL_VERSION.length();
        endPos = message.indexOf(41, beginPos);
        this.localVersion = Integer.parseInt(message.substring(beginPos, endPos));
        this.localRID = null;
    }

    public OReplicationConflictException(String message, ORID iRID, int iDatabaseVersion, int iRecordVersion) {
        super(message);
        this.originalRID = iRID;
        this.localRID = null;
        this.originalVersion = iDatabaseVersion;
        this.localVersion = iRecordVersion;
    }

    public OReplicationConflictException(String message, ORID iOriginalRID, ORID iLocalRID) {
        super(message);
        this.originalRID = iOriginalRID;
        this.localRID = iLocalRID;
        this.localVersion = 0;
        this.originalVersion = 0;
    }

    public String getMessage() {
        StringBuilder buffer = new StringBuilder(super.getMessage());
        if (this.localRID != null) {
            buffer.append("original RID=");
            buffer.append(this.originalRID);
            buffer.append(" local RID=");
            buffer.append(this.localRID);
        } else {
            buffer.append(MESSAGE_ORIGINAL_VERSION);
            buffer.append(this.originalVersion);
            buffer.append(' ');
            buffer.append(MESSAGE_LOCAL_VERSION);
            buffer.append(this.localVersion);
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getMessage();
    }

    public int getOriginalVersion() {
        return this.originalVersion;
    }

    public int getLocalVersion() {
        return this.localVersion;
    }

    public ORID getOriginalRID() {
        return this.originalRID;
    }

    public ORID getLocalRID() {
        return this.localRID;
    }
}

