/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OResurrectRecordTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ODeleteRecordTask
extends OAbstractRecordReplicatedTask {
    private static final long serialVersionUID = 1L;
    private boolean delayed = false;

    public ODeleteRecordTask() {
    }

    public ODeleteRecordTask(ORecordId iRid, ORecordVersion iVersion) {
        super(iRid, iVersion);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), null, ODistributedServerLog.DIRECTION.IN, "delete record %s/%s v.%s", database.getName(), this.rid.toString(), this.version.toString());
        ORecord record = database.load((ORID)this.rid);
        if (record == null) return true;
        if (this.delayed) {
            if (!record.getRecordVersion().equals((Object)this.version)) throw new OConcurrentModificationException((ORID)this.rid, record.getRecordVersion(), this.version, 2);
            ((ODistributedStorage)database.getStorage()).pushDeletedRecord(this.rid, this.version);
            return true;
        } else {
            record.delete();
        }
        return true;
    }

    @Override
    public OAbstractRemoteTask.QUORUM_TYPE getQuorumType() {
        return OAbstractRemoteTask.QUORUM_TYPE.WRITE;
    }

    @Override
    public OResurrectRecordTask getFixTask(ODistributedRequest iRequest, Object iBadResponse, Object iGoodResponse) {
        return new OResurrectRecordTask(this.rid, this.version);
    }

    @Override
    public OAbstractRemoteTask getUndoTask(ODistributedRequest iRequest, Object iBadResponse) {
        if (iBadResponse instanceof Throwable) {
            return null;
        }
        return new OResurrectRecordTask(this.rid, this.version);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.delayed);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.delayed = in.readBoolean();
    }

    @Override
    public String getName() {
        return "record_delete";
    }

    public ODeleteRecordTask setDelayed(boolean delayed) {
        this.delayed = delayed;
        return this;
    }

    @Override
    public String toString() {
        return super.toString() + " delayed=" + this.delayed;
    }
}

