/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class ODeployClusterTask
extends OAbstractReplicatedTask
implements OCommandOutputListener {
    public static final int CHUNK_MAX_SIZE = 0x100000;
    public static final String DEPLOYCLUSTER = "deploycluster.";
    protected long random;
    protected String clusterName;

    public ODeployClusterTask() {
    }

    public ODeployClusterTask(String iName) {
        this.random = UUID.randomUUID().getLeastSignificantBits();
        this.clusterName = iName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        if (!this.getNodeSource().equals(iManager.getLocalNodeName())) {
            if (database == null) {
                throw new ODistributedException("Database instance is null");
            }
            String databaseName = database.getName();
            ODistributedConfiguration dCfg = iManager.getDatabaseConfiguration(databaseName);
            if (!this.clusterName.equalsIgnoreCase(dCfg.getMasterServer(this.clusterName))) {
                return Boolean.FALSE;
            }
            Long lastDeployment = (Long)iManager.getConfigurationMap().get(DEPLOYCLUSTER + databaseName + "." + this.clusterName);
            if (lastDeployment != null && lastDeployment == this.random) {
                ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.NONE, "skip deploying cluster '%s' because already executed", this.clusterName);
                return Boolean.FALSE;
            }
            iManager.getConfigurationMap().put(DEPLOYCLUSTER + databaseName + "." + this.clusterName, this.random);
            ODistributedServerLog.warn((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "deploying cluster %s...", databaseName);
            File f = new File(Orient.getTempPath() + "/backup_" + database.getName() + "_" + this.clusterName + ".zip");
            if (f.exists()) {
                f.delete();
            } else {
                f.getParentFile().mkdirs();
            }
            f.createNewFile();
            ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "creating backup of cluster '%s' in directory: %s...", databaseName, f.getAbsolutePath());
            AtomicLong lastOperationId = new AtomicLong(-1L);
            FileOutputStream fileOutputStream = new FileOutputStream(f);
            try {
                OCluster cluster = database.getStorage().getClusterByName(this.clusterName);
                long fileSize = f.length();
                ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "sending the compressed cluster '%s.%s' over the NETWORK to node '%s', size=%s, lastOperationId=%d...", databaseName, this.clusterName, this.getNodeSource(), OFileUtils.getSizeAsString((long)fileSize), lastOperationId.get());
                ODistributedDatabaseChunk chunk = new ODistributedDatabaseChunk(lastOperationId.get(), f, 0L, 0x100000);
                ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "- transferring chunk #%d offset=%d size=%s...", 1, 0, OFileUtils.getSizeAsNumber((Object)chunk.buffer.length));
                if (chunk.last) {
                    iManager.setDatabaseStatus(iManager.getLocalNodeName(), databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
                }
                ODistributedDatabaseChunk oDistributedDatabaseChunk = chunk;
                return oDistributedDatabaseChunk;
            }
            finally {
                fileOutputStream.close();
            }
        }
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.NONE, "skip deploying cluster %s.%s from the same node", new Object[0]);
        return Boolean.FALSE;
    }

    @Override
    public OAbstractRemoteTask.RESULT_STRATEGY getResultStrategy() {
        return OAbstractRemoteTask.RESULT_STRATEGY.UNION;
    }

    @Override
    public OAbstractRemoteTask.QUORUM_TYPE getQuorumType() {
        return OAbstractRemoteTask.QUORUM_TYPE.NONE;
    }

    @Override
    public boolean isRequireNodeOnline() {
        return false;
    }

    @Override
    public long getTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public String getPayload() {
        return null;
    }

    @Override
    public String getName() {
        return "deploy_cluster";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.random);
        out.writeUTF(this.clusterName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.random = in.readLong();
        this.clusterName = in.readUTF();
    }

    public void onMessage(String iText) {
        if (iText.startsWith("\n")) {
            iText = iText.substring(1);
        }
        OLogManager.instance().info((Object)this, iText, new Object[0]);
    }

    @Override
    public boolean isRequiredOpenDatabase() {
        return true;
    }
}

