/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import java.util.Map;

public class OHttpRequestWrapper {
    private final OHttpRequest request;
    private final String[] args;

    public OHttpRequestWrapper(OHttpRequest iRequest) {
        this.request = iRequest;
        this.args = null;
    }

    public OHttpRequestWrapper(OHttpRequest iRequest, String[] iArgs) {
        this.request = iRequest;
        this.args = iArgs;
    }

    public String getContent() {
        return this.request.content;
    }

    public String getUser() {
        return this.request.getUser();
    }

    public String getContentType() {
        return this.request.contentType;
    }

    public String getHttpVersion() {
        return this.request.httpVersion;
    }

    public String getHttpMethod() {
        return this.request.httpMethod;
    }

    public String getIfMatch() {
        return this.request.ifMatch;
    }

    public boolean isMultipart() {
        return this.request.isMultipart;
    }

    public String[] getArguments() {
        return this.args;
    }

    public String getArgument(int iPosition) {
        return this.args != null && this.args.length > iPosition ? this.args[iPosition] : null;
    }

    public Map<String, String> getParameters() {
        return this.request.parameters;
    }

    public String getParameter(String iName) {
        return this.request.parameters != null ? this.request.parameters.get(iName) : null;
    }

    public int hasParameters(String ... iNames) {
        int found = 0;
        if (iNames != null && this.request.parameters != null) {
            for (String name : iNames) {
                found += this.request.parameters.containsKey(name) ? 1 : 0;
            }
        }
        return found;
    }

    public String getSessionId() {
        return this.request.sessionId;
    }

    public String getURL() {
        return this.request.url;
    }

    public String getRemoteAddress() {
        return this.request.getRemoteAddress();
    }
}

