/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.BundledSignaturesType;
import de.thetaphi.forbiddenapis.Checker;
import de.thetaphi.forbiddenapis.ForbiddenApiException;
import de.thetaphi.forbiddenapis.ParseException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.StringResource;

public final class AntTask
extends Task {
    private final Resources classFiles = new Resources();
    private final Resources apiSignatures = new Resources();
    private final List<BundledSignaturesType> bundledSignatures = new ArrayList<BundledSignaturesType>();
    private Path classpath = null;
    private boolean failOnUnsupportedJava = false;
    private boolean internalRuntimeForbidden = false;
    private boolean restrictClassFilename = true;
    private boolean failOnMissingClasses = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        AntClassLoader antLoader = null;
        try {
            String name;
            ClassLoader loader;
            if (this.classpath != null) {
                this.classpath.setProject(this.getProject());
                antLoader = this.getProject().createClassLoader(ClassLoader.getSystemClassLoader(), this.classpath);
                loader = antLoader;
                antLoader.setParentFirst(true);
            } else {
                loader = ClassLoader.getSystemClassLoader();
            }
            this.classFiles.setProject(this.getProject());
            this.apiSignatures.setProject(this.getProject());
            Checker checker = new Checker(loader, this.internalRuntimeForbidden, this.failOnMissingClasses, true){

                protected void logError(String msg) {
                    AntTask.this.log(msg, 0);
                }

                protected void logWarn(String msg) {
                    AntTask.this.log("WARNING: " + msg, 1);
                }

                protected void logInfo(String msg) {
                    AntTask.this.log(msg, 2);
                }
            };
            if (!checker.isSupportedJDK) {
                String msg = String.format(Locale.ENGLISH, "Your Java runtime (%s %s) is not supported by <%s/>. Please run the checks with a supported JDK!", System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version"), this.getTaskName());
                if (this.failOnUnsupportedJava) {
                    throw new BuildException(msg);
                }
                this.log("WARNING: " + msg, 1);
                return;
            }
            try {
                for (BundledSignaturesType bs : this.bundledSignatures) {
                    name = bs.getName();
                    if (name == null) {
                        throw new BuildException("<bundledSignatures/> must have the mandatory attribute 'name' referring to a bundled signatures file.");
                    }
                    this.log("Reading bundled API signatures: " + name, 2);
                    checker.parseBundledSignatures(name, null);
                }
                for (Resource r : this.apiSignatures) {
                    if (!r.isExists()) {
                        throw new BuildException("Signatures file does not exist: " + r);
                    }
                    if (r instanceof StringResource) {
                        String s = ((StringResource)r).getValue();
                        if (s == null || s.trim().length() <= 0) continue;
                        this.log("Reading inline API signatures...", 2);
                        checker.parseSignaturesString(s);
                        continue;
                    }
                    this.log("Reading API signatures: " + r, 2);
                    checker.parseSignaturesFile(r.getInputStream());
                }
            }
            catch (IOException ioe) {
                throw new BuildException("IO problem while reading files with API signatures: " + ioe);
            }
            catch (ParseException pe) {
                throw new BuildException("Parsing signatures failed: " + pe.getMessage());
            }
            if (checker.hasNoSignatures()) {
                throw new BuildException("No API signatures found; use signaturesFile=, <signaturesFileSet/>, <bundledSignatures/> or inner text to define those!");
            }
            this.log("Loading classes to check...", 2);
            try {
                Iterator iter = this.classFiles.iterator();
                if (!iter.hasNext()) {
                    throw new BuildException("There is no <fileset/> given or the fileset does not contain any class files to check.");
                }
                while (iter.hasNext()) {
                    Resource r;
                    r = (Resource)iter.next();
                    name = r.getName();
                    if (this.restrictClassFilename && name != null && !name.endsWith(".class")) continue;
                    if (!r.isExists()) {
                        throw new BuildException("Class file does not exist: " + r);
                    }
                    checker.addClassToCheck(r.getInputStream());
                }
            }
            catch (IOException ioe) {
                throw new BuildException("Failed to load one of the given class files:" + ioe);
            }
            this.log("Scanning for API signatures and dependencies...", 2);
            try {
                checker.run();
            }
            catch (ForbiddenApiException fae) {
                throw new BuildException(fae.getMessage());
            }
        }
        finally {
            if (antLoader != null) {
                antLoader.cleanup();
            }
        }
    }

    public void add(ResourceCollection rc) {
        this.classFiles.add(rc);
    }

    public void setDir(File dir) {
        FileSet fs = new FileSet();
        fs.setProject(this.getProject());
        fs.setDir(dir);
        fs.setIncludes("**/*.class");
        this.classFiles.add((ResourceCollection)fs);
    }

    public void setSignaturesFile(File file) {
        FileResource res = new FileResource(file);
        res.setProject(this.getProject());
        this.apiSignatures.add((ResourceCollection)res);
    }

    public FileSet createSignaturesFileSet() {
        FileSet fs = new FileSet();
        fs.setProject(this.getProject());
        this.apiSignatures.add((ResourceCollection)fs);
        return fs;
    }

    public BundledSignaturesType createBundledSignatures() {
        BundledSignaturesType s = new BundledSignaturesType();
        s.setProject(this.getProject());
        this.bundledSignatures.add(s);
        return s;
    }

    public void setBundledSignatures(String name) {
        BundledSignaturesType s = new BundledSignaturesType();
        s.setProject(this.getProject());
        s.setName(name);
        this.bundledSignatures.add(s);
    }

    public void addText(String text) {
        StringResource res = new StringResource(text);
        res.setProject(this.getProject());
        this.apiSignatures.add((ResourceCollection)res);
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setFailOnUnsupportedJava(boolean failOnUnsupportedJava) {
        this.failOnUnsupportedJava = failOnUnsupportedJava;
    }

    public void setFailOnMissingClasses(boolean failOnMissingClasses) {
        this.failOnMissingClasses = failOnMissingClasses;
    }

    public void setInternalRuntimeForbidden(boolean internalRuntimeForbidden) {
        this.internalRuntimeForbidden = internalRuntimeForbidden;
    }

    public void setRestrictClassFilename(boolean restrictClassFilename) {
        this.restrictClassFilename = restrictClassFilename;
    }
}

