/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.ClassSignatureLookup;
import de.thetaphi.forbiddenapis.ForbiddenApiException;
import de.thetaphi.forbiddenapis.ParseException;
import de.thetaphi.forbiddenapis.WrapperRuntimeException;
import de.thetaphi.forbiddenapis.asm.ClassReader;
import de.thetaphi.forbiddenapis.asm.ClassVisitor;
import de.thetaphi.forbiddenapis.asm.Handle;
import de.thetaphi.forbiddenapis.asm.Label;
import de.thetaphi.forbiddenapis.asm.MethodVisitor;
import de.thetaphi.forbiddenapis.asm.Type;
import de.thetaphi.forbiddenapis.asm.commons.Method;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class Checker {
    public final boolean isSupportedJDK;
    private final long start;
    final Set<File> bootClassPathJars;
    final Set<String> bootClassPathDirs;
    final ClassLoader loader;
    final boolean internalRuntimeForbidden;
    final boolean failOnMissingClasses;
    final boolean failOnUnresolvableSignatures;
    final Map<String, ClassSignatureLookup> classesToCheck = new HashMap<String, ClassSignatureLookup>();
    final Map<String, ClassSignatureLookup> classpathClassCache = new HashMap<String, ClassSignatureLookup>();
    final Map<String, String> forbiddenFields = new HashMap<String, String>();
    final Map<String, String> forbiddenMethods = new HashMap<String, String>();
    final Map<String, String> forbiddenClasses = new HashMap<String, String>();
    private static final String BUNDLED_PREFIX = "@includeBundled ";
    private static final String DEFAULT_MESSAGE_PREFIX = "@defaultMessage ";

    protected abstract void logError(String var1);

    protected abstract void logWarn(String var1);

    protected abstract void logInfo(String var1);

    public Checker(ClassLoader loader, boolean internalRuntimeForbidden, boolean failOnMissingClasses, boolean failOnUnresolvableSignatures) {
        this.loader = loader;
        this.internalRuntimeForbidden = internalRuntimeForbidden;
        this.failOnMissingClasses = failOnMissingClasses;
        this.failOnUnresolvableSignatures = failOnUnresolvableSignatures;
        this.start = System.currentTimeMillis();
        boolean isSupportedJDK = false;
        LinkedHashSet<File> bootClassPathJars = new LinkedHashSet<File>();
        LinkedHashSet<String> bootClassPathDirs = new LinkedHashSet<String>();
        try {
            RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
            if (rb.isBootClassPathSupported()) {
                String cp = rb.getBootClassPath();
                StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
                while (st.hasMoreTokens()) {
                    File f = new File(st.nextToken());
                    if (f.isFile()) {
                        bootClassPathJars.add(f.getCanonicalFile());
                        continue;
                    }
                    if (!f.isDirectory()) continue;
                    String fp = f.getCanonicalPath();
                    if (!fp.endsWith(File.separator)) {
                        fp = fp + File.separator;
                    }
                    bootClassPathDirs.add(fp);
                }
            }
            isSupportedJDK = !bootClassPathJars.isEmpty() || !bootClassPathDirs.isEmpty();
        }
        catch (IOException ioe) {
            isSupportedJDK = false;
            bootClassPathJars.clear();
            bootClassPathDirs.clear();
        }
        this.bootClassPathJars = Collections.unmodifiableSet(bootClassPathJars);
        this.bootClassPathDirs = Collections.unmodifiableSet(bootClassPathDirs);
        if (isSupportedJDK) {
            try {
                isSupportedJDK = this.getClassFromClassLoader((String)Object.class.getName(), (boolean)true).isRuntimeClass;
            }
            catch (IllegalArgumentException iae) {
                isSupportedJDK = false;
            }
            catch (ClassNotFoundException cnfe) {
                isSupportedJDK = false;
            }
        }
        this.isSupportedJDK = isSupportedJDK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassSignatureLookup getClassFromClassLoader(String clazz, boolean throwCNFE) throws ClassNotFoundException {
        ClassSignatureLookup c;
        if (this.classpathClassCache.containsKey(clazz)) {
            c = this.classpathClassCache.get(clazz);
            if (throwCNFE && c == null) {
                throw new ClassNotFoundException("Loading of class " + clazz + " failed: Not found");
            }
        } else {
            try {
                URL jarUrl;
                URL url = this.loader.getResource(clazz.replace('.', '/') + ".class");
                if (url == null) {
                    this.classpathClassCache.put(clazz, null);
                    if (throwCNFE) {
                        throw new ClassNotFoundException("Loading of class " + clazz + " failed: Not found");
                    }
                    return null;
                }
                boolean isRuntimeClass = false;
                URLConnection conn = url.openConnection();
                if ("file".equalsIgnoreCase(url.getProtocol())) {
                    try {
                        String path = new File(url.toURI()).getCanonicalPath();
                        for (String bcpDir : this.bootClassPathDirs) {
                            if (!path.startsWith(bcpDir)) continue;
                            isRuntimeClass = true;
                        }
                    }
                    catch (URISyntaxException use) {}
                } else if (conn instanceof JarURLConnection && "file".equalsIgnoreCase((jarUrl = ((JarURLConnection)conn).getJarFileURL()).getProtocol())) {
                    try {
                        File jarFile = new File(jarUrl.toURI()).getCanonicalFile();
                        isRuntimeClass = this.bootClassPathJars.contains(jarFile);
                    }
                    catch (URISyntaxException use) {
                        // empty catch block
                    }
                }
                InputStream in = conn.getInputStream();
                try {
                    c = new ClassSignatureLookup(new ClassReader(in), isRuntimeClass, false);
                    this.classpathClassCache.put(clazz, c);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ioe) {
                this.classpathClassCache.put(clazz, null);
                if (throwCNFE) {
                    throw new ClassNotFoundException("Loading of class " + clazz + " failed.", ioe);
                }
                return null;
            }
        }
        return c;
    }

    private void addSignature(String line, String defaultMessage) throws ParseException {
        ClassSignatureLookup c;
        String field;
        Method method;
        String clazz;
        String message;
        String signature;
        int p = line.indexOf(64);
        if (p >= 0) {
            signature = line.substring(0, p).trim();
            message = line.substring(p + 1).trim();
        } else {
            signature = line;
            message = defaultMessage;
        }
        p = signature.indexOf(35);
        if (p >= 0) {
            clazz = signature.substring(0, p);
            String s = signature.substring(p + 1);
            if ((p = s.indexOf(40)) >= 0) {
                if (p == 0) {
                    throw new ParseException("Invalid method signature (method name missing): " + signature);
                }
                try {
                    method = Method.getMethod("void " + s, true);
                }
                catch (IllegalArgumentException iae) {
                    throw new ParseException("Invalid method signature: " + signature);
                }
                field = null;
            } else {
                field = s;
                method = null;
            }
        } else {
            clazz = signature;
            method = null;
            field = null;
        }
        String printout = message != null && message.length() > 0 ? signature + " [" + message + "]" : signature;
        try {
            c = this.getClassFromClassLoader(clazz, this.failOnUnresolvableSignatures);
            if (c == null) {
                this.logWarn(String.format(Locale.ENGLISH, "The class '%s' referenced in a signature cannot be loaded, ignoring signature: %s", clazz, signature));
                return;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new ParseException(cnfe.getMessage());
        }
        if (method != null) {
            assert (field == null);
            boolean found = false;
            for (Method m : c.methods) {
                if (!m.getName().equals(method.getName()) || !Arrays.equals(m.getArgumentTypes(), method.getArgumentTypes())) continue;
                found = true;
                this.forbiddenMethods.put(c.className + '\u0000' + m, printout);
            }
            if (!found) {
                throw new ParseException("No method found with following signature: " + signature);
            }
        } else if (field != null) {
            assert (method == null);
            if (!c.fields.contains(field)) {
                throw new ParseException("No field found with following name: " + signature);
            }
            this.forbiddenFields.put(c.className + '\u0000' + field, printout);
        } else {
            assert (field == null && method == null);
            this.forbiddenClasses.put(c.className, printout);
        }
    }

    public final void parseBundledSignatures(String name, String jdkTargetVersion) throws IOException, ParseException {
        if (!name.matches("[A-Za-z0-9\\-\\.]+")) {
            throw new ParseException("Invalid bundled signature reference: " + name);
        }
        InputStream in = this.getClass().getResourceAsStream("signatures/" + name + ".txt");
        if (in == null && jdkTargetVersion != null && name.startsWith("jdk-") && !name.matches(".*?\\-\\d\\.\\d")) {
            in = this.getClass().getResourceAsStream("signatures/" + name + "-" + jdkTargetVersion + ".txt");
        }
        if (in == null) {
            throw new FileNotFoundException("Bundled signatures resource not found: " + name);
        }
        this.parseSignaturesFile(in, true);
    }

    public final void parseSignaturesFile(InputStream in) throws IOException, ParseException {
        this.parseSignaturesFile(in, false);
    }

    public final void parseSignaturesString(String signatures) throws IOException, ParseException {
        this.parseSignaturesFile(new StringReader(signatures), false);
    }

    private void parseSignaturesFile(InputStream in, boolean allowBundled) throws IOException, ParseException {
        this.parseSignaturesFile(new InputStreamReader(in, "UTF-8"), allowBundled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSignaturesFile(Reader reader, boolean allowBundled) throws IOException, ParseException {
        BufferedReader r = new BufferedReader(reader);
        try {
            String line;
            String defaultMessage = null;
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith("@")) {
                    if (allowBundled && line.startsWith(BUNDLED_PREFIX)) {
                        String name = line.substring(BUNDLED_PREFIX.length()).trim();
                        this.parseBundledSignatures(name, null);
                        continue;
                    }
                    if (line.startsWith(DEFAULT_MESSAGE_PREFIX)) {
                        defaultMessage = line.substring(DEFAULT_MESSAGE_PREFIX.length()).trim();
                        if (defaultMessage.length() != 0) continue;
                        defaultMessage = null;
                        continue;
                    }
                    throw new ParseException("Invalid line in signature file: " + line);
                }
                this.addSignature(line, defaultMessage);
            }
        }
        finally {
            r.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addClassToCheck(InputStream in) throws IOException {
        ClassReader reader;
        try {
            reader = new ClassReader(in);
        }
        finally {
            in.close();
        }
        this.classesToCheck.put(reader.getClassName(), new ClassSignatureLookup(reader, false, true));
    }

    public final boolean hasNoSignatures() {
        return this.forbiddenMethods.isEmpty() && this.forbiddenClasses.isEmpty() && this.forbiddenFields.isEmpty() && !this.internalRuntimeForbidden;
    }

    private int checkClass(final ClassReader reader) {
        final int[] violations = new int[1];
        reader.accept(new ClassVisitor(327680){
            final String className;
            String source;
            {
                super(x0);
                this.className = Type.getObjectType(reader.getClassName()).getClassName();
                this.source = null;
            }

            ClassSignatureLookup lookupRelatedClass(String internalName) {
                Type type = Type.getObjectType(internalName);
                if (type.getSort() != 10) {
                    return null;
                }
                ClassSignatureLookup c = Checker.this.classesToCheck.get(internalName);
                if (c == null) {
                    try {
                        c = Checker.this.getClassFromClassLoader(type.getClassName(), Checker.this.failOnMissingClasses);
                        if (c == null) {
                            Checker.this.logWarn(String.format(Locale.ENGLISH, "The referenced class '%s' cannot be loaded. Please fix the classpath!", type.getClassName()));
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new WrapperRuntimeException(cnfe);
                    }
                }
                return c;
            }

            private boolean isInternalClass(String className) {
                return className.startsWith("sun.") || className.startsWith("com.sun.") || className.startsWith("com.oracle.") || className.startsWith("jdk.") || className.startsWith("sunw.");
            }

            boolean checkClassUse(String internalName) {
                ClassSignatureLookup c;
                String referencedClassName;
                String printout = Checker.this.forbiddenClasses.get(internalName);
                if (printout != null) {
                    Checker.this.logError("Forbidden class/interface use: " + printout);
                    return true;
                }
                if (Checker.this.internalRuntimeForbidden && this.isInternalClass(referencedClassName = Type.getObjectType(internalName).getClassName()) && ((c = this.lookupRelatedClass(internalName)) == null || c.isRuntimeClass)) {
                    Checker.this.logError(String.format(Locale.ENGLISH, "Forbidden class/interface use: %s [non-public internal runtime class]", referencedClassName));
                    return true;
                }
                return false;
            }

            private boolean checkClassDefinition(String superName, String[] interfaces) {
                if (superName != null) {
                    if (this.checkClassUse(superName)) {
                        return true;
                    }
                    ClassSignatureLookup c = this.lookupRelatedClass(superName);
                    if (c != null && this.checkClassDefinition(c.superName, c.interfaces)) {
                        return true;
                    }
                }
                if (interfaces != null) {
                    for (String intf : interfaces) {
                        if (this.checkClassUse(intf)) {
                            return true;
                        }
                        ClassSignatureLookup c = this.lookupRelatedClass(intf);
                        if (c == null || !this.checkClassDefinition(c.superName, c.interfaces)) continue;
                        return true;
                    }
                }
                return false;
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if (this.checkClassDefinition(superName, interfaces)) {
                    violations[0] = violations[0] + 1;
                    Checker.this.logError("  in " + this.className + " (class declaration)");
                }
            }

            public void visitSource(String source, String debug) {
                this.source = source;
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return new MethodVisitor(327680){
                    private int lineNo;
                    {
                        this.lineNo = -1;
                    }

                    private boolean checkMethodAccess(String owner, Method method) {
                        if (this.checkClassUse(owner)) {
                            return true;
                        }
                        String printout = Checker.this.forbiddenMethods.get(owner + '\u0000' + method);
                        if (printout != null) {
                            Checker.this.logError("Forbidden method invocation: " + printout);
                            return true;
                        }
                        ClassSignatureLookup c = this.lookupRelatedClass(owner);
                        if (c != null && !c.methods.contains(method)) {
                            if (c.superName != null && this.checkMethodAccess(c.superName, method)) {
                                return true;
                            }
                            if (c.interfaces != null) {
                                for (String intf : c.interfaces) {
                                    if (intf == null || !this.checkMethodAccess(intf, method)) continue;
                                    return true;
                                }
                            }
                        }
                        return false;
                    }

                    private boolean checkFieldAccess(String owner, String field) {
                        if (this.checkClassUse(owner)) {
                            return true;
                        }
                        String printout = Checker.this.forbiddenFields.get(owner + '\u0000' + field);
                        if (printout != null) {
                            Checker.this.logError("Forbidden field access: " + printout);
                            return true;
                        }
                        ClassSignatureLookup c = this.lookupRelatedClass(owner);
                        if (c != null && !c.fields.contains(field)) {
                            if (c.interfaces != null) {
                                for (String intf : c.interfaces) {
                                    if (intf == null || !this.checkFieldAccess(intf, field)) continue;
                                    return true;
                                }
                            }
                            if (c.superName != null && this.checkFieldAccess(c.superName, field)) {
                                return true;
                            }
                        }
                        return false;
                    }

                    private boolean checkType(Type type) {
                        block4: while (type != null) {
                            switch (type.getSort()) {
                                case 10: {
                                    return this.checkClassUse(type.getInternalName());
                                }
                                case 9: {
                                    type = type.getElementType();
                                    continue block4;
                                }
                            }
                            return false;
                        }
                        return false;
                    }

                    private boolean checkHandle(Handle handle) {
                        switch (handle.getTag()) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                return this.checkFieldAccess(handle.getOwner(), handle.getName());
                            }
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                return this.checkMethodAccess(handle.getOwner(), new Method(handle.getName(), handle.getDesc()));
                            }
                        }
                        return false;
                    }

                    private boolean checkConstant(Object cst) {
                        return cst instanceof Type ? this.checkType((Type)cst) : cst instanceof Handle && this.checkHandle((Handle)cst);
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                        if (this.checkMethodAccess(owner, new Method(name, desc))) {
                            this.reportViolation();
                        }
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        if (this.checkFieldAccess(owner, name)) {
                            this.reportViolation();
                        }
                    }

                    public void visitTypeInsn(int opcode, String type) {
                        if (opcode == 189 && this.checkType(Type.getObjectType(type))) {
                            this.reportViolation();
                        }
                    }

                    public void visitMultiANewArrayInsn(String desc, int dims) {
                        if (this.checkType(Type.getType(desc))) {
                            this.reportViolation();
                        }
                    }

                    public void visitLdcInsn(Object cst) {
                        if (this.checkConstant(cst)) {
                            this.reportViolation();
                        }
                    }

                    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
                        if (this.checkHandle(bsm)) {
                            this.reportViolation();
                        }
                        for (Object cst : bsmArgs) {
                            if (!this.checkConstant(cst)) continue;
                            this.reportViolation();
                        }
                    }

                    private void reportViolation() {
                        violations[0] = violations[0] + 1;
                        StringBuilder sb = new StringBuilder("  in ").append(className);
                        if (source != null && this.lineNo >= 0) {
                            new Formatter(sb, Locale.ENGLISH).format(" (%s:%d)", source, this.lineNo).flush();
                        }
                        Checker.this.logError(sb.toString());
                    }

                    public void visitLineNumber(int lineNo, Label start) {
                        this.lineNo = lineNo;
                    }
                };
            }
        }, 4);
        return violations[0];
    }

    public final void run() throws ForbiddenApiException {
        int errors = 0;
        try {
            for (ClassSignatureLookup c : this.classesToCheck.values()) {
                errors += this.checkClass(c.getReader());
            }
        }
        catch (WrapperRuntimeException wre) {
            Throwable cause = wre.getCause();
            throw new ForbiddenApiException("Check for forbidden API calls failed: " + cause.toString());
        }
        String message = String.format(Locale.ENGLISH, "Scanned %d (and %d related) class file(s) for forbidden API invocations (in %.2fs), %d error(s).", this.classesToCheck.size(), this.classesToCheck.isEmpty() ? 0 : this.classpathClassCache.size(), (double)(System.currentTimeMillis() - this.start) / 1000.0, errors);
        if (errors > 0) {
            this.logError(message);
            throw new ForbiddenApiException("Check for forbidden API calls failed, see log.");
        }
        this.logInfo(message);
    }
}

