/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.airlift.log.Logger;
import java.util.concurrent.ThreadFactory;

public final class Threads {
    private static final Logger log = Logger.get(Threads.class);

    private Threads() {
    }

    public static ThreadFactory threadsNamed(String nameFormat) {
        GroupedThreadFactory delegate = new GroupedThreadFactory(Threads.threadGroupName(nameFormat));
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).setThreadFactory((ThreadFactory)new ContextClassLoaderThreadFactory(Thread.currentThread().getContextClassLoader(), delegate)).build();
    }

    public static ThreadFactory daemonThreadsNamed(String nameFormat) {
        GroupedThreadFactory delegate = new GroupedThreadFactory(Threads.threadGroupName(nameFormat));
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).setDaemon(true).setThreadFactory((ThreadFactory)new ContextClassLoaderThreadFactory(Thread.currentThread().getContextClassLoader(), delegate)).build();
    }

    private static String threadGroupName(String nameFormat) {
        String groupFormat = nameFormat.replace("%d", "%s");
        if (!nameFormat.equals(groupFormat)) {
            log.warn("Invalid thread group nameFormat: %s", new Object[]{nameFormat});
        }
        return String.format(groupFormat, "group");
    }

    private static final class GroupedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup threadGroup;

        public GroupedThreadFactory(String name) {
            this(new ThreadGroup(name));
        }

        public GroupedThreadFactory(ThreadGroup threadGroup) {
            this.threadGroup = threadGroup;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(this.threadGroup, runnable);
        }
    }

    private static class ContextClassLoaderThreadFactory
    implements ThreadFactory {
        private final ClassLoader classLoader;
        private final ThreadFactory delegate;

        public ContextClassLoaderThreadFactory(ClassLoader classLoader, ThreadFactory delegate) {
            this.classLoader = classLoader;
            this.delegate = delegate;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.delegate.newThread(runnable);
            thread.setContextClassLoader(this.classLoader);
            return thread;
        }
    }
}

