/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.lda;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.io.Charsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.IntPairWritable;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.utils.vectors.VectorHelper;

public final class LDAPrintTopics {
    private LDAPrintTopics() {
    }

    private static void ensureQueueSize(Collection<Queue<Pair<String, Double>>> queues, int k) {
        for (int i = queues.size(); i <= k; ++i) {
            queues.add(new PriorityQueue());
        }
    }

    public static void main(String[] args) throws Exception {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption inputOpt = DefaultOptionCreator.inputOption().create();
        DefaultOption dictOpt = obuilder.withLongName("dict").withRequired(true).withArgument(abuilder.withName("dict").withMinimum(1).withMaximum(1).create()).withDescription("Dictionary to read in, in the same format as one created by org.apache.mahout.utils.vectors.lucene.Driver").withShortName("d").create();
        DefaultOption outOpt = DefaultOptionCreator.outputOption().create();
        DefaultOption wordOpt = obuilder.withLongName("words").withRequired(false).withArgument(abuilder.withName("words").withMinimum(0).withMaximum(1).withDefault((Object)"20").create()).withDescription("Number of words to print").withShortName("w").create();
        DefaultOption dictTypeOpt = obuilder.withLongName("dictionaryType").withRequired(false).withArgument(abuilder.withName("dictionaryType").withMinimum(1).withMaximum(1).create()).withDescription("The dictionary file type (text|sequencefile)").withShortName("dt").create();
        DefaultOption helpOpt = obuilder.withLongName("help").withDescription("Print out help").withShortName("h").create();
        Group group = gbuilder.withName("Options").withOption((Option)dictOpt).withOption((Option)outOpt).withOption((Option)wordOpt).withOption((Option)inputOpt).withOption((Option)dictTypeOpt).create();
        try {
            List<String> wordList;
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption((Option)helpOpt)) {
                CommandLineUtil.printHelp((Group)group);
                return;
            }
            String input = cmdLine.getValue((Option)inputOpt).toString();
            String dictFile = cmdLine.getValue((Option)dictOpt).toString();
            int numWords = 20;
            if (cmdLine.hasOption((Option)wordOpt)) {
                numWords = Integer.parseInt(cmdLine.getValue((Option)wordOpt).toString());
            }
            Configuration config = new Configuration();
            String dictionaryType = "text";
            if (cmdLine.hasOption((Option)dictTypeOpt)) {
                dictionaryType = cmdLine.getValue((Option)dictTypeOpt).toString();
            }
            if ("text".equals(dictionaryType)) {
                wordList = Arrays.asList(VectorHelper.loadTermDictionary(new File(dictFile)));
            } else if ("sequencefile".equals(dictionaryType)) {
                wordList = Arrays.asList(VectorHelper.loadTermDictionary(config, dictFile));
            } else {
                throw new IllegalArgumentException("Invalid dictionary format");
            }
            List<Queue<Pair<String, Double>>> topWords = LDAPrintTopics.topWordsForTopics(input, config, wordList, numWords);
            File output = null;
            if (cmdLine.hasOption((Option)outOpt) && !(output = new File(cmdLine.getValue((Option)outOpt).toString())).exists() && !output.mkdirs()) {
                throw new IOException("Could not create directory: " + output);
            }
            LDAPrintTopics.printTopWords(topWords, output);
        }
        catch (OptionException e) {
            CommandLineUtil.printHelp((Group)group);
            throw e;
        }
    }

    private static void maybeEnqueue(Queue<Pair<String, Double>> q, String word, double score, int numWordsToPrint) {
        if (q.size() >= numWordsToPrint && score > (Double)q.peek().getSecond()) {
            q.poll();
        }
        if (q.size() < numWordsToPrint) {
            q.add((Pair<String, Double>)new Pair((Object)word, (Object)score));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printTopWords(List<Queue<Pair<String, Double>>> topWords, File outputDir) throws IOException {
        for (int i = 0; i < topWords.size(); ++i) {
            Collection topK = topWords.get(i);
            Writer out = null;
            boolean printingToSystemOut = false;
            try {
                if (outputDir != null) {
                    out = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(outputDir, "topic_" + i)), Charsets.UTF_8);
                } else {
                    out = new OutputStreamWriter((OutputStream)System.out, Charsets.UTF_8);
                    printingToSystemOut = true;
                    out.write("Topic " + i);
                    out.write(10);
                    out.write("===========");
                    out.write(10);
                }
                ArrayList<Pair> topKasList = new ArrayList<Pair>(topK.size());
                for (Pair wordWithScore : topK) {
                    topKasList.add(wordWithScore);
                }
                Collections.sort(topKasList, new Comparator<Pair<String, Double>>(){

                    @Override
                    public int compare(Pair<String, Double> pair1, Pair<String, Double> pair2) {
                        return ((Double)pair2.getSecond()).compareTo((Double)pair1.getSecond());
                    }
                });
                for (Pair wordWithScore : topKasList) {
                    out.write((String)wordWithScore.getFirst() + " [p(" + (String)wordWithScore.getFirst() + "|topic_" + i + ") = " + wordWithScore.getSecond());
                    out.write(10);
                }
                continue;
            }
            finally {
                if (!printingToSystemOut) {
                    Closeables.close((Closeable)out, (boolean)false);
                } else {
                    out.flush();
                }
            }
        }
    }

    private static List<Queue<Pair<String, Double>>> topWordsForTopics(String dir, Configuration job, List<String> wordList, int numWordsToPrint) {
        ArrayList<Queue<Pair<String, Double>>> queues = new ArrayList<Queue<Pair<String, Double>>>();
        HashMap<Integer, Double> expSums = new HashMap<Integer, Double>();
        for (Pair record : new SequenceFileDirIterable(new Path(dir, "part-*"), PathType.GLOB, null, null, true, job)) {
            IntPairWritable key = (IntPairWritable)record.getFirst();
            int topic = key.getFirst();
            int word = key.getSecond();
            LDAPrintTopics.ensureQueueSize(queues, topic);
            if (word < 0 || topic < 0) continue;
            double score = ((DoubleWritable)record.getSecond()).get();
            if (expSums.get(topic) == null) {
                expSums.put(topic, 0.0);
            }
            expSums.put(topic, (Double)expSums.get(topic) + Math.exp(score));
            String realWord = wordList.get(word);
            LDAPrintTopics.maybeEnqueue((Queue)queues.get(topic), realWord, score, numWordsToPrint);
        }
        for (int i = 0; i < queues.size(); ++i) {
            Queue queue = (Queue)queues.get(i);
            PriorityQueue<Pair> newQueue = new PriorityQueue<Pair>(queue.size());
            double norm = (Double)expSums.get(i);
            for (Pair pair : queue) {
                newQueue.add(new Pair(pair.getFirst(), (Object)(Math.exp((Double)pair.getSecond()) / norm)));
            }
            queues.set(i, newQueue);
        }
        return queues;
    }
}

