/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.odf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.odf.OpenDocumentContentParser;
import org.apache.tika.parser.odf.OpenDocumentMetaParser;
import org.apache.tika.sax.EndDocumentShieldingContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OpenDocumentParser
extends AbstractParser {
    private static final long serialVersionUID = -6410276875438618287L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"vnd.sun.xml.writer"), MediaType.application((String)"vnd.oasis.opendocument.text"), MediaType.application((String)"vnd.oasis.opendocument.graphics"), MediaType.application((String)"vnd.oasis.opendocument.presentation"), MediaType.application((String)"vnd.oasis.opendocument.spreadsheet"), MediaType.application((String)"vnd.oasis.opendocument.chart"), MediaType.application((String)"vnd.oasis.opendocument.image"), MediaType.application((String)"vnd.oasis.opendocument.formula"), MediaType.application((String)"vnd.oasis.opendocument.text-master"), MediaType.application((String)"vnd.oasis.opendocument.text-web"), MediaType.application((String)"vnd.oasis.opendocument.text-template"), MediaType.application((String)"vnd.oasis.opendocument.graphics-template"), MediaType.application((String)"vnd.oasis.opendocument.presentation-template"), MediaType.application((String)"vnd.oasis.opendocument.spreadsheet-template"), MediaType.application((String)"vnd.oasis.opendocument.chart-template"), MediaType.application((String)"vnd.oasis.opendocument.image-template"), MediaType.application((String)"vnd.oasis.opendocument.formula-template"), MediaType.application((String)"x-vnd.oasis.opendocument.text"), MediaType.application((String)"x-vnd.oasis.opendocument.graphics"), MediaType.application((String)"x-vnd.oasis.opendocument.presentation"), MediaType.application((String)"x-vnd.oasis.opendocument.spreadsheet"), MediaType.application((String)"x-vnd.oasis.opendocument.chart"), MediaType.application((String)"x-vnd.oasis.opendocument.image"), MediaType.application((String)"x-vnd.oasis.opendocument.formula"), MediaType.application((String)"x-vnd.oasis.opendocument.text-master"), MediaType.application((String)"x-vnd.oasis.opendocument.text-web"), MediaType.application((String)"x-vnd.oasis.opendocument.text-template"), MediaType.application((String)"x-vnd.oasis.opendocument.graphics-template"), MediaType.application((String)"x-vnd.oasis.opendocument.presentation-template"), MediaType.application((String)"x-vnd.oasis.opendocument.spreadsheet-template"), MediaType.application((String)"x-vnd.oasis.opendocument.chart-template"), MediaType.application((String)"x-vnd.oasis.opendocument.image-template"), MediaType.application((String)"x-vnd.oasis.opendocument.formula-template"))));
    private static final String META_NAME = "meta.xml";
    private Parser meta = new OpenDocumentMetaParser();
    private Parser content = new OpenDocumentContentParser();

    public Parser getMetaParser() {
        return this.meta;
    }

    public void setMetaParser(Parser meta) {
        this.meta = meta;
    }

    public Parser getContentParser() {
        return this.content;
    }

    public void setContentParser(Parser content) {
        this.content = content;
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler baseHandler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ZipFile zipFile = null;
        ZipInputStream zipStream = null;
        if (stream instanceof TikaInputStream) {
            TikaInputStream tis = (TikaInputStream)stream;
            Object container = ((TikaInputStream)stream).getOpenContainer();
            if (container instanceof ZipFile) {
                zipFile = (ZipFile)container;
            } else if (tis.hasFile()) {
                zipFile = new ZipFile(tis.getFile());
            }
        } else {
            zipStream = new ZipInputStream(stream);
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(baseHandler, metadata);
        EndDocumentShieldingContentHandler handler = new EndDocumentShieldingContentHandler((ContentHandler)xhtml);
        ZipEntry entry = null;
        if (zipFile != null) {
            entry = zipFile.getEntry(META_NAME);
            this.handleZipEntry(entry, zipFile.getInputStream(entry), metadata, context, handler);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (META_NAME.equals(entry.getName())) continue;
                this.handleZipEntry(entry, zipFile.getInputStream(entry), metadata, context, handler);
            }
            zipFile.close();
        } else {
            do {
                entry = zipStream.getNextEntry();
                this.handleZipEntry(entry, zipStream, metadata, context, handler);
            } while (entry != null);
            zipStream.close();
        }
        if (handler.getEndDocumentWasCalled()) {
            handler.reallyEndDocument();
        }
    }

    private void handleZipEntry(ZipEntry entry, InputStream zip, Metadata metadata, ParseContext context, EndDocumentShieldingContentHandler handler) throws IOException, SAXException, TikaException {
        if (entry == null) {
            return;
        }
        if (entry.getName().equals("mimetype")) {
            String type = IOUtils.toString((InputStream)zip, (String)"UTF-8");
            metadata.set("Content-Type", type);
        } else if (entry.getName().equals(META_NAME)) {
            this.meta.parse(zip, (ContentHandler)new DefaultHandler(), metadata, context);
        } else if (entry.getName().endsWith("content.xml")) {
            if (this.content instanceof OpenDocumentContentParser) {
                ((OpenDocumentContentParser)this.content).parseInternal(zip, (ContentHandler)handler, metadata, context);
            } else {
                this.content.parse(zip, (ContentHandler)handler, metadata, context);
            }
        } else if (entry.getName().endsWith("styles.xml")) {
            if (this.content instanceof OpenDocumentContentParser) {
                ((OpenDocumentContentParser)this.content).parseInternal(zip, (ContentHandler)handler, metadata, context);
            } else {
                this.content.parse(zip, (ContentHandler)handler, metadata, context);
            }
        }
    }
}

