/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.ast.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.gcontracts.ClassInvariantViolation;
import org.gcontracts.PostconditionViolation;
import org.gcontracts.PreconditionViolation;
import org.gcontracts.annotations.meta.AnnotationContract;
import org.gcontracts.annotations.meta.ContractElement;
import org.gcontracts.annotations.meta.Postcondition;
import org.gcontracts.ast.visitor.BaseVisitor;
import org.gcontracts.classgen.asm.ClosureWriter;
import org.gcontracts.generation.AssertStatementCreationUtility;
import org.gcontracts.generation.CandidateChecks;
import org.gcontracts.generation.TryCatchBlockGenerator;
import org.gcontracts.util.AnnotationUtils;
import org.gcontracts.util.ExpressionUtils;
import org.gcontracts.util.Validate;

public class AnnotationClosureVisitor
extends BaseVisitor {
    private ClassNode classNode;
    private final ClosureWriter closureWriter = new ClosureWriter();

    public AnnotationClosureVisitor(SourceUnit sourceUnit, ReaderSource source) {
        super(sourceUnit, source);
    }

    public void visitClass(ClassNode node) {
        if (!CandidateChecks.isInterfaceContractsCandidate(node) && !CandidateChecks.isContractsCandidate(node)) {
            return;
        }
        this.classNode = node;
        if (CandidateChecks.isContractsCandidate(node)) {
            List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations((AnnotatedNode)node, ContractElement.class.getName());
            for (AnnotationNode annotationNode : annotationNodes) {
                ClosureExpression closureExpression = (ClosureExpression)annotationNode.getMember("value");
                if (closureExpression == null) continue;
                ArrayList<Parameter> parameters = new ArrayList<Parameter>(Arrays.asList(closureExpression.getParameters()));
                List<BooleanExpression> booleanExpressions = ExpressionUtils.getBooleanExpression(closureExpression);
                if (booleanExpressions == null || booleanExpressions.isEmpty()) continue;
                BlockStatement closureBlockStatement = (BlockStatement)closureExpression.getCode();
                BlockStatement newClosureBlockStatement = TryCatchBlockGenerator.generateTryCatchBlock(ClassHelper.makeWithoutCaching(ClassInvariantViolation.class), "<" + annotationNode.getClassNode().getName() + "> " + this.classNode.getName() + " \n\n", (Statement)AssertStatementCreationUtility.getAssertionStatemens(booleanExpressions));
                newClosureBlockStatement.setSourcePosition((ASTNode)closureBlockStatement);
                ClosureExpression rewrittenClosureExpression = new ClosureExpression(parameters.toArray(new Parameter[parameters.size()]), (Statement)newClosureBlockStatement);
                rewrittenClosureExpression.setSourcePosition((ASTNode)closureExpression);
                rewrittenClosureExpression.setDeclaringClass(closureExpression.getDeclaringClass());
                rewrittenClosureExpression.setSynthetic(true);
                rewrittenClosureExpression.setVariableScope(closureExpression.getVariableScope());
                rewrittenClosureExpression.setType(closureExpression.getType());
                ClassNode closureClassNode = this.closureWriter.createClosureClass(this.classNode, null, rewrittenClosureExpression, false, false, 1);
                this.classNode.getModule().addClass(closureClassNode);
                ClassExpression value = new ClassExpression(closureClassNode);
                value.setSourcePosition((ASTNode)annotationNode);
                annotationNode.setMember("value", (Expression)value);
            }
        }
        if (AnnotationUtils.hasAnnotationOfType((AnnotatedNode)node, AnnotationContract.class.getName())) {
            List annotationProcessorClosureAnno = node.getAnnotations(ClassHelper.makeWithoutCaching((String)AnnotationContract.class.getName()));
            for (AnnotationNode annotationNode : annotationProcessorClosureAnno) {
                this.replaceWithAnnotationProcessorClosureWithClassReference(node, annotationNode);
            }
        }
        super.visitClass(node);
    }

    public void visitConstructorOrMethod(MethodNode methodNode, boolean isConstructor) {
        if (!CandidateChecks.couldBeContractElementMethodNode(this.classNode, methodNode) && !CandidateChecks.isPreconditionCandidate(this.classNode, methodNode)) {
            return;
        }
        List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations((AnnotatedNode)methodNode, ContractElement.class.getName());
        for (AnnotationNode annotationNode : annotationNodes) {
            this.replaceWithClosureClassReference(annotationNode, methodNode);
        }
        super.visitConstructorOrMethod(methodNode, isConstructor);
    }

    private void replaceWithClosureClassReference(AnnotationNode annotationNode, MethodNode methodNode) {
        Validate.notNull(annotationNode);
        Validate.notNull(methodNode);
        boolean isPostcondition = AnnotationUtils.hasAnnotationOfType((AnnotatedNode)annotationNode.getClassNode(), Postcondition.class.getName());
        ClosureExpression closureExpression = (ClosureExpression)annotationNode.getMember("value");
        if (closureExpression == null) {
            return;
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(Arrays.asList(closureExpression.getParameters()));
        parameters.addAll(new ArrayList<Parameter>(Arrays.asList(methodNode.getParameters())));
        List<BooleanExpression> booleanExpressions = ExpressionUtils.getBooleanExpression(closureExpression);
        if (booleanExpressions == null || booleanExpressions.isEmpty()) {
            return;
        }
        BlockStatement closureBlockStatement = (BlockStatement)closureExpression.getCode();
        BlockStatement newClosureBlockStatement = TryCatchBlockGenerator.generateTryCatchBlock(isPostcondition ? ClassHelper.makeWithoutCaching(PostconditionViolation.class) : ClassHelper.makeWithoutCaching(PreconditionViolation.class), "<" + annotationNode.getClassNode().getName() + "> " + this.classNode.getName() + "." + methodNode.getTypeDescriptor() + " \n\n", (Statement)AssertStatementCreationUtility.getAssertionStatemens(booleanExpressions));
        newClosureBlockStatement.setSourcePosition((ASTNode)closureBlockStatement);
        ClosureExpression rewrittenClosureExpression = new ClosureExpression(parameters.toArray(new Parameter[parameters.size()]), (Statement)newClosureBlockStatement);
        rewrittenClosureExpression.setSourcePosition((ASTNode)closureExpression);
        rewrittenClosureExpression.setDeclaringClass(closureExpression.getDeclaringClass());
        rewrittenClosureExpression.setSynthetic(true);
        rewrittenClosureExpression.setVariableScope(closureExpression.getVariableScope());
        rewrittenClosureExpression.setType(closureExpression.getType());
        boolean isConstructor = methodNode instanceof ConstructorNode;
        ClassNode closureClassNode = this.closureWriter.createClosureClass(this.classNode, methodNode, rewrittenClosureExpression, isPostcondition && !isConstructor, isPostcondition && !isConstructor, 1);
        this.classNode.getModule().addClass(closureClassNode);
        ClassExpression value = new ClassExpression(closureClassNode);
        value.setSourcePosition((ASTNode)annotationNode);
        annotationNode.setMember("value", (Expression)value);
    }

    private void replaceWithAnnotationProcessorClosureWithClassReference(ClassNode annotation, AnnotationNode processorAnnotationNode) {
        Validate.notNull(annotation);
        Validate.notNull(processorAnnotationNode);
        boolean isPostcondition = AnnotationUtils.hasAnnotationOfType((AnnotatedNode)annotation, Postcondition.class.getName());
        ClosureExpression closureExpression = (ClosureExpression)processorAnnotationNode.getMember("value");
        if (closureExpression == null) {
            return;
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(Arrays.asList(closureExpression.getParameters()));
        List<BooleanExpression> booleanExpressions = ExpressionUtils.getBooleanExpression(closureExpression);
        if (booleanExpressions == null || booleanExpressions.isEmpty()) {
            return;
        }
        BlockStatement closureBlockStatement = (BlockStatement)closureExpression.getCode();
        BlockStatement newClosureBlockStatement = TryCatchBlockGenerator.generateTryCatchBlock(isPostcondition ? ClassHelper.makeWithoutCaching(PostconditionViolation.class) : ClassHelper.makeWithoutCaching(PreconditionViolation.class), "<" + annotation.getName() + "> Annotation Closure Contract has been violated \n\n", (Statement)AssertStatementCreationUtility.getAssertionStatemens(booleanExpressions));
        newClosureBlockStatement.setSourcePosition((ASTNode)closureBlockStatement);
        ClosureExpression rewrittenClosureExpression = new ClosureExpression(parameters.toArray(new Parameter[parameters.size()]), (Statement)newClosureBlockStatement);
        rewrittenClosureExpression.setSourcePosition((ASTNode)closureExpression);
        rewrittenClosureExpression.setDeclaringClass(closureExpression.getDeclaringClass());
        rewrittenClosureExpression.setSynthetic(true);
        rewrittenClosureExpression.setVariableScope(closureExpression.getVariableScope());
        rewrittenClosureExpression.setType(closureExpression.getType());
        ClassNode closureClassNode = this.closureWriter.createClosureClass(this.classNode, null, rewrittenClosureExpression, false, false, 1);
        this.classNode.getModule().addClass(closureClassNode);
        ClassExpression value = new ClassExpression(closureClassNode);
        value.setSourcePosition((ASTNode)annotation);
        processorAnnotationNode.setMember("value", (Expression)value);
    }
}

