/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.ast.visitor;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.gcontracts.annotations.meta.AnnotationContract;
import org.gcontracts.annotations.meta.AnnotationProcessorImplementation;
import org.gcontracts.annotations.meta.ContractElement;
import org.gcontracts.annotations.meta.Postcondition;
import org.gcontracts.ast.visitor.BaseVisitor;
import org.gcontracts.common.impl.AnnotationContractProcessor;
import org.gcontracts.common.spi.AnnotationProcessor;
import org.gcontracts.common.spi.ProcessingContextInformation;
import org.gcontracts.generation.CandidateChecks;
import org.gcontracts.util.AnnotationUtils;
import org.gcontracts.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessorVisitor
extends BaseVisitor {
    private ProcessingContextInformation pci;

    public AnnotationProcessorVisitor(SourceUnit sourceUnit, ReaderSource source, ProcessingContextInformation pci) {
        super(sourceUnit, source);
        Validate.notNull(pci);
        this.pci = pci;
    }

    public void visitClass(ClassNode type) {
        this.handleClassNode(type);
        ArrayList methodNodes = new ArrayList();
        methodNodes.addAll(type.getMethods());
        methodNodes.addAll(type.getDeclaredConstructors());
        for (MethodNode methodNode : methodNodes) {
            if (!CandidateChecks.isClassInvariantCandidate(type, methodNode) && !CandidateChecks.isPreOrPostconditionCandidate(type, methodNode)) continue;
            this.handleMethodNode(methodNode, AnnotationUtils.hasMetaAnnotations((AnnotatedNode)methodNode, ContractElement.class.getName()));
            for (Parameter parameter : methodNode.getParameters()) {
                this.handleParameterNode(parameter, methodNode);
            }
        }
        this.visitInterfaces(type, type.getInterfaces());
        this.visitAbstractBaseClassesForInterfaceMethodNodes(type, type.getSuperClass());
    }

    private void visitAbstractBaseClassesForInterfaceMethodNodes(ClassNode origin, ClassNode superClass) {
        if (superClass == null) {
            return;
        }
        if (!Modifier.isAbstract(superClass.getModifiers())) {
            return;
        }
        for (ClassNode interfaceClassNode : superClass.getInterfaces()) {
            ArrayList methodNodes = new ArrayList();
            methodNodes.addAll(interfaceClassNode.getMethods());
            for (MethodNode interfaceMethodNode : methodNodes) {
                MethodNode implementationInOriginClassNode;
                MethodNode implementingMethodNode;
                List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations((AnnotatedNode)interfaceMethodNode, ContractElement.class.getName());
                if (annotationNodes == null || annotationNodes.isEmpty() || (implementingMethodNode = superClass.getMethod(interfaceMethodNode.getName(), interfaceMethodNode.getParameters())) != null || (implementationInOriginClassNode = origin.getMethod(interfaceMethodNode.getName(), interfaceMethodNode.getParameters())) == null) continue;
                this.handleMethodNode(implementationInOriginClassNode, annotationNodes);
            }
        }
    }

    private void visitInterfaces(ClassNode classNode, ClassNode[] interfaces) {
        for (ClassNode interfaceClassNode : interfaces) {
            ArrayList methodNodes = new ArrayList();
            methodNodes.addAll(interfaceClassNode.getMethods());
            for (MethodNode interfaceMethodNode : methodNodes) {
                MethodNode implementingMethodNode = classNode.getMethod(interfaceMethodNode.getName(), interfaceMethodNode.getParameters());
                if (implementingMethodNode == null) continue;
                List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations((AnnotatedNode)interfaceMethodNode, ContractElement.class.getName());
                this.handleInterfaceMethodNode(classNode, implementingMethodNode, annotationNodes);
            }
            this.visitInterfaces(classNode, interfaceClassNode.getInterfaces());
        }
    }

    private void handleClassNode(ClassNode classNode) {
        List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations((AnnotatedNode)classNode, ContractElement.class.getName());
        for (AnnotationNode annotationNode : annotationNodes) {
            AnnotationProcessor annotationProcessor = this.createAnnotationProcessor(annotationNode);
            if (annotationProcessor == null || !(annotationNode.getMember("value") instanceof ClassExpression)) continue;
            ClassExpression closureClassExpression = (ClassExpression)annotationNode.getMember("value");
            ArgumentListExpression closureConstructorArgumentList = new ArgumentListExpression((Expression)VariableExpression.THIS_EXPRESSION, (Expression)VariableExpression.THIS_EXPRESSION);
            MethodCallExpression doCall = new MethodCallExpression((Expression)new MethodCallExpression((Expression)closureClassExpression, "newInstance", (Expression)closureConstructorArgumentList), "call", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
            BooleanExpression booleanExpression = new BooleanExpression((Expression)doCall);
            booleanExpression.setSourcePosition((ASTNode)annotationNode);
            annotationProcessor.process(this.pci, this.pci.contract(), classNode, booleanExpression);
        }
    }

    private void handleInterfaceMethodNode(ClassNode type, MethodNode methodNode, List<AnnotationNode> annotationNodes) {
        this.handleMethodNode(type.getMethod(methodNode.getName(), methodNode.getParameters()), annotationNodes);
    }

    private void handleMethodNode(MethodNode methodNode, List<AnnotationNode> annotationNodes) {
        if (methodNode == null) {
            return;
        }
        for (AnnotationNode annotationNode : annotationNodes) {
            AnnotationProcessor annotationProcessor = this.createAnnotationProcessor(annotationNode);
            if (annotationProcessor == null || !(annotationNode.getMember("value") instanceof ClassExpression)) continue;
            boolean isPostcondition = AnnotationUtils.hasAnnotationOfType((AnnotatedNode)annotationNode.getClassNode(), Postcondition.class.getName());
            ArgumentListExpression closureConstructorArgumentList = new ArgumentListExpression((Expression)VariableExpression.THIS_EXPRESSION, (Expression)VariableExpression.THIS_EXPRESSION);
            ArgumentListExpression closureArgumentList = new ArgumentListExpression();
            for (Parameter parameter : methodNode.getParameters()) {
                closureArgumentList.addExpression((Expression)new VariableExpression((Variable)parameter));
            }
            if (methodNode.getReturnType() != ClassHelper.VOID_TYPE && isPostcondition && !(methodNode instanceof ConstructorNode)) {
                closureArgumentList.addExpression((Expression)new VariableExpression("result"));
            }
            if (isPostcondition && !(methodNode instanceof ConstructorNode)) {
                closureArgumentList.addExpression((Expression)new VariableExpression("old"));
            }
            MethodCallExpression doCall = new MethodCallExpression((Expression)new MethodCallExpression(annotationNode.getMember("value"), "newInstance", (Expression)closureConstructorArgumentList), "call", (Expression)closureArgumentList);
            BooleanExpression booleanExpression = new BooleanExpression((Expression)doCall);
            booleanExpression.setSourcePosition((ASTNode)annotationNode);
            annotationProcessor.process(this.pci, this.pci.contract(), methodNode.getDeclaringClass(), methodNode, booleanExpression);
            if (AnnotationUtils.hasAnnotationOfType((AnnotatedNode)methodNode, annotationNode.getClassNode().getName())) continue;
            AnnotationNode annotationMarker = new AnnotationNode(annotationNode.getClassNode());
            annotationMarker.setMember("value", (Expression)((ClassExpression)annotationNode.getMember("value")));
            annotationMarker.setRuntimeRetention(true);
            annotationMarker.setSourceRetention(false);
            methodNode.addAnnotation(annotationMarker);
        }
    }

    private void handleParameterNode(Parameter parameter, MethodNode methodNode) {
        Validate.notNull(parameter);
        List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations((AnnotatedNode)parameter, ContractElement.class.getName());
        for (AnnotationNode annotationNode : annotationNodes) {
            AnnotationProcessor processor = this.createAnnotationProcessorFromClosure(annotationNode);
            if (processor == null) continue;
            processor.process(this.pci, this.pci.contract(), methodNode.getDeclaringClass(), methodNode, parameter);
        }
    }

    private AnnotationProcessor createAnnotationProcessor(AnnotationNode annotationNode) {
        AnnotationProcessor processor = this.createAnnotationProcessorFromClosure(annotationNode);
        if (processor != null) {
            return processor;
        }
        AnnotationProcessorImplementation annotationProcessingAnno = annotationNode.getClassNode().getTypeClass().getAnnotation(AnnotationProcessorImplementation.class);
        if (annotationProcessingAnno == null) {
            return null;
        }
        Class<? extends AnnotationProcessor> clz = annotationProcessingAnno.value();
        try {
            return clz.newInstance();
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return null;
    }

    private AnnotationProcessor createAnnotationProcessorFromClosure(AnnotationNode annotationNode) {
        List annotationNodes = annotationNode.getClassNode().getAnnotations(ClassHelper.makeWithoutCaching(AnnotationContract.class));
        if (annotationNodes == null || annotationNodes.isEmpty()) {
            return null;
        }
        ArrayList<ClassExpression> classExpressionList = new ArrayList<ClassExpression>();
        for (AnnotationNode an : annotationNodes) {
            ClassExpression closureClass = (ClassExpression)an.getMember("value");
            Validate.notNull(closureClass);
            classExpressionList.add(closureClass);
        }
        return new AnnotationContractProcessor(annotationNode, classExpressionList);
    }
}

