/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.ast.visitor;

import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.gcontracts.annotations.Contracted;
import org.gcontracts.annotations.meta.ContractElement;
import org.gcontracts.ast.visitor.BaseVisitor;
import org.gcontracts.generation.CandidateChecks;
import org.gcontracts.util.AnnotationUtils;

public class ContractElementVisitor
extends BaseVisitor {
    private ClassNode classNode;
    private boolean foundContractElement = false;

    public ContractElementVisitor(SourceUnit sourceUnit, ReaderSource source) {
        super(sourceUnit, source);
    }

    public void visitClass(ClassNode node) {
        if (!CandidateChecks.isContractsCandidate(node) && !CandidateChecks.isInterfaceContractsCandidate(node)) {
            return;
        }
        this.classNode = node;
        if (AnnotationUtils.hasAnnotationOfType((AnnotatedNode)node, Contracted.class.getName())) {
            this.foundContractElement = true;
            return;
        }
        this.foundContractElement |= AnnotationUtils.hasMetaAnnotations((AnnotatedNode)node, ContractElement.class.getName()).size() > 0;
        if (!this.foundContractElement) {
            super.visitClass(node);
        }
        if (!this.foundContractElement && node.getSuperClass() != null) {
            this.visitClass(node.getSuperClass());
        }
        if (!this.foundContractElement) {
            for (ClassNode interfaceNode : node.getInterfaces()) {
                this.visitClass(interfaceNode);
                if (!this.foundContractElement) continue;
                return;
            }
        }
    }

    protected void visitConstructorOrMethod(MethodNode methodNode, boolean isConstructor) {
        if (!CandidateChecks.couldBeContractElementMethodNode(this.classNode, methodNode) && !CandidateChecks.isPreconditionCandidate(this.classNode, methodNode)) {
            return;
        }
        this.foundContractElement |= AnnotationUtils.hasMetaAnnotations((AnnotatedNode)methodNode, ContractElement.class.getName()).size() > 0;
        if (this.foundContractElement) {
            return;
        }
        for (Parameter param : methodNode.getParameters()) {
            this.foundContractElement |= AnnotationUtils.hasMetaAnnotations((AnnotatedNode)param, ContractElement.class.getName()).size() > 0;
            if (!this.foundContractElement) continue;
            return;
        }
    }

    public boolean isFoundContractElement() {
        return this.foundContractElement;
    }
}

