/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.ast.visitor;

import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.gcontracts.ast.visitor.BaseVisitor;
import org.gcontracts.common.spi.ProcessingContextInformation;
import org.gcontracts.domain.Assertion;
import org.gcontracts.domain.ClassInvariant;
import org.gcontracts.domain.Contract;
import org.gcontracts.domain.Postcondition;
import org.gcontracts.domain.Precondition;
import org.gcontracts.generation.CandidateChecks;
import org.gcontracts.generation.ClassInvariantGenerator;
import org.gcontracts.generation.PostconditionGenerator;
import org.gcontracts.generation.PreconditionGenerator;
import org.gcontracts.util.Validate;

public class DomainModelInjectionVisitor
extends BaseVisitor {
    private final ProcessingContextInformation pci;
    private final Contract contract;

    public DomainModelInjectionVisitor(SourceUnit sourceUnit, ReaderSource source, ProcessingContextInformation pci) {
        super(sourceUnit, source);
        Validate.notNull(pci);
        Validate.notNull(pci.contract());
        this.pci = pci;
        this.contract = pci.contract();
    }

    public void visitClass(ClassNode type) {
        this.injectClassInvariant(type, this.contract.classInvariant());
        for (Map.Entry<MethodNode, Precondition> entry : this.contract.preconditions()) {
            this.injectPrecondition(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<MethodNode, Assertion> entry : this.contract.postconditions()) {
            this.injectPostcondition(entry.getKey(), (Postcondition)entry.getValue());
        }
    }

    public void injectClassInvariant(ClassNode type, ClassInvariant classInvariant) {
        if (!this.pci.isClassInvariantsEnabled() || !CandidateChecks.isContractsCandidate(type)) {
            return;
        }
        ReaderSource source = this.pci.readerSource();
        ClassInvariantGenerator classInvariantGenerator = new ClassInvariantGenerator(source);
        classInvariantGenerator.generateInvariantAssertionStatement(type, classInvariant.booleanExpression());
    }

    public void injectPrecondition(MethodNode method, Precondition precondition) {
        if (!this.pci.isPreconditionsEnabled() || !CandidateChecks.isPreconditionCandidate(method.getDeclaringClass(), method)) {
            return;
        }
        ReaderSource source = this.pci.readerSource();
        PreconditionGenerator preconditionGenerator = new PreconditionGenerator(source);
        preconditionGenerator.generatePreconditionAssertionStatement(method, precondition.booleanExpression());
    }

    public void injectPostcondition(MethodNode method, Postcondition postcondition) {
        if (!this.pci.isPostconditionsEnabled() || !CandidateChecks.isPostconditionCandidate(method.getDeclaringClass(), method)) {
            return;
        }
        ReaderSource source = this.pci.readerSource();
        PostconditionGenerator postconditionGenerator = new PostconditionGenerator(source);
        postconditionGenerator.generatePostconditionAssertionStatement(method, postcondition.booleanExpression(), postcondition.isPartOfConstructor());
    }
}

