/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.ast.visitor;

import java.util.ArrayList;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.gcontracts.ast.visitor.BaseVisitor;
import org.gcontracts.common.spi.Lifecycle;
import org.gcontracts.common.spi.ProcessingContextInformation;
import org.gcontracts.util.LifecycleImplementationLoader;
import org.gcontracts.util.Validate;

public class LifecycleBeforeTransformationVisitor
extends BaseVisitor {
    private ProcessingContextInformation pci;

    public LifecycleBeforeTransformationVisitor(SourceUnit sourceUnit, ReaderSource source, ProcessingContextInformation pci) {
        super(sourceUnit, source);
        Validate.notNull(pci);
        this.pci = pci;
    }

    public void visitClass(ClassNode node) {
        super.visitClass(node);
        ArrayList methods = new ArrayList(node.getMethods());
        ArrayList constructors = new ArrayList(node.getDeclaredConstructors());
        for (Lifecycle lifecyle : LifecycleImplementationLoader.load(Lifecycle.class, ((Object)((Object)this)).getClass().getClassLoader())) {
            lifecyle.beforeProcessingClassNode(this.pci, node);
            for (MethodNode constructor : constructors) {
                lifecyle.beforeProcessingContructorNode(this.pci, node, constructor);
            }
            for (MethodNode method : methods) {
                lifecyle.beforeProcessingMethodNode(this.pci, node, method);
            }
        }
    }
}

