/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.common.base;

import java.util.concurrent.locks.ReentrantLock;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.gcontracts.common.spi.Lifecycle;
import org.gcontracts.common.spi.ProcessingContextInformation;

public abstract class BaseLifecycle
implements Lifecycle {
    public void beforeProcessingClassNode(ProcessingContextInformation processingContextInformation, ClassNode classNode) {
        this.addConcurrentLockField(classNode);
    }

    private void addConcurrentLockField(ClassNode classNode) {
        ClassNode reentrantLockClassNode = ClassHelper.make(ReentrantLock.class);
        if (classNode.getDeclaredField("$_gc_lock") == null) {
            classNode.addField("$_gc_lock", 2, reentrantLockClassNode, (Expression)new ConstructorCallExpression(reentrantLockClassNode, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS));
        }
        if (classNode.getDeclaredField("$_gc_slock") == null) {
            classNode.addField("$_gc_slock", 10, reentrantLockClassNode, (Expression)new ConstructorCallExpression(reentrantLockClassNode, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS));
        }
    }

    public void afterProcessingClassNode(ProcessingContextInformation processingContextInformation, ClassNode classNode) {
    }

    public void beforeProcessingMethodNode(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode methodNode) {
    }

    public void afterProcessingMethodNode(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode methodNode) {
    }

    public void beforeProcessingContructorNode(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode constructorNode) {
    }

    public void afterProcessingContructorNode(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode constructorNode) {
    }
}

