/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.common.impl;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.gcontracts.annotations.meta.Precondition;
import org.gcontracts.common.spi.AnnotationProcessor;
import org.gcontracts.common.spi.ProcessingContextInformation;
import org.gcontracts.domain.Contract;
import org.gcontracts.domain.Postcondition;
import org.gcontracts.util.AnnotationUtils;
import org.gcontracts.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationContractProcessor
extends AnnotationProcessor {
    private final AnnotationNode annotationNode;
    private final List<ClassExpression> closureClasses;

    public AnnotationContractProcessor(AnnotationNode annotationNode, List<ClassExpression> closureClasses) {
        Validate.notNull(annotationNode);
        Validate.notNull(closureClasses);
        this.annotationNode = annotationNode;
        this.closureClasses = closureClasses;
    }

    @Override
    public void process(ProcessingContextInformation processingContextInformation, Contract contract, ClassNode classNode, MethodNode methodNode, Parameter parameter) {
        for (ClassExpression closureClass : this.closureClasses) {
            ArgumentListExpression closureConstructorArgumentList = new ArgumentListExpression((Expression)VariableExpression.THIS_EXPRESSION, (Expression)VariableExpression.THIS_EXPRESSION);
            MethodCallExpression doCall = new MethodCallExpression((Expression)new MethodCallExpression((Expression)closureClass, "newInstance", (Expression)closureConstructorArgumentList), "call", (Expression)new ArgumentListExpression((Expression)new VariableExpression((Variable)parameter)));
            BooleanExpression booleanExpression = new BooleanExpression((Expression)doCall);
            booleanExpression.setSourcePosition((ASTNode)this.annotationNode);
            if (AnnotationUtils.hasAnnotationOfType((AnnotatedNode)this.annotationNode.getClassNode(), Precondition.class.getName())) {
                contract.preconditions().join(methodNode, new org.gcontracts.domain.Precondition(booleanExpression));
                continue;
            }
            if (!AnnotationUtils.hasAnnotationOfType((AnnotatedNode)this.annotationNode.getClassNode(), org.gcontracts.annotations.meta.Postcondition.class.getName())) continue;
            contract.postconditions().join(methodNode, new Postcondition(booleanExpression, methodNode instanceof ConstructorNode));
        }
    }
}

