/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.common.impl.lc;

import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.gcontracts.annotations.meta.Postcondition;
import org.gcontracts.common.base.BaseLifecycle;
import org.gcontracts.common.spi.ProcessingContextInformation;
import org.gcontracts.generation.CandidateChecks;
import org.gcontracts.generation.PostconditionGenerator;
import org.gcontracts.util.AnnotationUtils;

public class PostconditionLifecycle
extends BaseLifecycle {
    public void beforeProcessingClassNode(ProcessingContextInformation processingContextInformation, ClassNode classNode) {
        PostconditionGenerator postconditionGenerator = new PostconditionGenerator(processingContextInformation.readerSource());
        postconditionGenerator.addOldVariablesMethod(classNode);
    }

    public void afterProcessingContructorNode(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode constructorNode) {
        this.generatePostcondition(processingContextInformation, classNode, constructorNode);
    }

    public void afterProcessingMethodNode(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode methodNode) {
        this.generatePostcondition(processingContextInformation, classNode, methodNode);
    }

    private void generatePostcondition(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode methodNode) {
        if (!processingContextInformation.isPostconditionsEnabled()) {
            return;
        }
        if (!CandidateChecks.isPostconditionCandidate(classNode, methodNode)) {
            return;
        }
        PostconditionGenerator postconditionGenerator = new PostconditionGenerator(processingContextInformation.readerSource());
        if (!(methodNode instanceof ConstructorNode) && AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(classNode, methodNode, ClassHelper.makeWithoutCaching(Postcondition.class)).size() > 0) {
            postconditionGenerator.generateDefaultPostconditionStatement(classNode, methodNode);
        } else {
            postconditionGenerator.generateDefaultPostconditionStatement(classNode, methodNode);
        }
    }
}

