/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.generation;

import java.lang.annotation.Annotation;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.syntax.Token;
import org.gcontracts.annotations.meta.ClassInvariant;
import org.gcontracts.generation.AssertStatementCreationUtility;
import org.gcontracts.generation.BaseGenerator;
import org.gcontracts.util.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInvariantGenerator
extends BaseGenerator {
    public ClassInvariantGenerator(ReaderSource source) {
        super(source);
    }

    public void generateInvariantAssertionStatement(ClassNode type, BooleanExpression classInvariant) {
        BooleanExpression classInvariantExpression = this.addCallsToSuperAnnotationClosure(type, ClassInvariant.class, classInvariant);
        BlockStatement blockStatement = new BlockStatement();
        MethodNode methodNode = type.addMethod(ClassInvariantGenerator.getInvariantMethodName(type), 4100, ClassHelper.Boolean_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, (Statement)blockStatement);
        methodNode.setSynthetic(true);
        blockStatement.addStatements(this.wrapAssertionBooleanExpression(type, methodNode, classInvariantExpression, "invariant").getStatements());
        blockStatement.addStatement((Statement)new ReturnStatement((Expression)ConstantExpression.TRUE));
    }

    private BooleanExpression addCallsToSuperAnnotationClosure(ClassNode type, Class<? extends Annotation> annotationType, BooleanExpression booleanExpression) {
        List<AnnotationNode> nextContractElementAnnotations = AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(type.getSuperClass(), ClassHelper.makeWithoutCaching(annotationType));
        if (nextContractElementAnnotations.isEmpty()) {
            return booleanExpression;
        }
        for (AnnotationNode nextContractElementAnnotation : nextContractElementAnnotations) {
            ClassExpression classExpression = (ClassExpression)nextContractElementAnnotation.getMember("value");
            if (classExpression == null) continue;
            ArgumentListExpression closureConstructorArgumentList = new ArgumentListExpression((Expression)VariableExpression.THIS_EXPRESSION, (Expression)VariableExpression.THIS_EXPRESSION);
            MethodCallExpression doCall = new MethodCallExpression((Expression)new MethodCallExpression((Expression)classExpression, "newInstance", (Expression)closureConstructorArgumentList), "call", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
            BooleanExpression rightExpression = new BooleanExpression((Expression)doCall);
            booleanExpression.setSourcePosition((ASTNode)nextContractElementAnnotation);
            booleanExpression = new BooleanExpression((Expression)new BinaryExpression((Expression)booleanExpression, Token.newSymbol((int)164, (int)-1, (int)-1), (Expression)rightExpression));
        }
        return booleanExpression;
    }

    public void addInvariantAssertionStatement(ClassNode type, MethodNode method) {
        String invariantMethodName = ClassInvariantGenerator.getInvariantMethodName(type);
        MethodNode invariantMethod = type.getDeclaredMethod(invariantMethodName, Parameter.EMPTY_ARRAY);
        if (invariantMethod == null) {
            return;
        }
        ExpressionStatement invariantMethodCall = new ExpressionStatement((Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, invariantMethod.getName(), (Expression)ArgumentListExpression.EMPTY_ARGUMENTS));
        Statement statement = method.getCode();
        if (statement instanceof BlockStatement && method.getReturnType() != ClassHelper.VOID_TYPE && !(method instanceof ConstructorNode)) {
            BlockStatement blockStatement = (BlockStatement)statement;
            List<ReturnStatement> returnStatements = AssertStatementCreationUtility.getReturnStatements(method);
            for (ReturnStatement returnStatement : returnStatements) {
                AssertStatementCreationUtility.addAssertionCallStatementToReturnStatement(blockStatement, returnStatement, (Statement)invariantMethodCall);
            }
            if (returnStatements.isEmpty()) {
                blockStatement.addStatement((Statement)invariantMethodCall);
            }
        } else if (statement instanceof BlockStatement) {
            BlockStatement blockStatement = (BlockStatement)statement;
            blockStatement.addStatement((Statement)invariantMethodCall);
        } else {
            BlockStatement assertionBlock = new BlockStatement();
            assertionBlock.addStatement(statement);
            assertionBlock.addStatement((Statement)invariantMethodCall);
            method.setCode((Statement)assertionBlock);
        }
    }
}

