/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.generation;

import java.util.Stack;

public class ContractExecutionTracker {
    private static ThreadLocal<Stack<ContractExecution>> executions = new ThreadLocal<Stack<ContractExecution>>(){

        @Override
        protected Stack<ContractExecution> initialValue() {
            return new Stack<ContractExecution>();
        }
    };

    public static boolean track(String className, String methodIdentifier, String assertionType, boolean isStatic) {
        ContractExecution ce = new ContractExecution(className, methodIdentifier, assertionType, isStatic);
        Stack<ContractExecution> contractExecutions = executions.get();
        if (!contractExecutions.contains(ce)) {
            contractExecutions.push(ce);
            return true;
        }
        return false;
    }

    public static void clear(String className, String methodIdentifier, String assertionType, boolean isStatic) {
        Stack<ContractExecution> contractExecutions = executions.get();
        if (contractExecutions.size() > 0) {
            contractExecutions.pop();
        }
    }

    public static class ContractExecution {
        String className;
        String methodIdentifier;
        String assertionType;
        boolean isStatic;

        public ContractExecution(String className, String methodIdentifier, String assertionType, boolean isStatic) {
            this.className = className;
            this.methodIdentifier = methodIdentifier;
            this.assertionType = assertionType;
            this.isStatic = isStatic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContractExecution that = (ContractExecution)o;
            if (this.isStatic != that.isStatic) {
                return false;
            }
            if (this.assertionType != null ? !this.assertionType.equals(that.assertionType) : that.assertionType != null) {
                return false;
            }
            if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
                return false;
            }
            return !(this.methodIdentifier != null ? !this.methodIdentifier.equals(that.methodIdentifier) : that.methodIdentifier != null);
        }

        public int hashCode() {
            int result = this.className != null ? this.className.hashCode() : 0;
            result = 31 * result + (this.methodIdentifier != null ? this.methodIdentifier.hashCode() : 0);
            result = 31 * result + (this.assertionType != null ? this.assertionType.hashCode() : 0);
            result = 31 * result + (this.isStatic ? 1 : 0);
            return result;
        }
    }
}

