/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.run;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.URI;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jooby.run.Main;

public class AppModuleLoader
extends ModuleLoader {
    private Map<ModuleIdentifier, ModuleSpec> modules;

    public AppModuleLoader(Map<ModuleIdentifier, ModuleSpec> modules) {
        this.modules = modules;
    }

    protected ModuleSpec findModule(ModuleIdentifier moduleId) throws ModuleLoadException {
        ModuleSpec spec = this.modules.get(moduleId);
        return spec == null ? super.findModule(moduleId) : spec;
    }

    public void unload(Module module) {
        super.unloadModuleLocal(module);
    }

    public static AppModuleLoader build(String name, File ... cp) throws Exception {
        Map<ModuleIdentifier, ModuleSpec> modules = AppModuleLoader.newModule(name, 0, "", cp);
        return new AppModuleLoader(modules);
    }

    private static Map<ModuleIdentifier, ModuleSpec> newModule(String name, int level, String prefix, File ... cp) throws Exception {
        HashMap<ModuleIdentifier, ModuleSpec> modules = new HashMap<ModuleIdentifier, ModuleSpec>();
        String mId = name.replace(".jar", "");
        ModuleSpec.Builder builder = ModuleSpec.build((ModuleIdentifier)ModuleIdentifier.fromString((String)mId));
        if (level == 0) {
            String classurl = AppModuleLoader.class.getResource("/" + "org.jooby.internal.run__.JoobyRef".replace(".", "/") + ".class").toString();
            File[] jartoken = ".jar!";
            File jar = new File(URI.create(classurl.substring(0, classurl.indexOf((String)jartoken) + jartoken.length() - 1).replace("jar:", "")));
            Main.debug("loading hack: %s?%s", jar, jar.exists());
            builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((String)"jooby-run", (JarFile)new JarFile(jar))));
        }
        int l = prefix.length() + mId.length() + level;
        Main.debug("%1$" + l + "s", prefix + mId);
        for (File file : cp) {
            if (file.getName().endsWith(".pom") || !file.exists()) continue;
            String fname = "\u2514\u2500\u2500 " + file.getAbsolutePath();
            if (file.getName().startsWith("j2v8") && !name.equals(file.getName())) {
                ModuleSpec dependency = AppModuleLoader.newModule(file.getName(), level + 2, "\u2514\u2500\u2500 ", file).values().iterator().next();
                builder.addDependency(DependencySpec.createModuleDependencySpec((ModuleIdentifier)dependency.getModuleIdentifier()));
                modules.put(dependency.getModuleIdentifier(), dependency);
                continue;
            }
            Main.debug("%1$" + (fname.length() + level + 2) + "s", fname);
            if (file.getName().endsWith(".jar")) {
                builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((String)file.getName(), (JarFile)new JarFile(file))));
                continue;
            }
            builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createFileResourceLoader((String)file.getName(), (File)file)));
        }
        Set<String> sysPaths = AppModuleLoader.sysPaths();
        Main.trace("system packages:", new Object[0]);
        sysPaths.forEach(p -> Main.trace("  %s", p));
        builder.addDependency(DependencySpec.createSystemDependencySpec(sysPaths));
        builder.addDependency(DependencySpec.createLocalDependencySpec());
        ModuleSpec module = builder.create();
        modules.put(module.getModuleIdentifier(), builder.create());
        return modules;
    }

    private static Set<String> jdkPaths() throws Exception {
        Class<?> jdkPath = AppModuleLoader.class.getClassLoader().loadClass("org.jboss.modules.JDKPaths");
        Field field = jdkPath.getDeclaredField("JDK");
        field.setAccessible(true);
        return (Set)field.get(null);
    }

    private static Set<String> sysPaths() throws Exception {
        LinkedHashSet<String> pkgs = new LinkedHashSet<String>();
        pkgs.addAll(AppModuleLoader.jdkPaths());
        pkgs.addAll(AppModuleLoader.pkgs(new InputStreamReader(Main.class.getResourceAsStream("pkgs"))));
        pkgs.addAll(AppModuleLoader.pkgs(Paths.get("src", "etc", "jboss-modules", "pkgs.includes").toFile()));
        pkgs.removeAll(AppModuleLoader.pkgs(Paths.get("src", "etc", "jboss-modules", "pkgs.excludes").toFile()));
        return pkgs;
    }

    private static Set<String> pkgs(File file) throws IOException {
        if (file.exists()) {
            return AppModuleLoader.pkgs(new FileReader(file));
        }
        return new LinkedHashSet<String>();
    }

    private static Set<String> pkgs(Reader reader) throws IOException {
        try (BufferedReader in = new BufferedReader(reader);){
            LinkedHashSet<String> pkgs = new LinkedHashSet<String>();
            String line = in.readLine();
            while (line != null) {
                pkgs.add(line.trim());
                line = in.readLine();
            }
            LinkedHashSet<String> linkedHashSet = pkgs;
            return linkedHashSet;
        }
    }
}

