/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.run;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.LongStream;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.log.ModuleLogger;
import org.jooby.run.AppModuleLoader;
import org.jooby.run.Watcher;

public class Main {
    static final String JOOBY_REF = "org.jooby.internal.run__.JoobyRef";
    private static boolean DEBUG;
    private static boolean TRACE;
    private AppModuleLoader loader;
    private ExecutorService executor;
    private Watcher scanner;
    private PathMatcher includes;
    private PathMatcher excludes;
    private volatile Object app;
    private AtomicReference<String> hash = new AtomicReference<String>("");
    private ModuleIdentifier mId;
    private String mainClass;
    private volatile Module module;
    private List<String> args;
    private AtomicBoolean starting = new AtomicBoolean(false);
    private AtomicInteger counter = new AtomicInteger(0);
    private Path[] watchDirs;

    public Main(String mId, String mainClass, List<File> watchDirs, File ... cp) throws Exception {
        this.mainClass = mainClass;
        this.loader = AppModuleLoader.build(mId, cp);
        this.mId = ModuleIdentifier.create((String)mId);
        this.watchDirs = this.toPath(watchDirs);
        this.executor = Executors.newSingleThreadExecutor(task -> new Thread(task, "Hotswap"));
        this.scanner = new Watcher(this::onChange, this.watchDirs);
        this.includes("**/*.class" + File.pathSeparator + "**/*.conf" + File.pathSeparator + "**/*.properties" + this.packageJson(cp));
        this.excludes("");
    }

    private String packageJson(File[] cp) {
        if (Files.exists(Paths.get("package.json", new String[0]), new LinkOption[0])) {
            return Arrays.asList(cp).stream().filter(f -> f.getAbsolutePath().contains("jooby-frontend")).findFirst().map(f -> File.pathSeparator + "package.json").orElse("");
        }
        return "";
    }

    private Path[] toPath(List<File> watchDir) throws IOException {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        files.add(new File(System.getProperty("user.dir")));
        if (watchDir != null) {
            files.addAll(watchDir);
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        for (File file : files) {
            if (!file.exists()) continue;
            paths.add(file.getCanonicalFile().toPath());
        }
        return paths.toArray(new Path[paths.size()]);
    }

    public static void main(String[] args) throws Exception {
        ArrayList<File> cp = new ArrayList<File>();
        ArrayList<File> watch = new ArrayList<File>();
        String includes = null;
        String excludes = null;
        block14: for (int i = 2; i < args.length; ++i) {
            String name;
            String[] option = args[i].split("=");
            if (option.length < 2) {
                throw new IllegalArgumentException("Unknown option: " + args[i]);
            }
            switch (name = option[0].toLowerCase()) {
                case "includes": {
                    includes = option[1];
                    continue block14;
                }
                case "excludes": {
                    excludes = option[1];
                    continue block14;
                }
                case "props": {
                    Main.setSystemProperties(new File(option[1]));
                    continue block14;
                }
                case "deps": {
                    String[] deps;
                    for (String dep : deps = option[1].split(File.pathSeparator)) {
                        cp.add(new File(dep));
                    }
                    continue block14;
                }
                case "watchdirs": {
                    String[] dirs;
                    for (String dir : dirs = option[1].split(File.pathSeparator)) {
                        watch.add(new File(dir));
                    }
                    continue block14;
                }
                default: {
                    throw new IllegalArgumentException("Unknown option: " + args[i]);
                }
            }
        }
        Main.logLevel();
        if (cp.isEmpty()) {
            cp.add(new File(System.getProperty("user.dir")));
        }
        Main launcher = new Main(args[0], args[1], watch, cp.toArray(new File[cp.size()]));
        if (includes != null) {
            launcher.includes(includes);
        }
        if (excludes != null) {
            launcher.excludes(excludes);
        }
        launcher.run(new String[0]);
    }

    private static void setSystemProperties(File sysprops) throws IOException {
        try (FileInputStream in = new FileInputStream(sysprops);){
            Properties properties = new Properties();
            properties.load(in);
            for (Map.Entry<Object, Object> prop : properties.entrySet()) {
                String existing;
                String name = prop.getKey().toString();
                String value = prop.getValue().toString();
                if (value.equals(existing = System.getProperty(name))) continue;
                System.setProperty(name, value);
            }
        }
    }

    public void run(String ... args) {
        this.run(false, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean block, String ... args) {
        Main.info("Hotswap available on: %s", Arrays.toString(this.watchDirs));
        Main.info("  includes: %s", this.includes);
        Main.info("  excludes: %s", this.excludes);
        this.scanner.start();
        this.args = new ArrayList<String>(Arrays.asList(args));
        this.args.add("server.join=false");
        this.args.add("jooby.internal.onStart=org.jooby.internal.run__.JoobyRef");
        this.startApp(this.args);
        if (block) {
            Object lock;
            Object object = lock = new Object();
            synchronized (object) {
                try {
                    lock.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void startApp(List<String> args) {
        if (this.starting.get()) {
            return;
        }
        if (this.app != null) {
            this.stopApp(this.app);
        }
        System.setProperty("joobyRun.counter", String.valueOf(this.counter.getAndIncrement()));
        this.starting.set(true);
        Main.debug("scheduling: %s", this.mainClass);
        this.executor.submit(() -> {
            String runclass;
            String alias = runclass = this.mainClass;
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            try {
                this.module = this.loader.loadModule(this.mId);
                ModuleClassLoader mcloader = this.module.getClassLoader();
                Thread.currentThread().setContextClassLoader((ClassLoader)mcloader);
                Main.debug("starting: %s", runclass);
                Class appref = mcloader.loadClass(JOOBY_REF);
                Main.debug("loaded: %s", appref);
                Class appclass = mcloader.loadClass(runclass);
                Main.debug("loaded: %s", appclass);
                Method main = appclass.getDeclaredMethod("main", String[].class);
                Main.debug("loaded: %s", main);
                String[] params = args.toArray(new String[args.size()]);
                Main.debug("calling: %s", main);
                main.invoke(null, new Object[]{params});
                Main.debug("called: %s", main);
                Field reffld = appref.getDeclaredField("ref");
                AtomicReference ref = (AtomicReference)reffld.get(null);
                this.app = ref.get();
                if (this.app != null) {
                    Method started = this.app.getClass().getMethod("isStarted", new Class[0]);
                    Boolean success = (Boolean)started.invoke(this.app, new Object[0]);
                    if (success.booleanValue()) {
                        Main.debug("started: %s", alias);
                    } else {
                        Main.debug("not started: %s", alias);
                        System.exit(1);
                    }
                }
            }
            catch (Throwable ex) {
                Throwable cause = ex;
                if (ex instanceof InvocationTargetException) {
                    cause = ((InvocationTargetException)ex).getTargetException();
                }
                Main.error("%s.start() resulted in error", alias, cause);
            }
            finally {
                this.starting.set(false);
                Thread.currentThread().setContextClassLoader(ctxLoader);
            }
        });
    }

    /*
     * Loose catch block
     */
    private void stopApp(Object app) {
        block10: {
            Main.debug("stopping: %s", this.mainClass);
            app.getClass().getMethod("stop", new Class[0]).invoke(app, new Object[0]);
            try {
                Main.debug("unloading: %s", this.mainClass);
                this.loader.unload(this.module);
            }
            catch (Throwable throwable) {}
            break block10;
            catch (Throwable ex) {
                try {
                    Main.error("%s.stop() resulted in error", this.mainClass, ex);
                }
                catch (Throwable throwable) {
                    try {
                        Main.debug("unloading: %s", this.mainClass);
                        this.loader.unload(this.module);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    Main.debug("unloading: %s", this.mainClass);
                    this.loader.unload(this.module);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public Main includes(String includes) {
        this.includes = Main.pathMatcher(includes);
        return this;
    }

    public Main excludes(String excludes) {
        this.excludes = Main.pathMatcher(excludes);
        return this;
    }

    private void onChange(WatchEvent.Kind<?> kind, Path path) {
        try {
            Main.debug("OnChange: %s(%s)", path, kind);
            Path candidate = this.relativePath(path);
            if (candidate == null || !this.includes.matches(candidate) || this.excludes.matches(candidate)) {
                Main.debug("Ignoring change: %s", path);
                return;
            }
            File f = candidate.toFile();
            long l = LongStream.of(f.length(), f.lastModified(), System.currentTimeMillis()).filter(it -> it > 0L).findFirst().getAsLong();
            String h = f.getName() + ":" + l;
            Main.debug("hash %s > new hash %s", this.hash.get(), h);
            if (!this.hash.getAndSet(h).equals(h)) {
                Main.debug("File change detected: %s", path);
                this.startApp(this.args);
            } else {
                Main.debug("Ignoring change: %s", path);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Path relativePath(Path path) {
        for (Path root : this.watchDirs) {
            if (!path.startsWith(root)) continue;
            return root.relativize(path);
        }
        return null;
    }

    private static PathMatcher pathMatcher(final String expressions) {
        final ArrayList<PathMatcher> matchers = new ArrayList<PathMatcher>();
        for (String expression : expressions.split(File.pathSeparator)) {
            matchers.add(FileSystems.getDefault().getPathMatcher("glob:" + expression.trim()));
        }
        return new PathMatcher(){

            @Override
            public boolean matches(Path path) {
                for (PathMatcher matcher : matchers) {
                    if (!matcher.matches(path)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "[" + expressions + "]";
            }
        };
    }

    private static void logLevel() {
        DEBUG = "debug".equalsIgnoreCase(System.getProperty("logLevel", ""));
        TRACE = "trace".equalsIgnoreCase(System.getProperty("logLevel", ""));
        if (TRACE) {
            DEBUG = true;
            Module.setModuleLogger((ModuleLogger)new ModuleLogger(){

                public void trace(Throwable t, String format, Object arg1, Object arg2, Object arg3) {
                    Main.trace(format, arg1, arg2, arg3, t);
                }

                public void trace(Throwable t, String format, Object arg1, Object arg2) {
                    Main.trace(format, arg1, arg2, t);
                }

                public void trace(String format, Object arg1, Object arg2, Object arg3) {
                    Main.trace(format, arg1, arg2, arg3);
                }

                public void trace(Throwable t, String format, Object ... args) {
                    Object[] values = new Object[args.length + 1];
                    System.arraycopy(args, 0, values, 0, args.length);
                    values[values.length - 1] = t;
                    Main.trace(format, values);
                }

                public void trace(Throwable t, String format, Object arg1) {
                    Main.trace(format, arg1, t);
                }

                public void trace(String format, Object arg1, Object arg2) {
                    Main.trace(format, arg1, arg2);
                }

                public void trace(Throwable t, String message) {
                    Main.trace(message, t);
                }

                public void trace(String format, Object ... args) {
                    Main.trace(format, args);
                }

                public void trace(String format, Object arg1) {
                    Main.trace(format, arg1);
                }

                public void trace(String message) {
                    Main.trace(message, new Object[0]);
                }

                public void providerUnloadable(String name, ClassLoader loader) {
                }

                public void moduleDefined(ModuleIdentifier identifier, ModuleLoader moduleLoader) {
                }

                public void greeting() {
                }

                public void classDefined(String name, Module module) {
                }

                public void classDefineFailed(Throwable throwable, String className, Module module) {
                }

                public void jaxpClassLoaded(Class<?> aClass, Module module) {
                }

                public void jaxpResourceLoaded(URL url, Module module) {
                }
            });
        }
        String logback = Optional.ofNullable(System.getProperty("logback.configurationFile")).orElseGet(() -> Arrays.asList(Paths.get("conf", "logback-test.xml"), Paths.get("conf", "logback.dev.xml"), Paths.get("conf", "logback.xml")).stream().filter(p -> p.toFile().exists()).map(Path::toString).findFirst().orElse(Paths.get("conf", "logback.xml").toString()));
        Main.debug("logback: %s", logback);
        System.setProperty("logback.configurationFile", logback);
    }

    public static void info(String message, Object ... args) {
        System.out.println(Main.format("info", message, args));
    }

    public static void error(String message, Object ... args) {
        System.err.println(Main.format("error", message, args));
    }

    public static void debug(String message, Object ... args) {
        if (DEBUG) {
            System.out.println(Main.format("debug", message, args));
        }
    }

    public static void trace(String message, Object ... args) {
        if (TRACE) {
            System.out.println(Main.format("trace", message, args));
        }
    }

    private static String format(String level, String message, Object ... args) {
        Object[] values = args;
        Throwable x = null;
        if (args.length > 0 && args[args.length - 1] instanceof Throwable) {
            x = (Throwable)args[args.length - 1];
            values = new Object[args.length - 1];
            System.arraycopy(args, 0, values, 0, values.length);
        }
        String msg = String.format(message, values);
        StringBuilder buff = new StringBuilder();
        buff.append(">>> jooby:run[").append(level).append("|").append(Thread.currentThread().getName()).append("]: ").append(msg);
        if (x != null) {
            buff.append("\n");
            StringWriter writer = new StringWriter();
            x.printStackTrace(new PrintWriter(writer));
            buff.append(writer);
        }
        return buff.toString();
    }

    static {
        Main.logLevel();
    }
}

