/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.discovery;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.EngineDiscoveryListener;
import org.junit.platform.engine.UniqueId;

@API(status=API.Status.EXPERIMENTAL, since="1.13")
@FunctionalInterface
public interface DiscoveryIssueReporter {
    public static DiscoveryIssueReporter create(EngineDiscoveryListener engineDiscoveryListener, UniqueId engineId) {
        Preconditions.notNull((Object)engineDiscoveryListener, (String)"engineDiscoveryListener must not be null");
        Preconditions.notNull((Object)engineId, (String)"engineId must not be null");
        return issue -> engineDiscoveryListener.issueEncountered(engineId, issue);
    }

    default public void reportIssue(DiscoveryIssue.Builder builder) {
        this.reportIssue(builder.build());
    }

    public void reportIssue(DiscoveryIssue var1);

    default public <T> Condition<T> createReportingCondition(Predicate<T> predicate, Function<T, DiscoveryIssue> issueCreator) {
        Preconditions.notNull(predicate, (String)"predicate must not be null");
        Preconditions.notNull(issueCreator, (String)"issueCreator must not be null");
        return value -> {
            if (predicate.test(value)) {
                return true;
            }
            this.reportIssue((DiscoveryIssue)issueCreator.apply(value));
            return false;
        };
    }

    @FunctionalInterface
    public static interface Condition<T>
    extends Predicate<T>,
    Consumer<T> {
        @SafeVarargs
        public static <T> Condition<T> allOf(Condition<? super T> ... conditions) {
            Preconditions.notNull(conditions, (String)"conditions must not be null");
            Preconditions.notEmpty((Object[])conditions, (String)"conditions must not be empty");
            Preconditions.containsNoNullElements((Object[])conditions, (String)"conditions must not contain null elements");
            return value -> {
                boolean result = true;
                for (Condition condition : conditions) {
                    result &= condition.test(value);
                }
                return result;
            };
        }

        @Override
        default public void accept(T value) {
            this.test(value);
        }
    }
}

