/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image;

import Jama.Matrix;
import java.util.Comparator;
import org.apache.log4j.Logger;
import org.openimaj.image.ARGBPlane;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.SingleBandImage;
import org.openimaj.image.analyser.PixelAnalyser;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.pixel.FValuePixel;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processor.KernelProcessor;
import org.openimaj.image.processor.PixelProcessor;
import org.openimaj.image.renderer.FImageRenderer;
import org.openimaj.image.renderer.RenderHints;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.util.Interpolation;

public class FImage
extends SingleBandImage<Float, FImage> {
    private static final long serialVersionUID = 1L;
    protected static Logger logger = Logger.getLogger(FImage.class);
    protected static final float DEFAULT_GAUSS_TRUNCATE = 4.0f;
    public float[][] pixels;

    public FImage(float[] array, int width, int height) {
        assert (array.length == width * height);
        this.pixels = new float[height][width];
        this.height = height;
        this.width = width;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.pixels[y][x] = array[y * width + x];
            }
        }
    }

    public FImage(float[][] array) {
        this.pixels = array;
        this.height = array.length;
        this.width = array[0].length;
    }

    public FImage(int width, int height) {
        this.pixels = new float[height][width];
        this.height = height;
        this.width = width;
    }

    public FImage(int[] data, int width, int height) {
        this.internalAssign(data, width, height);
    }

    public FImage(int[] data, int width, int height, ARGBPlane plane) {
        this.width = width;
        this.height = height;
        this.pixels = new float[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = data[x + y * width];
                int colour = 0;
                switch (plane) {
                    case RED: {
                        colour = rgb >> 16 & 0xFF;
                        break;
                    }
                    case GREEN: {
                        colour = rgb >> 8 & 0xFF;
                        break;
                    }
                    case BLUE: {
                        colour = rgb & 0xFF;
                        break;
                    }
                }
                this.pixels[y][x] = colour;
            }
        }
    }

    @Override
    public FImage abs() {
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                this.pixels[r][c] = Math.abs(this.pixels[r][c]);
            }
        }
        return this;
    }

    @Override
    public FImage add(FImage im) {
        if (!ImageUtilities.checkSameSize(this, im)) {
            throw new AssertionError((Object)"images must be the same size");
        }
        FImage newImage = new FImage(im.width, im.height);
        for (int r = 0; r < im.height; ++r) {
            for (int c = 0; c < im.width; ++c) {
                newImage.pixels[r][c] = this.pixels[r][c] + im.pixels[r][c];
            }
        }
        return newImage;
    }

    @Override
    public FImage add(Float num) {
        FImage newImage = new FImage(this.width, this.height);
        float fnum = num.floatValue();
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                newImage.pixels[r][c] = this.pixels[r][c] + fnum;
            }
        }
        return newImage;
    }

    @Override
    public FImage add(Image<?, ?> im) {
        if (im instanceof FImage) {
            return this.add((FImage)im);
        }
        throw new UnsupportedOperationException("Unsupported Type");
    }

    @Override
    public FImage addInplace(FImage im) {
        if (!ImageUtilities.checkSameSize(this, im)) {
            throw new AssertionError((Object)"images must be the same size");
        }
        for (int r = 0; r < im.height; ++r) {
            for (int c = 0; c < im.width; ++c) {
                float[] fArray = this.pixels[r];
                int n = c;
                fArray[n] = fArray[n] + im.pixels[r][c];
            }
        }
        return this;
    }

    @Override
    public FImage addInplace(Float num) {
        float fnum = num.floatValue();
        for (int r = 0; r < this.height; ++r) {
            int c = 0;
            while (c < this.width) {
                float[] fArray = this.pixels[r];
                int n = c++;
                fArray[n] = fArray[n] + fnum;
            }
        }
        return this;
    }

    @Override
    public FImage addInplace(Image<?, ?> im) {
        if (im instanceof FImage) {
            return this.addInplace((FImage)im);
        }
        throw new UnsupportedOperationException("Unsupported Type");
    }

    @Override
    public FImage clip(Float min, Float max) {
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                if (this.pixels[r][c] < min.floatValue()) {
                    this.pixels[r][c] = 0.0f;
                }
                if (!(this.pixels[r][c] > max.floatValue())) continue;
                this.pixels[r][c] = 1.0f;
            }
        }
        return this;
    }

    @Override
    public FImage clipMax(Float thresh) {
        float fthresh = thresh.floatValue();
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                if (!(this.pixels[r][c] > fthresh)) continue;
                this.pixels[r][c] = 1.0f;
            }
        }
        return this;
    }

    @Override
    public FImage clipMin(Float thresh) {
        float fthresh = thresh.floatValue();
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                if (!(this.pixels[r][c] < fthresh)) continue;
                this.pixels[r][c] = 0.0f;
            }
        }
        return this;
    }

    @Override
    public FImage clone() {
        FImage cpy = new FImage(this.width, this.height);
        for (int r = 0; r < this.height; ++r) {
            System.arraycopy(this.pixels[r], 0, cpy.pixels[r], 0, this.width);
        }
        return cpy;
    }

    public FImageRenderer createRenderer() {
        return new FImageRenderer(this);
    }

    public FImageRenderer createRenderer(RenderHints options) {
        return new FImageRenderer(this, options);
    }

    @Override
    public FImage divide(FImage im) {
        if (!ImageUtilities.checkSameSize(this, im)) {
            throw new AssertionError((Object)"images must be the same size");
        }
        FImage newImage = new FImage(im.width, im.height);
        for (int r = 0; r < im.height; ++r) {
            for (int c = 0; c < im.width; ++c) {
                newImage.pixels[r][c] = this.pixels[r][c] / im.pixels[r][c];
            }
        }
        return newImage;
    }

    @Override
    public FImage divideInplace(FImage im) {
        if (!ImageUtilities.checkSameSize(this, im)) {
            throw new AssertionError((Object)"images must be the same size");
        }
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                float[] fArray = this.pixels[y];
                int n = x;
                fArray[n] = fArray[n] / im.pixels[y][x];
            }
        }
        return this;
    }

    @Override
    public FImage divideInplace(Float val) {
        float fval = val.floatValue();
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                float[] fArray = this.pixels[y];
                int n = x++;
                fArray[n] = fArray[n] / fval;
            }
        }
        return this;
    }

    @Override
    public FImage divideInplace(float fval) {
        for (int y = 0; y < this.height; ++y) {
            int x = 0;
            while (x < this.width) {
                float[] fArray = this.pixels[y];
                int n = x++;
                fArray[n] = fArray[n] / fval;
            }
        }
        return this;
    }

    @Override
    public FImage divideInplace(Image<?, ?> im) {
        if (im instanceof FImage) {
            return this.divideInplace((FImage)im);
        }
        throw new UnsupportedOperationException("Unsupported Type");
    }

    @Override
    public FImage extractROI(int x, int y, FImage out) {
        int r = y;
        for (int rr = 0; rr < out.height; ++rr) {
            int c = x;
            for (int cc = 0; cc < out.width; ++cc) {
                out.pixels[rr][cc] = r < 0 || r >= this.height || c < 0 || c >= this.width ? 0.0f : this.pixels[r][c];
                ++c;
            }
            ++r;
        }
        return out;
    }

    @Override
    public FImage extractROI(int x, int y, int w, int h) {
        FImage out = new FImage(w, h);
        int r = y;
        for (int rr = 0; rr < h; ++rr) {
            int c = x;
            for (int cc = 0; cc < w; ++cc) {
                out.pixels[rr][cc] = r < 0 || r >= this.height || c < 0 || c >= this.width ? 0.0f : this.pixels[r][c];
                ++c;
            }
            ++r;
        }
        return out;
    }

    @Override
    public FImage fill(Float colour) {
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                this.pixels[r][c] = colour.floatValue();
            }
        }
        return this;
    }

    @Override
    public FImage fill(float colour) {
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                this.pixels[r][c] = colour;
            }
        }
        return this;
    }

    @Override
    public Rectangle getContentArea() {
        int minc = this.width;
        int maxc = 0;
        int minr = this.height;
        int maxr = 0;
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                if (!(this.pixels[r][c] > 0.0f)) continue;
                if (c < minc) {
                    minc = c;
                }
                if (c > maxc) {
                    maxc = c;
                }
                if (r < minr) {
                    minr = r;
                }
                if (r <= maxr) continue;
                maxr = r;
            }
        }
        return new Rectangle((float)minc, (float)minr, (float)(maxc - minc), (float)(maxr - minr));
    }

    public double[] getDoublePixelVector() {
        double[] f = new double[this.height * this.width];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                f[x + y * this.width] = this.pixels[y][x];
            }
        }
        return f;
    }

    @Override
    public FImage getField(Image.Field f) {
        int init;
        FImage img = new FImage(this.width, this.height / 2);
        int r = init = f.equals((Object)Image.Field.ODD) ? 1 : 0;
        for (int r2 = 0; r < this.height && r2 < this.height / 2; r += 2, ++r2) {
            for (int c = 0; c < this.width; ++c) {
                img.pixels[r2][c] = this.pixels[r][c];
            }
        }
        return img;
    }

    @Override
    public FImage getFieldCopy(Image.Field f) {
        FImage img = new FImage(this.width, this.height);
        for (int r = 0; r < this.height; r += 2) {
            for (int c = 0; c < this.width; ++c) {
                if (f.equals((Object)Image.Field.EVEN)) {
                    img.pixels[r][c] = this.pixels[r][c];
                    img.pixels[r + 1][c] = this.pixels[r][c];
                    continue;
                }
                img.pixels[r][c] = this.pixels[r + 1][c];
                img.pixels[r + 1][c] = this.pixels[r + 1][c];
            }
        }
        return img;
    }

    @Override
    public FImage getFieldInterpolate(Image.Field f) {
        FImage img = new FImage(this.width, this.height);
        for (int r = 0; r < this.height; r += 2) {
            for (int c = 0; c < this.width; ++c) {
                if (f.equals((Object)Image.Field.EVEN)) {
                    img.pixels[r][c] = this.pixels[r][c];
                    if (r + 2 == this.height) {
                        img.pixels[r + 1][c] = this.pixels[r][c];
                        continue;
                    }
                    img.pixels[r + 1][c] = 0.5f * (this.pixels[r][c] + this.pixels[r + 2][c]);
                    continue;
                }
                img.pixels[r + 1][c] = this.pixels[r + 1][c];
                img.pixels[r][c] = r == 0 ? this.pixels[r + 1][c] : 0.5f * (this.pixels[r - 1][c] + this.pixels[r + 1][c]);
            }
        }
        return img;
    }

    public float[] getFloatPixelVector() {
        float[] f = new float[this.height * this.width];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                f[x + y * this.width] = this.pixels[y][x];
            }
        }
        return f;
    }

    @Override
    public Float getPixel(int x, int y) {
        return Float.valueOf(this.pixels[y][x]);
    }

    @Override
    public Comparator<? super Float> getPixelComparator() {
        return new Comparator<Float>(){

            @Override
            public int compare(Float o1, Float o2) {
                return o1.compareTo(o2);
            }
        };
    }

    @Override
    public Float getPixelInterp(double x, double y) {
        int x0 = (int)Math.floor(x);
        int x1 = x0 + 1;
        int y0 = (int)Math.floor(y);
        int y1 = y0 + 1;
        if (x0 < 0) {
            x0 = 0;
        }
        if (x0 >= this.width) {
            x0 = this.width - 1;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (y0 >= this.height) {
            y0 = this.height - 1;
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (x1 >= this.width) {
            x1 = this.width - 1;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (y1 >= this.height) {
            y1 = this.height - 1;
        }
        float f00 = this.pixels[y0][x0];
        float f01 = this.pixels[y1][x0];
        float f10 = this.pixels[y0][x1];
        float f11 = this.pixels[y1][x1];
        float dx = (float)(x - (double)x0);
        float dy = (float)(y - (double)y0);
        if (dx < 0.0f) {
            dx = 1.0f + dx;
        }
        if (dy < 0.0f) {
            dy = 1.0f + dy;
        }
        return Float.valueOf(Interpolation.bilerp((float)dx, (float)dy, (float)f00, (float)f01, (float)f10, (float)f11));
    }

    @Override
    public Float getPixelInterp(double x, double y, Float background) {
        int x0 = (int)Math.floor(x);
        int x1 = x0 + 1;
        int y0 = (int)Math.floor(y);
        int y1 = y0 + 1;
        boolean ty1 = true;
        boolean tx1 = true;
        boolean ty0 = true;
        boolean tx0 = true;
        if (x0 < 0) {
            tx0 = false;
        }
        if (x0 >= this.width) {
            tx0 = false;
        }
        if (y0 < 0) {
            ty0 = false;
        }
        if (y0 >= this.height) {
            ty0 = false;
        }
        if (x1 < 0) {
            tx1 = false;
        }
        if (x1 >= this.width) {
            tx1 = false;
        }
        if (y1 < 0) {
            ty1 = false;
        }
        if (y1 >= this.height) {
            ty1 = false;
        }
        double f00 = ty0 && tx0 ? this.pixels[y0][x0] : background.floatValue();
        double f01 = ty1 && tx0 ? this.pixels[y1][x0] : background.floatValue();
        double f10 = ty0 && tx1 ? this.pixels[y0][x1] : background.floatValue();
        double f11 = ty1 && tx1 ? this.pixels[y1][x1] : background.floatValue();
        double dx = x - (double)x0;
        double dy = y - (double)y0;
        if (dx < 0.0) {
            dx = 1.0 + dx;
        }
        if (dy < 0.0) {
            dy = 1.0 + dy;
        }
        double interpVal = Interpolation.bilerp((double)dx, (double)dy, (double)f00, (double)f01, (double)f10, (double)f11);
        return Float.valueOf((float)interpVal);
    }

    public float getPixelInterpNative(float x, float y, float background) {
        int x0 = (int)Math.floor(x);
        int x1 = x0 + 1;
        int y0 = (int)Math.floor(y);
        int y1 = y0 + 1;
        boolean ty1 = true;
        boolean tx1 = true;
        boolean ty0 = true;
        boolean tx0 = true;
        if (x0 < 0) {
            tx0 = false;
        }
        if (x0 >= this.width) {
            tx0 = false;
        }
        if (y0 < 0) {
            ty0 = false;
        }
        if (y0 >= this.height) {
            ty0 = false;
        }
        if (x1 < 0) {
            tx1 = false;
        }
        if (x1 >= this.width) {
            tx1 = false;
        }
        if (y1 < 0) {
            ty1 = false;
        }
        if (y1 >= this.height) {
            ty1 = false;
        }
        float f00 = ty0 && tx0 ? this.pixels[y0][x0] : background;
        float f01 = ty1 && tx0 ? this.pixels[y1][x0] : background;
        float f10 = ty0 && tx1 ? this.pixels[y0][x1] : background;
        float f11 = ty1 && tx1 ? this.pixels[y1][x1] : background;
        float dx = x - (float)x0;
        float dy = y - (float)y0;
        if (dx < 0.0f) {
            dx = 1.0f + dx;
        }
        if (dy < 0.0f) {
            dy = 1.0f + dy;
        }
        float interpVal = Interpolation.bilerpf((float)dx, (float)dy, (float)f00, (float)f01, (float)f10, (float)f11);
        return interpVal;
    }

    @Override
    public FImage internalCopy(FImage im) {
        int h = im.height;
        int w = im.width;
        float[][] impixels = im.pixels;
        for (int r = 0; r < h; ++r) {
            System.arraycopy(impixels[r], 0, this.pixels[r], 0, w);
        }
        return this;
    }

    @Override
    public FImage internalAssign(FImage im) {
        this.pixels = im.pixels;
        this.height = im.height;
        this.width = im.width;
        return this;
    }

    @Override
    public FImage internalAssign(int[] data, int width, int height) {
        if (this.height != height || this.width != width) {
            this.height = height;
            this.width = width;
            this.pixels = new float[height][width];
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = data[x + width * y];
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                float fpix = 0.299f * (float)red + 0.587f * (float)green + 0.114f * (float)blue;
                this.pixels[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[(int)fpix];
            }
        }
        return this;
    }

    @Override
    public FImage inverse() {
        float max = this.max().floatValue();
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                this.pixels[r][c] = max - this.pixels[r][c];
            }
        }
        return this;
    }

    @Override
    public Float max() {
        float max = Float.MIN_VALUE;
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                if (!(max < this.pixels[r][c])) continue;
                max = this.pixels[r][c];
            }
        }
        return Float.valueOf(max);
    }

    public FValuePixel maxPixel() {
        FValuePixel max = new FValuePixel(-1, -1);
        max.value = -3.4028235E38f;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (!(max.value < this.pixels[y][x])) continue;
                max.value = this.pixels[y][x];
                max.x = x;
                max.y = y;
            }
        }
        return max;
    }

    @Override
    public Float min() {
        float min = Float.MAX_VALUE;
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                if (!(min > this.pixels[r][c])) continue;
                min = this.pixels[r][c];
            }
        }
        return Float.valueOf(min);
    }

    public FValuePixel minPixel() {
        FValuePixel min = new FValuePixel(-1, -1);
        min.value = Float.MAX_VALUE;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (!(min.value > this.pixels[y][x])) continue;
                min.value = this.pixels[y][x];
                min.x = x;
                min.y = y;
            }
        }
        return min;
    }

    @Override
    public FImage multiply(Float num) {
        return (FImage)super.multiply(num);
    }

    @Override
    public FImage multiplyInplace(FImage im) {
        if (!ImageUtilities.checkSameSize(this, im)) {
            throw new AssertionError((Object)"images must be the same size");
        }
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                float[] fArray = this.pixels[r];
                int n = c;
                fArray[n] = fArray[n] * im.pixels[r][c];
            }
        }
        return this;
    }

    @Override
    public FImage multiplyInplace(Float num) {
        float fnum = num.floatValue();
        for (int r = 0; r < this.height; ++r) {
            int c = 0;
            while (c < this.width) {
                float[] fArray = this.pixels[r];
                int n = c++;
                fArray[n] = fArray[n] * fnum;
            }
        }
        return this;
    }

    @Override
    public FImage multiplyInplace(float fnum) {
        for (int r = 0; r < this.height; ++r) {
            int c = 0;
            while (c < this.width) {
                float[] fArray = this.pixels[r];
                int n = c++;
                fArray[n] = fArray[n] * fnum;
            }
        }
        return this;
    }

    @Override
    public FImage multiplyInplace(Image<?, ?> im) {
        if (im instanceof FImage) {
            return this.multiplyInplace((FImage)im);
        }
        throw new UnsupportedOperationException("Unsupported Type");
    }

    @Override
    public FImage newInstance(int width, int height) {
        return new FImage(width, height);
    }

    @Override
    public FImage normalise() {
        float min = this.min().floatValue();
        float max = this.max().floatValue();
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                this.pixels[r][c] = (this.pixels[r][c] - min) / (max - min);
            }
        }
        return this;
    }

    @Override
    public FImage process(KernelProcessor<Float, FImage> p) {
        return this.process((KernelProcessor)p, false);
    }

    @Override
    public FImage process(KernelProcessor<Float, FImage> p, boolean pad) {
        FImage newImage = new FImage(this.width, this.height);
        int kh = p.getKernelHeight();
        int kw = p.getKernelWidth();
        FImage tmp = new FImage(kw, kh);
        int hh = kh / 2;
        int hw = kw / 2;
        if (!pad) {
            for (int y = hh; y < this.height - (kh - hh); ++y) {
                for (int x = hw; x < this.width - (kw - hw); ++x) {
                    newImage.pixels[y][x] = p.processKernel(this.extractROI(x - hw, y - hh, tmp)).floatValue();
                }
            }
        } else {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    newImage.pixels[y][x] = p.processKernel(this.extractROI(x - hw, y - hh, tmp)).floatValue();
                }
            }
        }
        return newImage;
    }

    @Override
    public FImage processInplace(PixelProcessor<Float> p) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.pixels[y][x] = p.processPixel(Float.valueOf(this.pixels[y][x])).floatValue();
            }
        }
        return this;
    }

    @Override
    public void analyseWith(PixelAnalyser<Float> p) {
        p.reset();
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                p.analysePixel(Float.valueOf(this.pixels[y][x]));
            }
        }
    }

    @Override
    public void setPixel(int x, int y, Float val) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.pixels[y][x] = val.floatValue();
        }
    }

    @Override
    public FImage subtract(FImage im) {
        if (!ImageUtilities.checkSameSize(this, im)) {
            throw new AssertionError((Object)"images must be the same size");
        }
        FImage newImage = new FImage(im.width, im.height);
        for (int r = 0; r < im.height; ++r) {
            for (int c = 0; c < im.width; ++c) {
                newImage.pixels[r][c] = this.pixels[r][c] - im.pixels[r][c];
            }
        }
        return newImage;
    }

    @Override
    public FImage subtract(Float num) {
        FImage newImage = new FImage(this.width, this.height);
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                newImage.pixels[r][c] = this.pixels[r][c] - num.floatValue();
            }
        }
        return newImage;
    }

    @Override
    public FImage subtract(Image<?, ?> input) {
        if (input instanceof FImage) {
            return this.subtract((FImage)input);
        }
        throw new UnsupportedOperationException("Unsupported Type");
    }

    @Override
    public FImage subtractInplace(FImage im) {
        if (!ImageUtilities.checkSameSize(this, im)) {
            throw new AssertionError((Object)"images must be the same size");
        }
        float[][] pix1 = this.pixels;
        float[][] pix2 = im.pixels;
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                float[] fArray = pix1[r];
                int n = c;
                fArray[n] = fArray[n] - pix2[r][c];
            }
        }
        return this;
    }

    @Override
    public FImage subtractInplace(Float num) {
        float fnum = num.floatValue();
        for (int r = 0; r < this.height; ++r) {
            int c = 0;
            while (c < this.width) {
                float[] fArray = this.pixels[r];
                int n = c++;
                fArray[n] = fArray[n] - fnum;
            }
        }
        return this;
    }

    @Override
    public FImage subtractInplace(Image<?, ?> im) {
        if (im instanceof FImage) {
            return this.subtractInplace((FImage)im);
        }
        throw new UnsupportedOperationException("Unsupported Type");
    }

    @Override
    public FImage threshold(Float thresh) {
        float fthresh = thresh.floatValue();
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                this.pixels[r][c] = this.pixels[r][c] <= fthresh ? 0.0f : 1.0f;
            }
        }
        return this;
    }

    @Override
    public byte[] toByteImage() {
        byte[] pgmData = new byte[this.height * this.width];
        for (int j = 0; j < this.height; ++j) {
            for (int i = 0; i < this.width; ++i) {
                int v = (int)(255.0f * this.pixels[j][i]);
                v = Math.max(0, Math.min(255, v));
                pgmData[i + j * this.width] = (byte)(v & 0xFF);
            }
        }
        return pgmData;
    }

    @Override
    public int[] toPackedARGBPixels() {
        int[] bimg = new int[this.width * this.height];
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                int rgb;
                int v = Math.max(0, Math.min(255, (int)(this.pixels[r][c] * 255.0f)));
                bimg[c + this.width * r] = rgb = 0xFF000000 | v << 16 | v << 8 | v;
            }
        }
        return bimg;
    }

    public String toString() {
        String imageString = "";
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                imageString = imageString + String.format("%+.3f ", Float.valueOf(this.pixels[y][x]));
                if (x != 16 || this.width - 16 <= x) continue;
                imageString = imageString + "... ";
                x = this.width - 16;
            }
            imageString = imageString + "\n";
            if (y != 16 || this.height - 16 <= y) continue;
            y = this.height - 16;
            imageString = imageString + "... \n";
        }
        return imageString;
    }

    public String toString(String format) {
        String imageString = "";
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                imageString = imageString + String.format(format, Float.valueOf(this.pixels[y][x]));
            }
            imageString = imageString + "\n";
        }
        return imageString;
    }

    @Override
    public FImage transform(Matrix transform) {
        return (FImage)super.transform(transform);
    }

    @Override
    public FImage zero() {
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                this.pixels[r][c] = 0.0f;
            }
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof FImage)) {
            return false;
        }
        return this.equalsThresh((FImage)o, 0.0f);
    }

    public boolean equalsThresh(FImage o, float thresh) {
        FImage that = o;
        if (that.height != this.height || that.width != this.width) {
            return false;
        }
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (!(Math.abs(that.pixels[i][j] - this.pixels[i][j]) > thresh)) continue;
                return false;
            }
        }
        return true;
    }

    public float getPixelNative(Pixel p) {
        return this.getPixelNative(p.x, p.y);
    }

    public float getPixelNative(int x, int y) {
        return this.pixels[y][x];
    }

    public float[] getPixelVectorNative(float[] f) {
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                f[x + y * this.getWidth()] = this.pixels[y][x];
            }
        }
        return f;
    }

    public void setPixelNative(int x, int y, float val) {
        this.pixels[y][x] = val;
    }

    public static FImage[] createArray(int num, int width, int height) {
        FImage[] array = new FImage[num];
        for (int i = 0; i < num; ++i) {
            array[i] = new FImage(width, height);
        }
        return array;
    }

    public float sum() {
        float sum = 0.0f;
        for (float[] row : this.pixels) {
            for (int i = 0; i < row.length; ++i) {
                sum += row[i];
            }
        }
        return sum;
    }

    public MBFImage toRGB() {
        return new MBFImage(ColourSpace.RGB, this.clone(), this.clone(), this.clone());
    }

    @Override
    public FImage flipX() {
        int hwidth = this.width / 2;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < hwidth; ++x) {
                int xx = this.width - x - 1;
                float tmp = this.pixels[y][x];
                this.pixels[y][x] = this.pixels[y][xx];
                this.pixels[y][xx] = tmp;
            }
        }
        return this;
    }

    @Override
    public FImage flipY() {
        int hheight = this.height / 2;
        for (int y = 0; y < hheight; ++y) {
            int yy = this.height - y - 1;
            for (int x = 0; x < this.width; ++x) {
                float tmp = this.pixels[y][x];
                this.pixels[y][x] = this.pixels[yy][x];
                this.pixels[yy][x] = tmp;
            }
        }
        return this;
    }

    public FImage overlayInplace(FImage img, FImage alpha, int x, int y) {
        int sx = Math.max(x, 0);
        int sy = Math.max(y, 0);
        int ex = Math.min(this.width, x + img.getWidth());
        int ey = Math.min(this.height, y + img.getHeight());
        for (int yc = sy; yc < ey; ++yc) {
            for (int xc = sx; xc < ex; ++xc) {
                float a = alpha.pixels[yc - sy][xc - sx];
                this.pixels[yc][xc] = a * img.pixels[yc - sy][xc - sx] + (1.0f - a) * this.pixels[yc][xc];
            }
        }
        return this;
    }

    @Override
    public FImage overlayInplace(FImage image, int x, int y) {
        return this.overlayInplace(image, this.clone().fill(1.0f), x, y);
    }

    public static FImage randomImage(int width, int height) {
        FImage img = new FImage(width, height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                img.pixels[y][x] = (float)Math.random();
            }
        }
        return img;
    }

    @Override
    public FImage replace(Float target, Float replacement) {
        return this.replace(target.floatValue(), replacement.floatValue());
    }

    @Override
    public FImage replace(float target, float replacement) {
        for (int r = 0; r < this.height; ++r) {
            for (int c = 0; c < this.width; ++c) {
                if (this.pixels[r][c] != target) continue;
                this.pixels[r][c] = replacement;
            }
        }
        return this;
    }

    @Override
    public FImage extractCentreSubPix(float cx, float cy, FImage out) {
        int width = out.width;
        int height = out.height;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float ix = (float)((double)((float)x + cx) - (double)(width - 1) * 0.5);
                float iy = (float)((double)((float)y + cy) - (double)(height - 1) * 0.5);
                out.pixels[y][x] = this.getPixelInterpNative(ix, iy, 0.0f);
            }
        }
        return out;
    }
}

