/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processor.connectedcomponent.render;

import org.openimaj.image.Image;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.processor.connectedcomponent.render.AbstractRenderer;

public class CentroidRenderer<T>
extends AbstractRenderer<T> {
    public CentroidRenderer(Image<T, ?> image, T colour) {
        super(image, colour);
    }

    public CentroidRenderer(int width, int height, T colour) {
        super(width, height, colour);
    }

    @Override
    public void process(ConnectedComponent cc) {
        double[] centroid = cc.calculateCentroid();
        for (int i = -5; i <= 5; ++i) {
            int y = (int)Math.round(centroid[1]);
            int x = (int)Math.round(centroid[0]);
            if (i + x > 0 && i + x < this.image.getWidth()) {
                this.image.setPixel(x + i, y, this.colour);
            }
            if (i + y <= 0 || i + y >= this.image.getHeight()) continue;
            this.image.setPixel(x, y + i, this.colour);
        }
    }
}

