/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.renderer;

import org.openimaj.image.FImage;
import org.openimaj.image.renderer.ImageRenderer;
import org.openimaj.image.renderer.RenderHints;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Polygon;

public class FImageRenderer
extends ImageRenderer<Float, FImage> {
    public FImageRenderer(FImage targetImage) {
        super(targetImage);
    }

    public FImageRenderer(FImage targetImage, RenderHints hints) {
        super(targetImage, hints);
    }

    @Override
    public Float defaultForegroundColour() {
        return Float.valueOf(1.0f);
    }

    @Override
    public Float defaultBackgroundColour() {
        return Float.valueOf(0.0f);
    }

    @Override
    public void drawLine(int x1, int y1, double theta, int length, int thickness, Float grey) {
        int x2 = x1 + (int)Math.round(Math.cos(theta) * (double)length);
        int y2 = y1 + (int)Math.round(Math.sin(theta) * (double)length);
        this.drawLine(x1, y1, x2, y2, thickness, grey);
    }

    @Override
    public void drawLine(int x0, int y0, int x1, int y1, int thickness, Float grey) {
        this.drawLine((float)x0, (float)y0, (float)x1, (float)y1, thickness, grey);
    }

    @Override
    public void drawLine(float x0, float y0, float x1, float y1, int thickness, Float grey) {
        switch (this.hints.drawingAlgorithm) {
            case ANTI_ALIASED: {
                if (thickness <= 1) {
                    this.drawLineXiaolinWu(x0, y0, x1, y1, grey);
                    break;
                }
                double theta = Math.atan2(y1 - y0, x1 - x0);
                double t = thickness / 2;
                double sin = t * Math.sin(theta);
                double cos = t * Math.cos(theta);
                Polygon p = new Polygon();
                p.addVertex((Point2d)new Point2dImpl((float)((double)x0 - sin), (float)((double)y0 + cos)));
                p.addVertex((Point2d)new Point2dImpl((float)((double)x0 + sin), (float)((double)y0 - cos)));
                p.addVertex((Point2d)new Point2dImpl((float)((double)x1 + sin), (float)((double)y1 - cos)));
                p.addVertex((Point2d)new Point2dImpl((float)((double)x1 - sin), (float)((double)y1 + cos)));
                this.drawPolygonFilled(p, grey);
                break;
            }
            default: {
                this.drawLineBresenham(Math.round(x0), Math.round(y0), Math.round(x1), Math.round(y1), thickness, grey);
            }
        }
    }

    private float fpart(float f) {
        return f - (float)((int)f);
    }

    private float rfpart(float f) {
        return 1.0f - this.fpart(f);
    }

    private void plot(int a, int b, float c, float grey, boolean reversed) {
        int x;
        int y;
        if (reversed) {
            y = a;
            x = b;
        } else {
            x = a;
            y = b;
        }
        if (x >= 0 && x < ((FImage)this.targetImage).width && y >= 0 && y < ((FImage)this.targetImage).height && !Float.isNaN(c)) {
            ((FImage)this.targetImage).pixels[y][x] = c * grey + (1.0f - c) * ((FImage)this.targetImage).pixels[y][x];
        }
    }

    protected void drawLineXiaolinWu(float x1, float y1, float x2, float y2, Float grey) {
        float tmp;
        float dx = x2 - x1;
        float dy = y2 - y1;
        boolean reversed = false;
        if (Math.abs(dx) < Math.abs(dy)) {
            tmp = x1;
            x1 = y1;
            y1 = tmp;
            tmp = x2;
            x2 = y2;
            y2 = tmp;
            tmp = dx;
            dx = dy;
            dy = tmp;
            reversed = true;
        }
        if (x2 < x1) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        float gradient = dy / dx;
        int xend = Math.round(x1);
        float yend = y1 + gradient * ((float)xend - x1);
        float xgap = this.rfpart(x1 + 0.5f);
        int xpxl1 = xend;
        int ypxl1 = (int)yend;
        this.plot(xpxl1, ypxl1, this.rfpart(yend) * xgap, grey.floatValue(), reversed);
        this.plot(xpxl1, ypxl1 + 1, this.fpart(yend) * xgap, grey.floatValue(), reversed);
        float intery = yend + gradient;
        xend = Math.round(x2);
        yend = y2 + gradient * ((float)xend - x2);
        xgap = this.fpart(x2 + 0.5f);
        int xpxl2 = xend;
        int ypxl2 = (int)yend;
        this.plot(xpxl2, ypxl2, this.rfpart(yend) * xgap, grey.floatValue(), reversed);
        this.plot(xpxl2, ypxl2 + 1, this.fpart(yend) * xgap, grey.floatValue(), reversed);
        for (int x = xpxl1 + 1; x <= xpxl2 - 1; ++x) {
            this.plot(x, (int)intery, this.rfpart(intery), grey.floatValue(), reversed);
            this.plot(x, (int)intery + 1, this.fpart(intery), grey.floatValue(), reversed);
            intery += gradient;
        }
    }

    protected void drawLineBresenham(int x0, int y0, int x1, int y1, int thickness, Float grey) {
        boolean steep;
        Line2d line = new Line2d((Point2d)new Point2dImpl((float)x0, (float)y0), (Point2d)new Point2dImpl((float)x1, (float)y1)).lineWithinSquare(((FImage)this.targetImage).getBounds());
        if (line == null) {
            return;
        }
        x0 = (int)line.begin.getX();
        y0 = (int)line.begin.getY();
        x1 = (int)line.end.getX();
        y1 = (int)line.end.getY();
        double theta = Math.atan2(y1 - y0, x1 - x0);
        thickness = (int)Math.round((double)thickness * Math.max(Math.abs(Math.cos(theta)), Math.abs(Math.sin(theta))));
        int offset = thickness / 2;
        int extra = thickness % 2;
        int Dx = x1 - x0;
        int Dy = y1 - y0;
        boolean bl = steep = Math.abs(Dy) >= Math.abs(Dx);
        if (steep) {
            int tmp = x0;
            x0 = y0;
            y0 = tmp;
            tmp = x1;
            x1 = y1;
            y1 = tmp;
            Dx = x1 - x0;
            Dy = y1 - y0;
        }
        int xstep = 1;
        if (Dx < 0) {
            xstep = -1;
            Dx = -Dx;
        }
        int ystep = 1;
        if (Dy < 0) {
            ystep = -1;
            Dy = -Dy;
        }
        int TwoDy = 2 * Dy;
        int TwoDyTwoDx = TwoDy - 2 * Dx;
        int E = TwoDy - Dx;
        int y = y0;
        for (int x = x0; x != x1; x += xstep) {
            int yDraw;
            int xDraw;
            if (steep) {
                xDraw = y;
                yDraw = x;
            } else {
                xDraw = x;
                yDraw = y;
            }
            if (xDraw >= 0 && xDraw < ((FImage)this.targetImage).width && yDraw >= 0 && yDraw < ((FImage)this.targetImage).height) {
                if (thickness == 1) {
                    ((FImage)this.targetImage).pixels[yDraw][xDraw] = grey.floatValue();
                } else if (thickness > 1) {
                    for (int yy = yDraw - offset; yy < yDraw + offset + extra; ++yy) {
                        for (int xx = xDraw - offset; xx < xDraw + offset + extra; ++xx) {
                            if (xx < 0 || yy < 0 || xx >= ((FImage)this.targetImage).width || yy >= ((FImage)this.targetImage).height) continue;
                            ((FImage)this.targetImage).pixels[yy][xx] = grey.floatValue();
                        }
                    }
                }
            }
            if (E > 0) {
                E += TwoDyTwoDx;
                y += ystep;
                continue;
            }
            E += TwoDy;
        }
    }

    @Override
    public void drawPoint(Point2d p, Float grey, int size) {
        if (!((FImage)this.targetImage).getBounds().isInside(p)) {
            return;
        }
        int halfsize = (size + 1) / 2;
        int x = Math.round(p.getX());
        int y = Math.round(p.getY());
        int startx = Math.max(0, x - (halfsize - 1));
        int starty = Math.max(0, y - (halfsize - 1));
        int endx = Math.min(((FImage)this.targetImage).width, x + halfsize);
        int endy = Math.min(((FImage)this.targetImage).height, y + halfsize);
        for (int j = starty; j < endy; ++j) {
            for (int i = startx; i < endx; ++i) {
                ((FImage)this.targetImage).pixels[j][i] = grey.floatValue();
            }
        }
    }

    @Override
    public void drawPolygon(Polygon p, int thickness, Float grey) {
        Point2d p2;
        Point2d p1;
        if (p.nVertices() < 2) {
            return;
        }
        for (int i = 0; i < p.nVertices() - 1; ++i) {
            p1 = (Point2d)p.getVertices().get(i);
            p2 = (Point2d)p.getVertices().get(i + 1);
            this.drawLine(p1.getX(), p1.getY(), p2.getX(), p2.getY(), thickness, grey);
        }
        p1 = (Point2d)p.getVertices().get(p.nVertices() - 1);
        p2 = (Point2d)p.getVertices().get(0);
        this.drawLine(p1.getX(), p1.getY(), p2.getX(), p2.getY(), thickness, grey);
        for (Polygon i : p.getInnerPolys()) {
            this.drawPolygon(i, thickness, grey);
        }
    }

    @Override
    protected void drawHorizLine(int x1, int x2, int y, Float col) {
        if (y < 0 || y > ((FImage)this.targetImage).getHeight() - 1) {
            return;
        }
        int startx = Math.max(0, Math.min(x1, x2));
        int stopx = Math.min(Math.max(x1, x2), ((FImage)this.targetImage).getWidth() - 1);
        float[][] img = ((FImage)this.targetImage).pixels;
        float c = col.floatValue();
        for (int x = startx; x <= stopx; ++x) {
            img[y][x] = c;
        }
    }

    @Override
    protected Float sanitise(Float colour) {
        return colour;
    }
}

