/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.renderer;

import com.caffeineowl.graphics.bezier.BezierUtils;
import com.caffeineowl.graphics.bezier.CubicSegmentConsumer;
import com.caffeineowl.graphics.bezier.CubicSubdivisionCriterion;
import com.caffeineowl.graphics.bezier.QuadSegmentConsumer;
import com.caffeineowl.graphics.bezier.QuadSubdivisionCriterion;
import com.caffeineowl.graphics.bezier.flatnessalgos.SimpleConvexHullSubdivCriterion;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.QuadCurve2D;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openimaj.image.Image;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processor.connectedcomponent.render.BlobRenderer;
import org.openimaj.image.renderer.RenderHints;
import org.openimaj.image.renderer.ScanRasteriser;
import org.openimaj.image.typography.Font;
import org.openimaj.image.typography.FontRenderer;
import org.openimaj.image.typography.FontStyle;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;
import org.openimaj.math.geometry.shape.Polygon;
import org.openimaj.math.geometry.shape.Shape;

public abstract class ImageRenderer<Q, I extends Image<Q, I>> {
    protected RenderHints hints;
    protected I targetImage;

    public ImageRenderer(I targetImage) {
        this(targetImage, new RenderHints());
    }

    public ImageRenderer(I targetImage, RenderHints hints) {
        this.targetImage = targetImage;
        this.hints = hints;
    }

    public void drawConnectedPoints(List<? extends Point2d> pts, Q col) {
        Point2d p0 = pts.get(0);
        for (int i = 1; i < pts.size(); ++i) {
            Point2d p1 = pts.get(i);
            int x0 = Math.round(p0.getX());
            int y0 = Math.round(p0.getY());
            int x1 = Math.round(p1.getX());
            int y1 = Math.round(p1.getY());
            this.drawLine(x0, y0, x1, y1, col);
            p0 = p1;
        }
    }

    public void drawImage(I image, int x, int y) {
        int starty;
        int stopx = Math.min(((Image)this.targetImage).getWidth(), x + ((Image)image).getWidth());
        int stopy = Math.min(((Image)this.targetImage).getHeight(), y + ((Image)image).getHeight());
        int startx = Math.max(0, x);
        for (int yy = starty = Math.max(0, y); yy < stopy; ++yy) {
            for (int xx = startx; xx < stopx; ++xx) {
                ((Image)this.targetImage).setPixel(xx, yy, ((Image)image).getPixel(xx - x, yy - y));
            }
        }
    }

    public void drawImage(I image, int x, int y, Q ... ignoreList) {
        int starty;
        int stopx = Math.min(((Image)this.targetImage).getWidth(), x + ((Image)image).getWidth());
        int stopy = Math.min(((Image)this.targetImage).getHeight(), y + ((Image)image).getHeight());
        int startx = Math.max(0, x);
        for (int yy = starty = Math.max(0, y); yy < stopy; ++yy) {
            for (int xx = startx; xx < stopx; ++xx) {
                Object val = ((Image)image).getPixel(xx - x, yy - y);
                if (Arrays.binarySearch(ignoreList, val, ((Image)this.targetImage).getPixelComparator()) >= 0) continue;
                ((Image)this.targetImage).setPixel(xx, yy, val);
            }
        }
    }

    public abstract void drawLine(int var1, int var2, double var3, int var5, int var6, Q var7);

    public void drawLine(int x1, int y1, double theta, int length, Q col) {
        this.drawLine(x1, y1, theta, length, 1, col);
    }

    public abstract void drawLine(int var1, int var2, int var3, int var4, int var5, Q var6);

    public abstract void drawLine(float var1, float var2, float var3, float var4, int var5, Q var6);

    public void drawLine(int x0, int y0, int x1, int y1, Q col) {
        this.drawLine(x0, y0, x1, y1, 1, col);
    }

    public void drawLine(Point2d p1, Point2d p2, Q col) {
        this.drawLine(Math.round(p1.getX()), Math.round(p1.getY()), Math.round(p2.getX()), Math.round(p2.getY()), 1, col);
    }

    public void drawLine(Point2d p1, Point2d p2, int thickness, Q col) {
        this.drawLine(Math.round(p1.getX()), Math.round(p1.getY()), Math.round(p2.getX()), Math.round(p2.getY()), thickness, col);
    }

    public void drawLine(Line2d line, int thickness, Q col) {
        this.drawLine((int)line.begin.getX(), (int)line.begin.getY(), (int)line.end.getX(), (int)line.end.getY(), thickness, col);
    }

    public void drawLines(Iterable<? extends Line2d> lines, int thickness, Q col) {
        for (Line2d line2d : lines) {
            this.drawLine(line2d, thickness, col);
        }
    }

    public abstract void drawPoint(Point2d var1, Q var2, int var3);

    public void drawPoints(Iterable<? extends Point2d> pts, Q col, int size) {
        for (Point2d point2d : pts) {
            this.drawPoint(point2d, col, size);
        }
    }

    public abstract void drawPolygon(Polygon var1, int var2, Q var3);

    public void drawPolygon(Polygon p, Q col) {
        this.drawPolygon(p, 1, col);
    }

    protected abstract void drawHorizLine(int var1, int var2, int var3, Q var4);

    public void drawPolygonFilled(Polygon p, final Q col) {
        this.drawPolygon(p, col);
        if (p.getNumInnerPoly() == 1) {
            ScanRasteriser.scanFill(p.points, new ScanRasteriser.ScanLineListener(){

                @Override
                public void process(int x1, int x2, int y) {
                    ImageRenderer.this.drawHorizLine(x1, x2, y, col);
                }
            });
        } else {
            ConnectedComponent cc = new ConnectedComponent(p);
            cc.process(new BlobRenderer<Q>(this.targetImage, col));
        }
    }

    public void drawShape(Shape s, int thickness, Q col) {
        this.drawPolygon(s.asPolygon(), thickness, col);
    }

    public void drawShape(Shape p, Q col) {
        this.drawShape(p, 1, col);
    }

    public void drawShapeFilled(Shape s, Q col) {
        col = this.sanitise(col);
        if (s instanceof Polygon) {
            this.drawPolygonFilled((Polygon)s, col);
        } else {
            this.drawShape(s, col);
            int minx = (int)Math.max(0L, Math.round(s.minX()));
            int maxx = (int)Math.min((long)((Image)this.targetImage).getWidth(), Math.round(s.maxX()));
            int miny = (int)Math.max(0L, Math.round(s.minY()));
            int maxy = (int)Math.min((long)((Image)this.targetImage).getHeight(), Math.round(s.maxY()));
            for (int y = miny; y <= maxy; ++y) {
                for (int x = minx; x <= maxx; ++x) {
                    Pixel p = new Pixel(x, y);
                    if (!s.isInside((Point2d)p)) continue;
                    ((Image)this.targetImage).setPixel(p.x, p.y, col);
                }
            }
        }
    }

    public <F extends Font<F>> void drawText(String text, int x, int y, F f, int sz) {
        FontStyle sty = f.createStyle(this);
        sty.setFontSize(sz);
        f.getRenderer(this).renderText(this, text, x, y, sty);
    }

    public <F extends Font<F>> void drawText(String text, int x, int y, F f, int sz, Q col) {
        FontStyle<Q> sty = f.createStyle(this);
        sty.setFontSize(sz);
        sty.setColour(col);
        f.getRenderer(this).renderText(this, text, x, y, sty);
    }

    public <F extends Font<F>> void drawText(String text, Point2d pt, F f, int sz) {
        FontStyle sty = f.createStyle(this);
        sty.setFontSize(sz);
        f.getRenderer(this).renderText(this, text, (int)pt.getX(), (int)pt.getY(), sty);
    }

    public <F extends Font<F>> void drawText(String text, Point2d pt, F f, int sz, Q col) {
        FontStyle<Q> sty = f.createStyle(this);
        sty.setFontSize(sz);
        sty.setColour(col);
        f.getRenderer(this).renderText(this, text, (int)pt.getX(), (int)pt.getY(), sty);
    }

    public void drawText(String text, int x, int y, FontStyle<Q> f) {
        f.getRenderer(this).renderText(this, text, x, y, f);
    }

    public void drawText(String text, Point2d pt, FontStyle<Q> f) {
        f.getRenderer(this).renderText(this, text, (int)pt.getX(), (int)pt.getY(), f);
    }

    public void drawText(AttributedString text, int x, int y) {
        FontRenderer.renderText(this, text, x, y);
    }

    public void drawText(AttributedString text, Point2d pt) {
        FontRenderer.renderText(this, text, (int)pt.getX(), (int)pt.getY());
    }

    public Point2d[] drawCubicBezier(Point2d p1, Point2d p2, Point2d c1, Point2d c2, int thickness, Q col) {
        final ArrayList points = new ArrayList();
        CubicCurve2D.Double c = new CubicCurve2D.Double(p1.getX(), p1.getY(), c1.getX(), c1.getY(), c2.getX(), c2.getY(), p2.getX(), p2.getY());
        BezierUtils.adaptiveHalving((CubicCurve2D)c, (CubicSubdivisionCriterion)new SimpleConvexHullSubdivCriterion(), (CubicSegmentConsumer)new CubicSegmentConsumer(){

            public void processSegment(CubicCurve2D segment, double startT, double endT) {
                if (0.0 == startT) {
                    points.add(new Point2dImpl((float)segment.getX1(), (float)segment.getY1()));
                }
                points.add(new Point2dImpl((float)segment.getX2(), (float)segment.getY2()));
            }
        });
        Point2d last = null;
        for (Point2d p : points) {
            if (last != null) {
                this.drawLine((int)last.getX(), (int)last.getY(), (int)p.getX(), (int)p.getY(), thickness, col);
            }
            last = p;
        }
        return points.toArray(new Point2d[1]);
    }

    public Point2d[] drawQuadBezier(Point2d p1, Point2d p2, Point2d c1, int thickness, Q colour) {
        final ArrayList points = new ArrayList();
        QuadCurve2D.Double c = new QuadCurve2D.Double(p1.getX(), p1.getY(), c1.getX(), c1.getY(), p2.getX(), p2.getY());
        BezierUtils.adaptiveHalving((QuadCurve2D)c, (QuadSubdivisionCriterion)new SimpleConvexHullSubdivCriterion(), (QuadSegmentConsumer)new QuadSegmentConsumer(){

            public void processSegment(QuadCurve2D segment, double startT, double endT) {
                if (0.0 == startT) {
                    points.add(new Point2dImpl((float)segment.getX1(), (float)segment.getY1()));
                }
                points.add(new Point2dImpl((float)segment.getX2(), (float)segment.getY2()));
            }
        });
        Point2d last = null;
        for (Point2d p : points) {
            if (last != null) {
                this.drawLine((int)last.getX(), (int)last.getY(), (int)p.getX(), (int)p.getY(), thickness, colour);
            }
            last = p;
        }
        return points.toArray(new Point2d[1]);
    }

    public abstract Q defaultForegroundColour();

    public abstract Q defaultBackgroundColour();

    public I getImage() {
        return this.targetImage;
    }

    public void setImage(I image) {
        this.targetImage = image;
    }

    public RenderHints getRenderHints() {
        return this.hints;
    }

    public void setRenderHints(RenderHints hints) {
        this.hints = hints;
    }

    protected abstract Q sanitise(Q var1);
}

