/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.html;

import java.util.Collection;
import org.apache.commons.lang3.StringEscapeUtils;
import org.rapidoid.html.BasicUtils;
import org.rapidoid.html.Tag;
import org.rapidoid.html.TagContext;
import org.rapidoid.html.TagProcessor;
import org.rapidoid.html.TagWidget;
import org.rapidoid.html.impl.ConstantTag;
import org.rapidoid.html.impl.TagContextImpl;
import org.rapidoid.html.impl.TagProxy;
import org.rapidoid.html.impl.UndefinedTag;
import org.rapidoid.html.tag.InputTag;
import org.rapidoid.html.tag.OptionTag;
import org.rapidoid.html.tag.TextareaTag;
import org.rapidoid.util.U;
import org.rapidoid.var.Var;
import org.rapidoid.var.Vars;

public class Tags
extends BasicUtils {
    public static <T> Var<T> var(T value) {
        return Vars.var(value);
    }

    public static TagContext context() {
        return new TagContextImpl();
    }

    public static <TAG extends Tag> TAG tag(Class<TAG> clazz, String tagName, Object ... contents) {
        return TagProxy.create(clazz, tagName, contents);
    }

    public static ConstantTag constant(String code) {
        return new ConstantTag(code);
    }

    public static String escape(String s) {
        return StringEscapeUtils.escapeHtml4((String)s);
    }

    public static void traverse(Object contents, TagProcessor<Tag> processor) {
        block8: {
            block9: {
                block7: {
                    if (!(contents instanceof Tag)) break block7;
                    if (contents instanceof UndefinedTag) {
                        UndefinedTag tag = (UndefinedTag)contents;
                        tag.traverse(processor);
                    } else {
                        Tag tag = (Tag)contents;
                        processor.handle(tag);
                        Tags.traverse(tag.content(), processor);
                    }
                    break block8;
                }
                if (!(contents instanceof TagWidget)) break block9;
                Object widgetContent = ((TagWidget)contents).render(null);
                if (widgetContent == null) break block8;
                Tags.traverse(widgetContent, processor);
                break block8;
            }
            if (contents instanceof Object[]) {
                Object[] arr;
                for (Object cont : arr = (Object[])contents) {
                    Tags.traverse(cont, processor);
                }
            } else if (contents instanceof Collection) {
                Collection coll = (Collection)contents;
                for (Object cont : coll) {
                    Tags.traverse(cont, processor);
                }
            }
        }
    }

    public static <T extends Tag> T withValue(T tag, Object value) {
        if (tag instanceof InputTag) {
            InputTag input = (InputTag)tag;
            if ("checkbox".equals(input.type()) || "radio".equals(input.type())) {
                return (T)input.checked(value != null ? Tags.bool(value) : false);
            }
            return (T)input.value(value != null ? Tags.str(value) : "");
        }
        if (tag instanceof TextareaTag) {
            TextareaTag textArea = (TextareaTag)tag;
            return (T)textArea.content(value != null ? Tags.str(value) : "");
        }
        if (tag instanceof OptionTag) {
            OptionTag optionTag = (OptionTag)tag;
            return (T)optionTag.selected(value != null ? Tags.bool(value) : false);
        }
        throw U.rte((String)"Cannot set value to a '%s' tag!", (Object[])new Object[]{tag.tagKind()});
    }
}

