/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.html.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.rapidoid.html.CustomTag;
import org.rapidoid.html.HTML;
import org.rapidoid.html.Tag;
import org.rapidoid.html.TagContext;
import org.rapidoid.html.TagWidget;
import org.rapidoid.html.impl.ConstantTag;
import org.rapidoid.html.impl.TagImpl;
import org.rapidoid.html.impl.TagInternals;
import org.rapidoid.util.Cls;
import org.rapidoid.util.Constants;
import org.rapidoid.util.U;
import org.rapidoid.var.Var;

public class TagRenderer {
    private static final byte[] EMIT_CLOSE = "')".getBytes();
    private static final byte[] INDENT = "  ".getBytes();
    private static final byte[] EMIT = "_emit('".getBytes();
    private static final byte[] _H = " _h=\"".getBytes();
    private static final byte[] EQ_DQUOTES = "=\"".getBytes();
    private static final byte[] LT = "<".getBytes();
    private static final byte[] DQUOTES = "\"".getBytes();
    private static final byte[] LT_SLASH = "</".getBytes();
    private static final byte[] GT = ">".getBytes();
    protected static final TagRenderer INSTANCE = new TagRenderer();

    public static TagRenderer get() {
        return INSTANCE;
    }

    public String toHTML(TagContext ctx, Object content, Object extra) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.str(ctx, content, extra, out);
        return out.toString();
    }

    public void str(TagContext ctx, Object content, Object extra, OutputStream out) {
        this.str(ctx, content, 0, false, extra, out);
    }

    public void str(TagContext ctx, Object content, int level, boolean inline, Object extra, OutputStream out) {
        if (content instanceof ConstantTag) {
            ConstantTag constantTag = (ConstantTag)content;
            this.write(out, constantTag.bytes());
            return;
        }
        if (content instanceof Tag) {
            Tag tag = (Tag)content;
            TagInternals tagi = (TagInternals)((Object)tag);
            this.str(ctx, tagi.base(), level, inline, extra, out);
            return;
        }
        if (content instanceof TagWidget) {
            TagWidget widget = (TagWidget)content;
            Object widgetContent = widget.render(extra);
            if (widgetContent != null) {
                this.str(ctx, widgetContent, level, inline, extra, out);
            }
            return;
        }
        if (content instanceof Object[]) {
            this.join(ctx, (Object[])content, level, inline, extra, out);
            return;
        }
        if (content instanceof Collection) {
            this.join(ctx, (Collection)content, level, inline, extra, out);
            return;
        }
        this.indent(out, level, inline);
        this.write(out, HTML.escape(U.readable((Object)content)));
    }

    protected void join(TagContext ctx, Collection<?> items, int level, boolean inline, Object extra, OutputStream out) {
        for (Object item : items) {
            if (!inline) {
                this.write(out, Constants.CR_LF);
            }
            this.str(ctx, item, level + 1, inline, extra, out);
        }
    }

    protected void join(TagContext ctx, Object[] items, int level, boolean inline, Object extra, OutputStream out) {
        for (int i = 0; i < items.length; ++i) {
            if (!inline) {
                this.write(out, Constants.CR_LF);
            }
            this.str(ctx, items[i], level + 1, inline, extra, out);
        }
    }

    public void str(TagContext ctx, TagImpl tag, int level, boolean inline, Object extra, OutputStream out) {
        Object b;
        U.notNull((Object)ctx, (String)"tag context", (Object[])new Object[0]);
        if (tag.binding != null) {
            tag._h = ctx.newBinding(tag.binding);
        }
        String name = HTML.escape(tag.name);
        List<Object> contents = tag.contents;
        this.indent(out, level, inline);
        this.write(out, LT);
        this.write(out, name);
        if (tag._h >= 0) {
            this.write(out, _H);
            this.attrToStr(out, tag, "_h", tag._h);
            this.write(out, DQUOTES);
        }
        for (Map.Entry<String, String> e : tag.attrs.entrySet()) {
            String attr = e.getKey();
            String value = e.getValue();
            if (tag.binding != null && attr.equals("value")) {
                value = tag.attr(attr);
            }
            this.writeAttr(tag, out, attr, value);
        }
        for (String attr : tag.battrs) {
            if (tag.binding != null && (attr.equals("checked") || attr.equals("selected"))) continue;
            this.writeBAttr(out, attr);
        }
        if (tag.binding != null && (b = tag.binding.get()) instanceof Boolean && ((Boolean)b).booleanValue()) {
            if (tag.name.equals("option")) {
                this.writeBAttr(out, "selected");
            } else if (tag.name.equals("input")) {
                this.writeBAttr(out, "checked");
            }
        }
        if (tag.cmd != null) {
            int eventHnd = ctx.newCommand(tag.cmd);
            this.write(out, " ng-click");
            this.write(out, EQ_DQUOTES);
            this.write(out, EMIT);
            this.write(out, eventHnd + "");
            this.write(out, EMIT_CLOSE);
            this.write(out, DQUOTES);
        }
        this.write(out, GT);
        if (this.isSingleTag(name)) {
            return;
        }
        if (contents == null || contents.isEmpty()) {
            this.closeTag(out, name);
            return;
        }
        if (inline || this.shouldRenderInline(name, contents)) {
            this.str(ctx, contents, level + 1, true, extra, out);
            this.closeTag(out, name);
            return;
        }
        if (contents != null) {
            this.str(ctx, contents, level, inline, extra, out);
        }
        this.write(out, Constants.CR_LF);
        this.indent(out, level, inline);
        this.closeTag(out, name);
    }

    private void writeBAttr(OutputStream out, String attr) {
        this.write(out, Constants.SPACE_);
        this.write(out, HTML.escape(attr));
    }

    private void writeAttr(TagImpl tag, OutputStream out, String attr, String value) {
        this.writeBAttr(out, attr);
        this.write(out, EQ_DQUOTES);
        this.attrToStr(out, tag, attr, value);
        this.write(out, DQUOTES);
    }

    private void closeTag(OutputStream out, String name) {
        this.write(out, LT_SLASH);
        this.write(out, name);
        this.write(out, GT);
    }

    protected boolean isSingleTag(String name) {
        return name.equals("input") || name.equals("br") || name.equals("link") || name.equals("img");
    }

    protected void attrToStr(OutputStream out, TagImpl tag, String attr, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Object[]) {
            Object[] arr = (Object[])value;
            this.write(out, U.join((String)" ", (Object[])arr));
            return;
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            this.write(out, U.join((String)" ", (Iterable)coll));
            return;
        }
        this.write(out, HTML.escape(value.toString()));
    }

    protected boolean shouldRenderInline(String name, Object content) {
        if (this.isSimpleContent(content)) {
            return true;
        }
        if (content instanceof Object[]) {
            return this.hasSimpleContent((Object[])content);
        }
        if (content instanceof Collection) {
            return this.hasSimpleContent((Collection)content);
        }
        return false;
    }

    protected boolean isSimpleContent(Object content) {
        if (content instanceof Var) {
            Var var = (Var)content;
            return this.isSimpleContent(var.get());
        }
        if (content instanceof ConstantTag) {
            return true;
        }
        return !Cls.instanceOf((Object)content, (Class[])new Class[]{Tag.class, CustomTag.class, TagWidget.class, Object[].class, Collection.class});
    }

    protected boolean hasSimpleContent(Collection<?> content) {
        for (Object cnt : content) {
            if (!this.isSimpleContent(cnt)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSimpleContent(Object[] content) {
        for (Object cnt : content) {
            if (!this.isSimpleContent(cnt)) continue;
            return true;
        }
        return false;
    }

    protected void write(OutputStream out, byte[] bytes) {
        try {
            out.write(bytes);
        }
        catch (IOException e) {
            throw U.rte((String)"Cannot render tag!", (Throwable)e);
        }
    }

    protected void write(OutputStream out, String s) {
        this.write(out, s.getBytes());
    }

    protected void indent(OutputStream out, int level, boolean inline) {
        if (!inline) {
            for (int i = 0; i < level; ++i) {
                this.write(out, INDENT);
            }
        }
    }
}

