/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.jpa;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.rapidoid.RapidoidThing;
import org.rapidoid.jpa.JPA;
import org.rapidoid.u.U;

public abstract class DAO<E>
extends RapidoidThing {
    private final Class<E> clazz;

    private static Class<?> inferEntityType(Class<? extends DAO<?>> daoClass) {
        U.must((daoClass.getSuperclass() == DAO.class ? 1 : 0) != 0, (String)"Expected DAO to be superclass of %s, but found: %s!", daoClass, daoClass.getSuperclass());
        Type type = daoClass.getGenericSuperclass();
        ParameterizedType genericDao = type instanceof ParameterizedType ? (ParameterizedType)type : null;
        U.must((genericDao != null && genericDao.getActualTypeArguments().length > 0 ? 1 : 0) != 0, (String)"Cannot infer entity type for: %s", daoClass);
        Type arg = genericDao.getActualTypeArguments()[0];
        return arg instanceof Class ? (Class)arg : Object.class;
    }

    public DAO() {
        this.clazz = DAO.inferEntityType(((Object)((Object)this)).getClass());
    }

    public DAO(Class<E> clazz) {
        this.clazz = clazz;
    }

    public Class<E> getEntityType() {
        return this.clazz;
    }

    public Object insert(E record) {
        return JPA.insert(record);
    }

    public void update(E record) {
        JPA.update(record);
    }

    public void deleteById(Object id) {
        JPA.delete(this.clazz, id);
    }

    public void delete(E record) {
        JPA.delete(record);
    }

    public E get(Object id) {
        return JPA.get(this.clazz, id);
    }

    public List<E> all() {
        return JPA.of(this.clazz).all();
    }
}

