/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.jpa;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.EntityType;
import javax.sql.DataSource;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.datamodel.Results;
import org.rapidoid.jdbc.JDBC;
import org.rapidoid.jpa.JPATool;
import org.rapidoid.jpa.JPAUtil;
import org.rapidoid.jpa.JPQL;
import org.rapidoid.u.U;

public class JPA
extends RapidoidThing {
    public static EntityManager em() {
        return JPAUtil.em();
    }

    public static EntityManager currentEM() {
        return JPAUtil.currentEntityManager();
    }

    public static JPATool with(EntityManager em) {
        return new JPATool(em, true);
    }

    private static JPATool tool() {
        Ctx ctx = Ctxs.get();
        if (ctx != null) {
            EntityManager em = (EntityManager)ctx.persister();
            return new JPATool(em, true);
        }
        EntityManagerFactory emf = JPAUtil.emf();
        U.must((emf != null ? 1 : 0) != 0, (String)"JPA hasn't been initialized! (JPA.emf is null)");
        EntityManager em = emf.createEntityManager();
        return new JPATool(em, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> E reference(Class<E> clazz, Object id) {
        JPATool jpa = JPA.tool();
        try {
            E e = jpa.reference(clazz, id);
            return e;
        }
        finally {
            jpa.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> E get(Class<E> clazz, Object id) {
        JPATool jpa = JPA.tool();
        try {
            E e = jpa.get(clazz, id);
            return e;
        }
        finally {
            jpa.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getIfExists(Class<T> clazz, Object id) {
        JPATool jpa = JPA.tool();
        try {
            T t = jpa.getIfExists(clazz, id);
            return t;
        }
        finally {
            jpa.done();
        }
    }

    public static <E> List<E> getAllEntities() {
        JPATool jpa = JPA.tool();
        try {
            List list = jpa.getAllEntities();
            return list;
        }
        finally {
            jpa.done();
        }
    }

    public static <E> E save(E record) {
        JPATool jpa = JPA.tool();
        try {
            E e = jpa.save(record);
            return e;
        }
        finally {
            jpa.done();
        }
    }

    public static <E> E insert(E entity) {
        JPATool jpa = JPA.tool();
        try {
            E e = jpa.insert(entity);
            return e;
        }
        finally {
            jpa.done();
        }
    }

    public static <E> E update(E record) {
        JPATool jpa = JPA.tool();
        try {
            E e = jpa.update(record);
            return e;
        }
        finally {
            jpa.done();
        }
    }

    public static void delete(Object record) {
        JPATool jpa = JPA.tool();
        try {
            jpa.delete(record);
        }
        finally {
            jpa.done();
        }
    }

    public static <E> void delete(Class<E> clazz, Object id) {
        JPATool jpa = JPA.tool();
        try {
            jpa.delete(clazz, id);
        }
        finally {
            jpa.done();
        }
    }

    public static void refresh(Object entity) {
        JPATool jpa = JPA.tool();
        try {
            jpa.refresh(entity);
        }
        finally {
            jpa.done();
        }
    }

    public static <E> E merge(E entity) {
        JPATool jpa = JPA.tool();
        try {
            E e = jpa.merge(entity);
            return e;
        }
        finally {
            jpa.done();
        }
    }

    public static void detach(Object entity) {
        JPATool jpa = JPA.tool();
        try {
            jpa.detach(entity);
        }
        finally {
            jpa.done();
        }
    }

    public static void flush() {
        JPATool jpa = JPA.tool();
        try {
            jpa.flush();
        }
        finally {
            jpa.done();
        }
    }

    public static DataSource bootstrapDatasource() {
        DataSource dataSource = JDBC.bootstrapDatasource();
        U.notNull((Object)dataSource, (String)"JPA data source", (Object[])new Object[0]);
        return dataSource;
    }

    public static void bootstrap(String[] path, Class<?> ... providedEntities) {
        JPAUtil.bootstrap(path, JPA.bootstrapDatasource(), providedEntities);
    }

    public static void bootstrap(String[] path, DataSource dataSource, Class<?> ... providedEntities) {
        JPAUtil.bootstrap(path, dataSource, providedEntities);
    }

    public static void transaction(Runnable action) {
        JPA.transaction(action, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transaction(Runnable action, boolean readOnly) {
        boolean newContext;
        Ctx ctx = Ctxs.get();
        boolean bl = newContext = ctx == null;
        if (newContext) {
            ctx = Ctxs.open((String)"transaction");
        }
        try {
            EntityManager em = (EntityManager)ctx.persister();
            JPA.with(em).transactional(action, readOnly);
        }
        finally {
            if (newContext) {
                Ctxs.close();
            }
        }
    }

    public static boolean isLoaded(Object entity) {
        JPATool jpa = JPA.tool();
        try {
            boolean bl = jpa.isLoaded(entity);
            return bl;
        }
        finally {
            jpa.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoaded(Object entity, String attribute) {
        JPATool jpa = JPA.tool();
        try {
            boolean bl = jpa.isLoaded(entity, attribute);
            return bl;
        }
        finally {
            jpa.done();
        }
    }

    public static Object getIdentifier(Object entity) {
        JPATool jpa = JPA.tool();
        try {
            Object object = jpa.getIdentifier(entity);
            return object;
        }
        finally {
            jpa.done();
        }
    }

    public static boolean isEntity(Object obj) {
        return JPAUtil.isEntity(obj);
    }

    public static List<EntityType<?>> getEntityTypes() {
        JPATool jpa = JPA.tool();
        try {
            List<EntityType<?>> list = jpa.getEntityTypes();
            return list;
        }
        finally {
            jpa.done();
        }
    }

    public static List<String> entities() {
        return JPAUtil.entities;
    }

    public static List<Class<?>> getEntityJavaTypes() {
        return JPAUtil.entityJavaTypes;
    }

    public static EntityManagerFactory provideEmf() {
        EntityManagerFactory emf = JPAUtil.emf;
        U.notNull((Object)emf, (String)"JPA.emf", (Object[])new Object[0]);
        return emf;
    }

    public static EntityManagerFactory getEmf() {
        return JPAUtil.emf;
    }

    public static void setEmf(EntityManagerFactory emf) {
        JPAUtil.emf(emf);
    }

    public static <T> T unproxy(T entity) {
        return JPAUtil.unproxy(entity);
    }

    public static boolean isActive() {
        return JPAUtil.emf() != null;
    }

    public static <T> Results<T> of(Class<T> clazz) {
        JPATool jpa = JPA.tool();
        try {
            Results<T> results = jpa.of(clazz);
            return results;
        }
        finally {
            jpa.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long count(Class<?> clazz) {
        JPATool jpa = JPA.tool();
        try {
            long l = jpa.count(clazz);
            return l;
        }
        finally {
            jpa.done();
        }
    }

    public static <T> Results<T> find(CriteriaQuery<T> criteria) {
        JPATool jpa = JPA.tool();
        try {
            Results<T> results = jpa.find(criteria);
            return results;
        }
        finally {
            jpa.done();
        }
    }

    public static void bind(Query query, Map<String, ?> namedArgs, Object ... args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                query.setParameter(i + 1, args[i]);
            }
        }
        if (namedArgs != null) {
            for (Parameter param : query.getParameters()) {
                String name = param.getName();
                if (!U.notEmpty((String)name)) continue;
                U.must((boolean)namedArgs.containsKey(name), (String)"A named argument wasn't specified for the named JPQL parameter: %s", (Object)name);
                query.setParameter(name, Cls.convert(namedArgs.get(name), (Class)param.getParameterType()));
            }
        }
    }

    public static JPQL jpql(String jpql) {
        return new JPQL(jpql);
    }

    public static JPQL jpql(String jpql, Object ... args) {
        return new JPQL(jpql).bind(args);
    }
}

