/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.jpa;

import java.net.ConnectException;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.metamodel.EntityType;
import javax.sql.DataSource;
import org.hibernate.proxy.HibernateProxy;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.jpa.EMFUtil;
import org.rapidoid.jpa.impl.CustomHibernatePersistenceProvider;
import org.rapidoid.jpa.impl.JPAInternals;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.util.MscOpts;

public class JPAUtil
extends RapidoidThing {
    static volatile EntityManagerFactory emf;
    static final List<String> entities;
    static final List<Class<?>> entityJavaTypes;

    public static void reset() {
        emf = null;
        entities.clear();
        entityJavaTypes.clear();
    }

    public static EntityManager em() {
        Ctx ctx = Ctxs.get();
        if (ctx != null) {
            return JPAInternals.wrapEM((EntityManager)ctx.persister());
        }
        EntityManagerFactory emf = JPAUtil.emf;
        U.notNull((Object)emf, (String)"JPA.emf", (Object[])new Object[0]);
        return JPAInternals.wrapEM(emf.createEntityManager());
    }

    public static EntityManager currentEntityManager() {
        return (EntityManager)Ctxs.required().persister();
    }

    public static void bootstrap(String[] path, DataSource dataSource, Class<?> ... providedEntities) {
        if (MscOpts.hasHibernate()) {
            if (JPAUtil.emf() == null) {
                JPAUtil.bootstrapJPA(path, dataSource, providedEntities);
            } else {
                Log.info((String)"JPA has already been bootstrapped");
            }
        } else {
            Log.warn((String)"Couldn't find Hibernate, cannot bootstrap JPA!");
        }
    }

    private static void bootstrapJPA(String[] path, DataSource dataSource, Class<?>[] providedEntities) {
        Msc.logSection((String)"Bootstrapping JPA (Hibernate)...");
        List<String> entityTypes = EMFUtil.getEntityTypes(path, providedEntities);
        if (entityTypes.isEmpty()) {
            Log.info((String)"Didn't find JPA entities, canceling JPA/Hibernate setup!");
            return;
        }
        Properties props = EMFUtil.hibernateProperties();
        Msc.logSection((String)"Hibernate properties:");
        Msc.logProperties((Properties)props);
        Msc.logSection((String)"Starting Hibernate:");
        CustomHibernatePersistenceProvider provider = new CustomHibernatePersistenceProvider(dataSource);
        provider.names().addAll(entityTypes);
        EntityManagerFactory emf = JPAUtil.createEMF(props, provider);
        JPAUtil.emf(emf);
        Msc.logSection((String)"JPA (Hibernate) is ready.");
    }

    private static EntityManagerFactory createEMF(Properties props, CustomHibernatePersistenceProvider provider) {
        while (true) {
            try {
                return provider.createEntityManagerFactory("rapidoid", props);
            }
            catch (Exception e) {
                if (Msc.rootCause((Throwable)e) instanceof ConnectException) {
                    Log.warn((String)"Couldn't connect, will retry again in 3 seconds...");
                    U.sleep((long)3000L);
                    continue;
                }
                throw U.rte((String)"Failed to create EMF!", (Throwable)e);
            }
            break;
        }
    }

    public static boolean isEntity(Object obj) {
        if (obj == null) {
            return false;
        }
        if (entities.contains(obj.getClass().getName())) {
            return true;
        }
        for (Class<?> type : entityJavaTypes) {
            if (!type.isAssignableFrom(obj.getClass())) continue;
            return true;
        }
        return false;
    }

    public static <T> T unproxy(T entity) {
        return Cls.exists((String)"org.hibernate.proxy.HibernateProxy") ? JPAUtil._unproxy(entity) : entity;
    }

    private static <T> T _unproxy(T entity) {
        if (Cls.exists((String)"org.hibernate.proxy.HibernateProxy") && entity instanceof HibernateProxy) {
            entity = ((HibernateProxy)entity).getHibernateLazyInitializer().getImplementation();
        }
        return entity;
    }

    public static void emf(EntityManagerFactory emf) {
        U.notNull((Object)emf, (String)"emf", (Object[])new Object[0]);
        JPAUtil.reset();
        JPAUtil.emf = emf;
        for (EntityType entityType : emf.getMetamodel().getEntities()) {
            Class type = entityType.getJavaType();
            entityJavaTypes.add(type);
            entities.add(type.getName());
        }
    }

    public static EntityManagerFactory emf() {
        return emf;
    }

    public static <T> List<T> getPage(Query q, long skip, long limit) {
        U.must((skip < Integer.MAX_VALUE && skip >= 0L ? 1 : 0) != 0);
        U.must((limit >= -1L ? 1 : 0) != 0);
        limit = Math.min(limit, Integer.MAX_VALUE);
        q.setFirstResult((int)skip);
        q.setMaxResults(limit >= 0L ? (int)limit : Integer.MAX_VALUE);
        return q.getResultList();
    }

    static {
        entities = U.list();
        entityJavaTypes = U.list();
    }
}

