/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.render;

import org.rapidoid.RapidoidThing;
import org.rapidoid.cache.Cache;
import org.rapidoid.cache.Caching;
import org.rapidoid.env.Env;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.render.RapidoidTemplate;
import org.rapidoid.render.Template;
import org.rapidoid.render.TemplateFactory;
import org.rapidoid.render.TemplateParser;
import org.rapidoid.render.TemplateRenderer;
import org.rapidoid.render.TemplateStore;
import org.rapidoid.u.U;

public class RapidoidTemplateFactory
extends RapidoidThing
implements TemplateFactory {
    private static final int CACHE_TTL = Env.dev() ? 100 : 0;
    private final TemplateStore templateStore;
    private final Cache<String, RapidoidTemplate> compiledTemplates;

    public RapidoidTemplate loadAndCompile(String filename) {
        return new RapidoidTemplate(filename, this.loadTemplate(filename), this);
    }

    public RapidoidTemplateFactory(String name, TemplateStore templateStore) {
        this.templateStore = templateStore;
        this.compiledTemplates = Caching.of((Mapper)new Mapper<String, RapidoidTemplate>(){

            public RapidoidTemplate map(String filename) throws Exception {
                return RapidoidTemplateFactory.this.loadAndCompile(filename);
            }
        }).name(name).capacity(10000).ttl((long)CACHE_TTL).manageable(true).statistics(true).build();
    }

    @Override
    public void reset() {
        this.compiledTemplates.clear();
    }

    @Override
    public Template load(String filename, Class<?> modelType) {
        return (Template)this.compiledTemplates.get((Object)filename);
    }

    @Override
    public Template compile(String source, Class<?> modelType) {
        return new RapidoidTemplate(null, TemplateParser.parse(source).compile(modelType), this);
    }

    protected TemplateRenderer loadTemplate(String filename) {
        String content;
        try {
            content = this.templateStore.loadTemplate(filename);
        }
        catch (Exception e) {
            throw U.rte((String)("Couldn't load template: " + filename), (Throwable)e);
        }
        return TemplateParser.parse(content).compile();
    }
}

