/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.LettuceFutures;
import com.lambdaworks.redis.ReadFrom;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.AbstractNodeSelection;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.ClusterDistributionChannelWriter;
import com.lambdaworks.redis.cluster.DynamicSyncNodeSelection;
import com.lambdaworks.redis.cluster.NodeSelectionInvocationHandler;
import com.lambdaworks.redis.cluster.RedisAdvancedClusterAsyncCommandsImpl;
import com.lambdaworks.redis.cluster.RedisAdvancedClusterConnection;
import com.lambdaworks.redis.cluster.RedisAdvancedClusterReactiveCommandsImpl;
import com.lambdaworks.redis.cluster.StaticSyncNodeSelection;
import com.lambdaworks.redis.cluster.api.NodeSelectionSupport;
import com.lambdaworks.redis.cluster.api.StatefulRedisClusterConnection;
import com.lambdaworks.redis.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import com.lambdaworks.redis.cluster.api.rx.RedisAdvancedClusterReactiveCommands;
import com.lambdaworks.redis.cluster.api.sync.NodeSelection;
import com.lambdaworks.redis.cluster.api.sync.NodeSelectionCommands;
import com.lambdaworks.redis.cluster.api.sync.RedisAdvancedClusterCommands;
import com.lambdaworks.redis.cluster.api.sync.RedisClusterCommands;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.AbstractInvocationHandler;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.protocol.CompleteableCommand;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.netty.channel.ChannelHandler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;

@ChannelHandler.Sharable
public class StatefulRedisClusterConnectionImpl<K, V>
extends RedisChannelHandler<K, V>
implements StatefulRedisClusterConnection<K, V> {
    private Partitions partitions;
    private char[] password;
    private boolean readOnly;
    protected final RedisCodec<K, V> codec;
    protected final RedisAdvancedClusterCommands<K, V> sync;
    protected final RedisAdvancedClusterAsyncCommandsImpl<K, V> async;
    protected final RedisAdvancedClusterReactiveCommandsImpl<K, V> reactive;

    public StatefulRedisClusterConnectionImpl(RedisChannelWriter<K, V> writer, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        super(writer, timeout, unit);
        this.codec = codec;
        this.async = new RedisAdvancedClusterAsyncCommandsImpl<K, V>(this, codec);
        this.sync = (RedisAdvancedClusterCommands)Proxy.newProxyInstance(AbstractRedisClient.class.getClassLoader(), new Class[]{RedisAdvancedClusterConnection.class, RedisAdvancedClusterCommands.class}, this.syncInvocationHandler());
        this.reactive = new RedisAdvancedClusterReactiveCommandsImpl<K, V>(this, codec);
    }

    @Override
    public RedisAdvancedClusterCommands<K, V> sync() {
        return this.sync;
    }

    public InvocationHandler syncInvocationHandler() {
        return new ClusterFutureSyncInvocationHandler(this, this.async());
    }

    @Override
    public RedisAdvancedClusterAsyncCommands<K, V> async() {
        return this.async;
    }

    @Override
    public RedisAdvancedClusterReactiveCommands<K, V> reactive() {
        return this.reactive;
    }

    @Deprecated
    protected RedisAdvancedClusterReactiveCommandsImpl<K, V> getReactiveCommands() {
        return this.reactive;
    }

    private RedisURI lookup(String nodeId) {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.getNodeId().equals(nodeId)) continue;
            return partition.getUri();
        }
        return null;
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(String nodeId) {
        RedisURI redisURI = this.lookup(nodeId);
        if (redisURI == null) {
            throw new RedisException("NodeId " + nodeId + " does not belong to the cluster");
        }
        return this.getClusterDistributionChannelWriter().getClusterConnectionProvider().getConnection(ClusterConnectionProvider.Intent.WRITE, nodeId);
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(String host, int port) {
        return this.getClusterDistributionChannelWriter().getClusterConnectionProvider().getConnection(ClusterConnectionProvider.Intent.WRITE, host, port);
    }

    public ClusterDistributionChannelWriter<K, V> getClusterDistributionChannelWriter() {
        return (ClusterDistributionChannelWriter)super.getChannelWriter();
    }

    @Override
    public void activated() {
        super.activated();
        if (this.password != null) {
            this.async.authAsync(new String(this.password));
        }
        if (this.readOnly) {
            this.async.readOnly();
        }
    }

    @Override
    public <T, C extends RedisCommand<K, V, T>> C dispatch(C cmd) {
        Object local = cmd;
        if (local.getType().name().equals(CommandType.AUTH.name())) {
            local = this.attachOnComplete((RedisCommand<K, V, T>)local, status -> {
                if (status.equals("OK") && cmd.getArgs().getFirstString() != null) {
                    this.password = cmd.getArgs().getFirstString().toCharArray();
                }
            });
        }
        if (local.getType().name().equals(CommandType.READONLY.name())) {
            local = this.attachOnComplete((RedisCommand<K, V, T>)local, status -> {
                if (status.equals("OK")) {
                    this.readOnly = true;
                }
            });
        }
        if (local.getType().name().equals(CommandType.READWRITE.name())) {
            local = this.attachOnComplete((RedisCommand<K, V, T>)local, status -> {
                if (status.equals("OK")) {
                    this.readOnly = false;
                }
            });
        }
        return (C)super.dispatch(local);
    }

    private <T> RedisCommand<K, V, T> attachOnComplete(RedisCommand<K, V, T> command, Consumer<T> consumer) {
        if (command instanceof CompleteableCommand) {
            CompleteableCommand completeable = (CompleteableCommand)((Object)command);
            completeable.onComplete(consumer);
        }
        return command;
    }

    public void setPartitions(Partitions partitions) {
        this.partitions = partitions;
        this.getClusterDistributionChannelWriter().setPartitions(partitions);
    }

    @Override
    public Partitions getPartitions() {
        return this.partitions;
    }

    @Override
    public void setReadFrom(ReadFrom readFrom) {
        LettuceAssert.notNull(readFrom, "ReadFrom must not be null");
        this.getClusterDistributionChannelWriter().setReadFrom(readFrom);
    }

    @Override
    public ReadFrom getReadFrom() {
        return this.getClusterDistributionChannelWriter().getReadFrom();
    }

    private static class ClusterFutureSyncInvocationHandler<K, V>
    extends AbstractInvocationHandler {
        private final StatefulRedisClusterConnection<K, V> connection;
        private final Object asyncApi;
        private final Map<Method, Method> apiMethodCache = new ConcurrentHashMap<Method, Method>(RedisClusterCommands.class.getMethods().length, 1.0f);
        private final Map<Method, Method> connectionMethodCache = new ConcurrentHashMap<Method, Method>(5, 1.0f);
        private static final Constructor<MethodHandles.Lookup> LOOKUP_CONSTRUCTOR;

        ClusterFutureSyncInvocationHandler(StatefulRedisClusterConnection<K, V> connection, Object asyncApi) {
            this.connection = connection;
            this.asyncApi = asyncApi;
        }

        static MethodHandles.Lookup privateMethodHandleLookup(Class<?> declaringClass) {
            try {
                return LOOKUP_CONSTRUCTOR.newInstance(declaringClass, 2);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        static MethodHandle getDefaultMethodHandle(Method method) {
            Class<?> declaringClass = method.getDeclaringClass();
            try {
                return ClusterFutureSyncInvocationHandler.privateMethodHandleLookup(declaringClass).unreflectSpecial(method, declaringClass);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Did not pass in an interface method: " + method);
            }
        }

        @Override
        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object result;
                Method targetMethod;
                if (method.isDefault()) {
                    return ClusterFutureSyncInvocationHandler.getDefaultMethodHandle(method).bindTo(proxy).invokeWithArguments(args);
                }
                if (method.getName().equals("getConnection") && args.length > 0) {
                    targetMethod = this.connectionMethodCache.computeIfAbsent(method, key -> {
                        try {
                            return this.connection.getClass().getMethod(key.getName(), key.getParameterTypes());
                        }
                        catch (NoSuchMethodException e) {
                            throw new IllegalStateException(e);
                        }
                    });
                    result = targetMethod.invoke(this.connection, args);
                    if (result instanceof StatefulRedisClusterConnection) {
                        StatefulRedisClusterConnection connection = (StatefulRedisClusterConnection)result;
                        return connection.sync();
                    }
                    if (result instanceof StatefulRedisConnection) {
                        StatefulRedisConnection connection = (StatefulRedisConnection)result;
                        return connection.sync();
                    }
                }
                if (method.getName().equals("readonly") && args.length == 1) {
                    return this.nodes((Predicate)args[0], ClusterConnectionProvider.Intent.READ, false);
                }
                if (method.getName().equals("nodes") && args.length == 1) {
                    return this.nodes((Predicate)args[0], ClusterConnectionProvider.Intent.WRITE, false);
                }
                if (method.getName().equals("nodes") && args.length == 2) {
                    return this.nodes((Predicate)args[0], ClusterConnectionProvider.Intent.WRITE, (Boolean)args[1]);
                }
                targetMethod = this.apiMethodCache.computeIfAbsent(method, key -> {
                    try {
                        return this.asyncApi.getClass().getMethod(key.getName(), key.getParameterTypes());
                    }
                    catch (NoSuchMethodException e) {
                        throw new IllegalStateException(e);
                    }
                });
                result = targetMethod.invoke(this.asyncApi, args);
                if (result instanceof RedisFuture) {
                    RedisFuture command = (RedisFuture)result;
                    if (!method.getName().equals("exec") && !method.getName().equals("multi") && this.connection instanceof StatefulRedisConnection && ((StatefulRedisConnection)((Object)this.connection)).isMulti()) {
                        return null;
                    }
                    return LettuceFutures.awaitOrCancel(command, this.connection.getTimeout(), this.connection.getTimeoutUnit());
                }
                return result;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        protected NodeSelection<K, V> nodes(Predicate<RedisClusterNode> predicate, ClusterConnectionProvider.Intent intent, boolean dynamic) {
            AbstractNodeSelection selection = dynamic ? new DynamicSyncNodeSelection(this.connection, predicate, intent) : new StaticSyncNodeSelection(this.connection, predicate, intent);
            NodeSelectionInvocationHandler h = new NodeSelectionInvocationHandler(selection, true, this.connection.getTimeout(), this.connection.getTimeoutUnit());
            return (NodeSelection)Proxy.newProxyInstance(NodeSelectionSupport.class.getClassLoader(), new Class[]{NodeSelectionCommands.class, NodeSelection.class}, (InvocationHandler)h);
        }

        static {
            try {
                LOOKUP_CONSTRUCTOR = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                if (!LOOKUP_CONSTRUCTOR.isAccessible()) {
                    LOOKUP_CONSTRUCTOR.setAccessible(true);
                }
            }
            catch (NoSuchMethodException exp) {
                throw new IllegalStateException(exp);
            }
        }
    }
}

