/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableCollection$Builder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ObjectArrays;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableList;
import java.util.Collection;
import java.util.Iterator;

public final class ImmutableList$Builder
extends ImmutableCollection$Builder {
    private Object[] contents;
    private int size;

    public ImmutableList$Builder() {
        this(4);
    }

    ImmutableList$Builder(int n) {
        this.contents = new Object[n];
        this.size = 0;
    }

    ImmutableList$Builder ensureCapacity(int n) {
        if (this.contents.length < n) {
            this.contents = ObjectArrays.arraysCopyOf(this.contents, ImmutableList$Builder.expandedCapacity(this.contents.length, n));
        }
        return this;
    }

    @Override
    public ImmutableList$Builder add(Object object) {
        Preconditions.checkNotNull(object);
        this.ensureCapacity(this.size + 1);
        this.contents[this.size++] = object;
        return this;
    }

    @Override
    public ImmutableList$Builder addAll(Iterable iterable) {
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            this.ensureCapacity(this.size + collection.size());
        }
        super.addAll(iterable);
        return this;
    }

    @Override
    public ImmutableList$Builder addAll(Iterator iterator) {
        super.addAll(iterator);
        return this;
    }

    public ImmutableList build() {
        switch (this.size) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                Object object = this.contents[0];
                return ImmutableList.of(object);
            }
        }
        if (this.size == this.contents.length) {
            return new RegularImmutableList(this.contents);
        }
        return new RegularImmutableList(ObjectArrays.arraysCopyOf(this.contents, this.size));
    }
}

