/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteSink;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteStreams$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteStreams$5;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.ByteStreams$7;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.OutputSupplier;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class ByteStreams {
    private static final OutputStream NULL_OUTPUT_STREAM = new ByteStreams$1();

    public static long copy(InputStream inputStream, OutputStream outputStream) {
        int n;
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkNotNull(outputStream);
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static byte[] toByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteStreams.copy(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    static OutputSupplier asOutputSupplier(ByteSink byteSink) {
        Preconditions.checkNotNull(byteSink);
        return new ByteStreams$5(byteSink);
    }

    static ByteSink asByteSink(OutputSupplier outputSupplier) {
        Preconditions.checkNotNull(outputSupplier);
        return new ByteStreams$7(outputSupplier);
    }
}

