/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.jpa.lambda;

import com.fhs.jpa.lambda.SFunction;
import com.fhs.jpa.utils.ClassUtils;
import com.fhs.jpa.utils.SerializationUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;

public class SerializedLambda
implements Serializable {
    private static final long serialVersionUID = 8025925345765570181L;
    private Class<?> capturingClass;
    private String functionalInterfaceClass;
    private String functionalInterfaceMethodName;
    private String functionalInterfaceMethodSignature;
    private String implClass;
    private String implMethodName;
    private String implMethodSignature;
    private int implMethodKind;
    private String instantiatedMethodType;
    private Object[] capturedArgs;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SerializedLambda resolve(SFunction<?, ?> lambda) {
        if (!lambda.getClass().isSynthetic()) {
            throw new RuntimeException("\u8be5\u65b9\u6cd5\u4ec5\u80fd\u4f20\u5165 lambda \u8868\u8fbe\u5f0f\u4ea7\u751f\u7684\u5408\u6210\u7c7b");
        }
        try (ObjectInputStream objIn = new ObjectInputStream(new ByteArrayInputStream(SerializationUtils.serialize(lambda))){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                Class<?> clazz;
                try {
                    clazz = ClassUtils.toClassConfident(objectStreamClass.getName());
                }
                catch (Exception ex) {
                    clazz = super.resolveClass(objectStreamClass);
                }
                return clazz == java.lang.invoke.SerializedLambda.class ? SerializedLambda.class : clazz;
            }
        };){
            SerializedLambda serializedLambda = (SerializedLambda)objIn.readObject();
            return serializedLambda;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("This is impossible to happen", e);
        }
    }

    public String getFunctionalInterfaceClassName() {
        return this.normalizedName(this.functionalInterfaceClass);
    }

    public Class<?> getImplClass() {
        return ClassUtils.toClassConfident(this.getImplClassName());
    }

    public String getImplClassName() {
        return this.normalizedName(this.implClass);
    }

    public String getImplMethodName() {
        return this.implMethodName;
    }

    private String normalizedName(String name) {
        return name.replace('/', '.');
    }

    public Class<?> getInstantiatedType() {
        String instantiatedTypeName = this.normalizedName(this.instantiatedMethodType.substring(2, this.instantiatedMethodType.indexOf(59)));
        return ClassUtils.toClassConfident(instantiatedTypeName);
    }

    public String toString() {
        String interfaceName = this.getFunctionalInterfaceClassName();
        String implName = this.getImplClassName();
        return String.format("%s -> %s::%s", interfaceName.substring(interfaceName.lastIndexOf(46) + 1), implName.substring(implName.lastIndexOf(46) + 1), this.implMethodName);
    }
}

