/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.jpa.wrapper;

import com.fhs.jpa.lambda.LambdaSett;
import com.fhs.jpa.lambda.SFunction;
import com.fhs.jpa.lambda.SerializedLambda;
import com.fhs.jpa.utils.LambdaUtils;
import com.fhs.jpa.wrapper.Operator;
import com.fhs.jpa.wrapper.OrderBy;
import com.fhs.jpa.wrapper.TempPredicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class LambdaQueryWrapper<T> {
    private static Map<String, LambdaSett> lambdaSettMap = new HashMap<String, LambdaSett>();
    private List<OrderBy> orderByList = new ArrayList<OrderBy>();
    private final List<TempPredicate> tempPredicates = new ArrayList<TempPredicate>();
    private final List<List<TempPredicate>> orTempPredicates = new ArrayList<List<TempPredicate>>();

    public LambdaQueryWrapper<T> eq(boolean condition, SFunction<T, ?> fieldLambda, Object value) {
        if (condition) {
            this.tempPredicates.add(TempPredicate.builder().fieldName(this.fieldLambda2FieldName(fieldLambda)).operator(Operator.EQ).value(value).build());
        }
        return this;
    }

    public LambdaQueryWrapper<T> eq(SFunction<T, ?> fieldLambda, Object value) {
        this.eq(true, fieldLambda, value);
        return this;
    }

    public LambdaQueryWrapper<T> ne(boolean condition, SFunction<T, ?> fieldLambda, Object value) {
        if (condition) {
            this.tempPredicates.add(TempPredicate.builder().fieldName(this.fieldLambda2FieldName(fieldLambda)).operator(Operator.NE).value(value).build());
        }
        return this;
    }

    public LambdaQueryWrapper<T> ne(SFunction<T, ?> fieldLambda, Object value) {
        this.ne(true, fieldLambda, value);
        return this;
    }

    public LambdaQueryWrapper<T> gt(boolean condition, SFunction<T, ?> fieldLambda, Comparable<?> value) {
        if (condition) {
            this.tempPredicates.add(TempPredicate.builder().fieldName(this.fieldLambda2FieldName(fieldLambda)).operator(Operator.GT).value(value).build());
        }
        return this;
    }

    public LambdaQueryWrapper<T> gt(SFunction<T, ?> fieldLambda, Comparable<?> value) {
        this.gt(true, fieldLambda, value);
        return this;
    }

    public LambdaQueryWrapper<T> ge(boolean condition, SFunction<T, ?> fieldLambda, Comparable<?> value) {
        if (condition) {
            this.tempPredicates.add(TempPredicate.builder().fieldName(this.fieldLambda2FieldName(fieldLambda)).operator(Operator.GE).value(value).build());
        }
        return this;
    }

    public LambdaQueryWrapper<T> ge(SFunction<T, ?> fieldLambda, Comparable<?> value) {
        this.ge(true, fieldLambda, value);
        return this;
    }

    public LambdaQueryWrapper<T> lt(boolean condition, SFunction<T, ?> fieldLambda, Comparable<?> value) {
        if (condition) {
            this.tempPredicates.add(TempPredicate.builder().fieldName(this.fieldLambda2FieldName(fieldLambda)).operator(Operator.LT).value(value).build());
        }
        return this;
    }

    public LambdaQueryWrapper<T> lt(SFunction<T, ?> fieldLambda, Comparable<?> value) {
        this.lt(true, fieldLambda, value);
        return this;
    }

    public LambdaQueryWrapper<T> le(boolean condition, SFunction<T, ?> fieldLambda, Comparable<?> value) {
        if (condition) {
            this.tempPredicates.add(TempPredicate.builder().fieldName(this.fieldLambda2FieldName(fieldLambda)).operator(Operator.LE).value(value).build());
        }
        return this;
    }

    public LambdaQueryWrapper<T> le(SFunction<T, ?> fieldLambda, Comparable<?> value) {
        this.le(true, fieldLambda, value);
        return this;
    }

    public LambdaQueryWrapper<T> like(boolean condition, SFunction<T, ?> fieldLambda, String value) {
        if (condition) {
            this.tempPredicates.add(TempPredicate.builder().fieldName(this.fieldLambda2FieldName(fieldLambda)).operator(Operator.LIKE).value("%" + value + "%").build());
        }
        return this;
    }

    public LambdaQueryWrapper<T> like(SFunction<T, ?> fieldLambda, String value) {
        this.like(true, fieldLambda, value);
        return this;
    }

    public LambdaQueryWrapper<T> likeRight(boolean condition, SFunction<T, ?> fieldLambda, String value) {
        if (condition) {
            this.tempPredicates.add(TempPredicate.builder().fieldName(this.fieldLambda2FieldName(fieldLambda)).operator(Operator.LIKE).value(value + "%").build());
        }
        return this;
    }

    public LambdaQueryWrapper<T> likeRight(SFunction<T, ?> fieldLambda, String value) {
        this.likeRight(true, fieldLambda, value);
        return this;
    }

    public LambdaQueryWrapper<T> likeLeft(boolean condition, SFunction<T, ?> fieldLambda, String value) {
        if (condition) {
            this.tempPredicates.add(TempPredicate.builder().fieldName(this.fieldLambda2FieldName(fieldLambda)).operator(Operator.LIKE).value("%" + value).build());
        }
        return this;
    }

    public LambdaQueryWrapper<T> or(TempQueryWrapper<T> tempQueryWrapper) {
        LambdaQueryWrapper<T> lambdaQueryWrapper = new LambdaQueryWrapper<T>();
        tempQueryWrapper.exec(lambdaQueryWrapper);
        if (!lambdaQueryWrapper.tempPredicates.isEmpty()) {
            this.orTempPredicates.add(lambdaQueryWrapper.tempPredicates);
        }
        return this;
    }

    public LambdaQueryWrapper<T> likeLeft(SFunction<T, ?> fieldLambda, String value) {
        this.likeLeft(true, fieldLambda, value);
        return this;
    }

    public LambdaQueryWrapper<T> between(boolean condition, SFunction<T, ?> fieldLambda, Object lower, Object upper) {
        if (condition) {
            this.tempPredicates.add(TempPredicate.builder().fieldName(this.fieldLambda2FieldName(fieldLambda)).operator(Operator.BETWEEN).value(new Object[]{lower, upper}).build());
        }
        return this;
    }

    public LambdaQueryWrapper<T> between(SFunction<T, ?> fieldLambda, Object lower, Object upper) {
        this.between(true, fieldLambda, lower, upper);
        return this;
    }

    public LambdaQueryWrapper<T> in(boolean condition, SFunction<T, ?> fieldLambda, Iterable<?> values) {
        ArrayList valuesList = new ArrayList();
        values.forEach(value -> valuesList.add(value));
        if (condition) {
            this.tempPredicates.add(TempPredicate.builder().fieldName(this.fieldLambda2FieldName(fieldLambda)).operator(Operator.IN).value(valuesList.toArray()).build());
        }
        return this;
    }

    public LambdaQueryWrapper<T> in(SFunction<T, ?> fieldLambda, Iterable<?> values) {
        this.in(true, fieldLambda, values);
        return this;
    }

    public LambdaQueryWrapper<T> in(boolean condition, SFunction<T, ?> fieldLambda, Object ... values) {
        if (condition) {
            this.tempPredicates.add(TempPredicate.builder().fieldName(this.fieldLambda2FieldName(fieldLambda)).operator(Operator.IN).value(values).build());
        }
        return this;
    }

    public LambdaQueryWrapper<T> in(SFunction<T, ?> fieldLambda, Object ... values) {
        this.in(true, fieldLambda, values);
        return this;
    }

    public LambdaQueryWrapper<T> notIn(boolean condition, SFunction<T, ?> fieldLambda, Object ... values) {
        if (condition) {
            this.tempPredicates.add(TempPredicate.builder().fieldName(this.fieldLambda2FieldName(fieldLambda)).operator(Operator.NOTIN).value(values).build());
        }
        return this;
    }

    public LambdaQueryWrapper<T> notIn(SFunction<T, ?> fieldLambda, Object ... values) {
        this.notIn(true, fieldLambda, values);
        return this;
    }

    public LambdaQueryWrapper<T> isNull(boolean condition, SFunction<T, ?> fieldLambda) {
        if (condition) {
            this.tempPredicates.add(TempPredicate.builder().fieldName(this.fieldLambda2FieldName(fieldLambda)).operator(Operator.ISNULL).build());
        }
        return this;
    }

    public LambdaQueryWrapper<T> isNull(SFunction<T, ?> fieldLambda) {
        this.isNull(true, fieldLambda);
        return this;
    }

    public LambdaQueryWrapper<T> isNotNull(boolean condition, SFunction<T, ?> fieldLambda) {
        if (condition) {
            this.tempPredicates.add(TempPredicate.builder().fieldName(this.fieldLambda2FieldName(fieldLambda)).operator(Operator.NOTNULL).build());
        }
        return this;
    }

    public LambdaQueryWrapper<T> isNotNull(SFunction<T, ?> fieldLambda) {
        this.isNotNull(true, fieldLambda);
        return this;
    }

    public LambdaQueryWrapper<T> notIn(boolean condition, SFunction<T, ?> fieldLambda, Iterable<?> values) {
        ArrayList valuesList = new ArrayList();
        values.forEach(value -> valuesList.add(value));
        if (condition) {
            this.tempPredicates.add(TempPredicate.builder().fieldName(this.fieldLambda2FieldName(fieldLambda)).operator(Operator.NOTIN).value(valuesList.toArray()).build());
        }
        return this;
    }

    public LambdaQueryWrapper<T> notIn(SFunction<T, ?> fieldLambda, Iterable<?> values) {
        this.notIn(true, fieldLambda, values);
        return this;
    }

    public LambdaQueryWrapper<T> orderByAsc(SFunction<T, ?> fieldLambda) {
        this.orderByList.add(OrderBy.builder().isDesc(false).property(this.fieldLambda2FieldName(fieldLambda)).build());
        return this;
    }

    public LambdaQueryWrapper<T> orderByDesc(SFunction<T, ?> fieldLambda) {
        this.orderByList.add(OrderBy.builder().isDesc(true).property(this.fieldLambda2FieldName(fieldLambda)).build());
        return this;
    }

    private String fieldLambda2FieldName(SFunction<T, ?> fieldLambda) {
        return this.getLambdaSett(fieldLambda).getFiledName();
    }

    protected LambdaSett getLambdaSett(SFunction<T, ?> fieldLambda) {
        LambdaSett lambdaSett;
        SerializedLambda lambda = LambdaUtils.resolve(fieldLambda);
        String filedName = LambdaQueryWrapper.resolveFieldName(lambda.getImplMethodName());
        String key = lambda.getImplClass().getName() + filedName;
        if (lambdaSettMap.containsKey(key)) {
            lambdaSett = lambdaSettMap.get(key);
        } else {
            lambdaSett = new LambdaSett(lambda, filedName);
            lambdaSettMap.put(key, lambdaSett);
        }
        return lambdaSett;
    }

    private static String resolveFieldName(String methodName) {
        methodName = methodName.replace("get", "");
        return (methodName.charAt(0) + "").toLowerCase() + methodName.substring(1);
    }

    public Specification<T> build() {
        return (Specification & Serializable)(root, query, cb) -> {
            Predicate[] predicates = new Predicate[this.tempPredicates.size() + this.orTempPredicates.size()];
            int index = 0;
            for (int i = 0; i < this.tempPredicates.size(); ++i) {
                predicates[i] = this.toPredicate(root, query, cb, this.tempPredicates.get(i));
                ++index;
            }
            for (List<TempPredicate> orTempPredicate : this.orTempPredicates) {
                Predicate[] oneOr = new Predicate[orTempPredicate.size()];
                for (int i = 0; i < orTempPredicate.size(); ++i) {
                    oneOr[i] = this.toPredicate(root, query, cb, orTempPredicate.get(i));
                }
                predicates[index] = cb.or(oneOr);
                ++index;
            }
            if (Objects.equals(predicates.length, 0) && this.orderByList.isEmpty()) {
                return null;
            }
            if (this.orderByList.isEmpty()) {
                return cb.and(predicates);
            }
            Order[] orders = new Order[this.orderByList.size()];
            for (int i = 0; i < this.orderByList.size(); ++i) {
                orders[i] = this.orderByList.get(i).isDesc() ? cb.desc((Expression)root.get(this.orderByList.get(i).getProperty())) : cb.asc((Expression)root.get(this.orderByList.get(i).getProperty()));
            }
            return query.orderBy(orders).where(predicates).getRestriction();
        };
    }

    private Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder, TempPredicate predicate) {
        switch (predicate.getOperator()) {
            case EQ: {
                return criteriaBuilder.equal((Expression)root.get(predicate.getFieldName()), predicate.getValue());
            }
            case NE: {
                return criteriaBuilder.notEqual((Expression)root.get(predicate.getFieldName()), predicate.getValue());
            }
            case GE: {
                return criteriaBuilder.ge((Expression)root.get(predicate.getFieldName()), (Number)predicate.getValue());
            }
            case GT: {
                return criteriaBuilder.gt((Expression)root.get(predicate.getFieldName()), (Number)predicate.getValue());
            }
            case LE: {
                return criteriaBuilder.le((Expression)root.get(predicate.getFieldName()), (Number)predicate.getValue());
            }
            case LT: {
                return criteriaBuilder.lt((Expression)root.get(predicate.getFieldName()), (Number)predicate.getValue());
            }
            case IN: {
                Object[] objects;
                CriteriaBuilder.In in = criteriaBuilder.in((Expression)root.get(predicate.getFieldName()));
                for (Object obj : objects = (Object[])predicate.getValue()) {
                    in.value(obj);
                }
                return criteriaBuilder.and(new Predicate[]{in});
            }
            case NOTIN: {
                return criteriaBuilder.not((Expression)root.get(predicate.getFieldName()).in(new Object[]{predicate.getValue()}));
            }
            case LIKE: {
                return criteriaBuilder.like((Expression)root.get(predicate.getFieldName()), "" + predicate.getValue());
            }
            case ISNULL: {
                return criteriaBuilder.isNull((Expression)root.get(predicate.getFieldName()));
            }
            case NOTNULL: {
                return criteriaBuilder.isNotNull((Expression)root.get(predicate.getFieldName()));
            }
        }
        return null;
    }

    public static interface TempQueryWrapper<T> {
        public void exec(LambdaQueryWrapper<T> var1);
    }
}

