/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.dataflow;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.dataflow.DataflowRequest;
import com.google.api.services.dataflow.DataflowRequestInitializer;
import com.google.api.services.dataflow.model.Job;
import com.google.api.services.dataflow.model.JobMetrics;
import com.google.api.services.dataflow.model.LeaseWorkItemRequest;
import com.google.api.services.dataflow.model.LeaseWorkItemResponse;
import com.google.api.services.dataflow.model.ListJobMessagesResponse;
import com.google.api.services.dataflow.model.ListJobsResponse;
import com.google.api.services.dataflow.model.ReportWorkItemStatusRequest;
import com.google.api.services.dataflow.model.ReportWorkItemStatusResponse;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dataflow
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://dataflow.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BASE_URL = "https://dataflow.googleapis.com/";

    public Dataflow(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Dataflow(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.20.0 of the Google Dataflow API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://dataflow.googleapis.com/", Dataflow.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Dataflow build() {
            return new Dataflow(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDataflowRequestInitializer(DataflowRequestInitializer dataflowRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)dataflowRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Jobs jobs() {
            return new Jobs();
        }

        public class Jobs {
            public Create create(String string, Job job) throws IOException {
                Create create = new Create(string, job);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public GetMetrics getMetrics(String string, String string2) throws IOException {
                GetMetrics getMetrics = new GetMetrics(string, string2);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)getMetrics);
                return getMetrics;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Update update(String string, String string2, Job job) throws IOException {
                Update update = new Update(string, string2, job);
                Dataflow.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            public Messages messages() {
                return new Messages();
            }

            public WorkItems workItems() {
                return new WorkItems();
            }

            public class WorkItems {
                public Lease lease(String string, String string2, LeaseWorkItemRequest leaseWorkItemRequest) throws IOException {
                    Lease lease = new Lease(string, string2, leaseWorkItemRequest);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)lease);
                    return lease;
                }

                public ReportStatus reportStatus(String string, String string2, ReportWorkItemStatusRequest reportWorkItemStatusRequest) throws IOException {
                    ReportStatus reportStatus = new ReportStatus(string, string2, reportWorkItemStatusRequest);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)reportStatus);
                    return reportStatus;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class ReportStatus
                extends DataflowRequest<ReportWorkItemStatusResponse> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}/workItems:reportStatus";
                    @Key
                    private String projectId;
                    @Key
                    private String jobId;

                    protected ReportStatus(String string, String string2, ReportWorkItemStatusRequest reportWorkItemStatusRequest) {
                        super(Dataflow.this, "POST", REST_PATH, (Object)reportWorkItemStatusRequest, ReportWorkItemStatusResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter jobId must be specified.");
                    }

                    public ReportStatus set$Xgafv(String string) {
                        return (ReportStatus)super.set$Xgafv(string);
                    }

                    public ReportStatus setAccessToken(String string) {
                        return (ReportStatus)super.setAccessToken(string);
                    }

                    public ReportStatus setAlt(String string) {
                        return (ReportStatus)super.setAlt(string);
                    }

                    public ReportStatus setBearerToken(String string) {
                        return (ReportStatus)super.setBearerToken(string);
                    }

                    public ReportStatus setCallback(String string) {
                        return (ReportStatus)super.setCallback(string);
                    }

                    public ReportStatus setFields(String string) {
                        return (ReportStatus)super.setFields(string);
                    }

                    public ReportStatus setKey(String string) {
                        return (ReportStatus)super.setKey(string);
                    }

                    public ReportStatus setOauthToken(String string) {
                        return (ReportStatus)super.setOauthToken(string);
                    }

                    public ReportStatus setPp(Boolean bl) {
                        return (ReportStatus)super.setPp(bl);
                    }

                    public ReportStatus setPrettyPrint(Boolean bl) {
                        return (ReportStatus)super.setPrettyPrint(bl);
                    }

                    public ReportStatus setQuotaUser(String string) {
                        return (ReportStatus)super.setQuotaUser(string);
                    }

                    public ReportStatus setUploadType(String string) {
                        return (ReportStatus)super.setUploadType(string);
                    }

                    public ReportStatus setUploadProtocol(String string) {
                        return (ReportStatus)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public ReportStatus setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public ReportStatus setJobId(String string) {
                        this.jobId = string;
                        return this;
                    }

                    @Override
                    public ReportStatus set(String string, Object object) {
                        return (ReportStatus)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Lease
                extends DataflowRequest<LeaseWorkItemResponse> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}/workItems:lease";
                    @Key
                    private String projectId;
                    @Key
                    private String jobId;

                    protected Lease(String string, String string2, LeaseWorkItemRequest leaseWorkItemRequest) {
                        super(Dataflow.this, "POST", REST_PATH, (Object)leaseWorkItemRequest, LeaseWorkItemResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter jobId must be specified.");
                    }

                    public Lease set$Xgafv(String string) {
                        return (Lease)super.set$Xgafv(string);
                    }

                    public Lease setAccessToken(String string) {
                        return (Lease)super.setAccessToken(string);
                    }

                    public Lease setAlt(String string) {
                        return (Lease)super.setAlt(string);
                    }

                    public Lease setBearerToken(String string) {
                        return (Lease)super.setBearerToken(string);
                    }

                    public Lease setCallback(String string) {
                        return (Lease)super.setCallback(string);
                    }

                    public Lease setFields(String string) {
                        return (Lease)super.setFields(string);
                    }

                    public Lease setKey(String string) {
                        return (Lease)super.setKey(string);
                    }

                    public Lease setOauthToken(String string) {
                        return (Lease)super.setOauthToken(string);
                    }

                    public Lease setPp(Boolean bl) {
                        return (Lease)super.setPp(bl);
                    }

                    public Lease setPrettyPrint(Boolean bl) {
                        return (Lease)super.setPrettyPrint(bl);
                    }

                    public Lease setQuotaUser(String string) {
                        return (Lease)super.setQuotaUser(string);
                    }

                    public Lease setUploadType(String string) {
                        return (Lease)super.setUploadType(string);
                    }

                    public Lease setUploadProtocol(String string) {
                        return (Lease)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Lease setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public Lease setJobId(String string) {
                        this.jobId = string;
                        return this;
                    }

                    @Override
                    public Lease set(String string, Object object) {
                        return (Lease)super.set(string, object);
                    }
                }
            }

            public class Messages {
                public List list(String string, String string2) throws IOException {
                    List list = new List(string, string2);
                    Dataflow.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends DataflowRequest<ListJobMessagesResponse> {
                    private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}/messages";
                    @Key
                    private String projectId;
                    @Key
                    private String jobId;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;
                    @Key
                    private String startTime;
                    @Key
                    private String endTime;
                    @Key
                    private String minimumImportance;

                    protected List(String string, String string2) {
                        super(Dataflow.this, "GET", REST_PATH, null, ListJobMessagesResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter jobId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public List setJobId(String string) {
                        this.jobId = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public String getStartTime() {
                        return this.startTime;
                    }

                    public List setStartTime(String string) {
                        this.startTime = string;
                        return this;
                    }

                    public String getEndTime() {
                        return this.endTime;
                    }

                    public List setEndTime(String string) {
                        this.endTime = string;
                        return this;
                    }

                    public String getMinimumImportance() {
                        return this.minimumImportance;
                    }

                    public List setMinimumImportance(String string) {
                        this.minimumImportance = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends DataflowRequest<Job> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}";
                @Key
                private String projectId;
                @Key
                private String jobId;

                protected Update(String string, String string2, Job job) {
                    super(Dataflow.this, "PUT", REST_PATH, (Object)job, Job.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                    this.jobId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter jobId must be specified.");
                }

                public Update set$Xgafv(String string) {
                    return (Update)super.set$Xgafv(string);
                }

                public Update setAccessToken(String string) {
                    return (Update)super.setAccessToken(string);
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setBearerToken(String string) {
                    return (Update)super.setBearerToken(string);
                }

                public Update setCallback(String string) {
                    return (Update)super.setCallback(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPp(Boolean bl) {
                    return (Update)super.setPp(bl);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUploadType(String string) {
                    return (Update)super.setUploadType(string);
                }

                public Update setUploadProtocol(String string) {
                    return (Update)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Update setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getJobId() {
                    return this.jobId;
                }

                public Update setJobId(String string) {
                    this.jobId = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends DataflowRequest<ListJobsResponse> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/jobs";
                @Key
                private String projectId;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;
                @Key
                private String view;

                protected List(String string) {
                    super(Dataflow.this, "GET", REST_PATH, null, ListJobsResponse.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public List setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public List setView(String string) {
                    this.view = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetMetrics
            extends DataflowRequest<JobMetrics> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}/metrics";
                @Key
                private String projectId;
                @Key
                private String jobId;
                @Key
                private String startTime;

                protected GetMetrics(String string, String string2) {
                    super(Dataflow.this, "GET", REST_PATH, null, JobMetrics.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                    this.jobId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter jobId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetMetrics set$Xgafv(String string) {
                    return (GetMetrics)super.set$Xgafv(string);
                }

                public GetMetrics setAccessToken(String string) {
                    return (GetMetrics)super.setAccessToken(string);
                }

                public GetMetrics setAlt(String string) {
                    return (GetMetrics)super.setAlt(string);
                }

                public GetMetrics setBearerToken(String string) {
                    return (GetMetrics)super.setBearerToken(string);
                }

                public GetMetrics setCallback(String string) {
                    return (GetMetrics)super.setCallback(string);
                }

                public GetMetrics setFields(String string) {
                    return (GetMetrics)super.setFields(string);
                }

                public GetMetrics setKey(String string) {
                    return (GetMetrics)super.setKey(string);
                }

                public GetMetrics setOauthToken(String string) {
                    return (GetMetrics)super.setOauthToken(string);
                }

                public GetMetrics setPp(Boolean bl) {
                    return (GetMetrics)super.setPp(bl);
                }

                public GetMetrics setPrettyPrint(Boolean bl) {
                    return (GetMetrics)super.setPrettyPrint(bl);
                }

                public GetMetrics setQuotaUser(String string) {
                    return (GetMetrics)super.setQuotaUser(string);
                }

                public GetMetrics setUploadType(String string) {
                    return (GetMetrics)super.setUploadType(string);
                }

                public GetMetrics setUploadProtocol(String string) {
                    return (GetMetrics)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public GetMetrics setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getJobId() {
                    return this.jobId;
                }

                public GetMetrics setJobId(String string) {
                    this.jobId = string;
                    return this;
                }

                public String getStartTime() {
                    return this.startTime;
                }

                public GetMetrics setStartTime(String string) {
                    this.startTime = string;
                    return this;
                }

                @Override
                public GetMetrics set(String string, Object object) {
                    return (GetMetrics)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends DataflowRequest<Job> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/jobs/{jobId}";
                @Key
                private String projectId;
                @Key
                private String jobId;
                @Key
                private String view;

                protected Get(String string, String string2) {
                    super(Dataflow.this, "GET", REST_PATH, null, Job.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                    this.jobId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter jobId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Get setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getJobId() {
                    return this.jobId;
                }

                public Get setJobId(String string) {
                    this.jobId = string;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public Get setView(String string) {
                    this.view = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends DataflowRequest<Job> {
                private static final String REST_PATH = "v1b3/projects/{projectId}/jobs";
                @Key
                private String projectId;
                @Key
                private String replaceJobId;
                @Key
                private String view;

                protected Create(String string, Job job) {
                    super(Dataflow.this, "POST", REST_PATH, (Object)job, Job.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Create setProjectId(String string) {
                    this.projectId = string;
                    return this;
                }

                public String getReplaceJobId() {
                    return this.replaceJobId;
                }

                public Create setReplaceJobId(String string) {
                    this.replaceJobId = string;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public Create setView(String string) {
                    this.view = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }
    }
}

