/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk;

import com.google.cloud.dataflow.sdk.PipelineResult;
import com.google.cloud.dataflow.sdk.coders.CoderRegistry;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsFactory;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.HashMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Multimap;
import com.google.cloud.dataflow.sdk.runners.PipelineRunner;
import com.google.cloud.dataflow.sdk.runners.TransformHierarchy;
import com.google.cloud.dataflow.sdk.runners.TransformTreeNode;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.util.UserCodeException;
import com.google.cloud.dataflow.sdk.values.PBegin;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;
import com.google.cloud.dataflow.sdk.values.PValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pipeline {
    private static final Logger LOG = LoggerFactory.getLogger(Pipeline.class);
    private final PipelineRunner<?> runner;
    private final PipelineOptions options;
    private final TransformHierarchy transforms = new TransformHierarchy();
    private Collection<PValue> values = new ArrayList<PValue>();
    private Set<String> usedFullNames = new HashSet<String>();
    private CoderRegistry coderRegistry;
    private Multimap<PTransform<?, ?>, AppliedPTransform<?, ?, ?>> transformApplicationsForTesting = HashMultimap.create();

    public static Pipeline create(PipelineOptions options) {
        Pipeline pipeline = new Pipeline(PipelineRunner.fromOptions(options), options);
        LOG.debug("Creating {}", (Object)pipeline);
        return pipeline;
    }

    public PBegin begin() {
        return PBegin.in(this);
    }

    public <OutputT extends POutput> OutputT apply(PTransform<? super PBegin, OutputT> root) {
        return this.begin().apply(root);
    }

    public <OutputT extends POutput> OutputT apply(String name, PTransform<? super PBegin, OutputT> root) {
        return this.begin().apply(name, root);
    }

    public PipelineResult run() {
        LOG.debug("Running {} via {}", (Object)this, this.runner);
        try {
            return this.runner.run(this);
        }
        catch (UserCodeException e) {
            throw new PipelineExecutionException(e.getCause());
        }
    }

    public CoderRegistry getCoderRegistry() {
        if (this.coderRegistry == null) {
            this.coderRegistry = new CoderRegistry();
            this.coderRegistry.registerStandardCoders();
        }
        return this.coderRegistry;
    }

    public void setCoderRegistry(CoderRegistry coderRegistry) {
        this.coderRegistry = coderRegistry;
    }

    public void traverseTopologically(PipelineVisitor visitor) {
        HashSet<PValue> visitedValues = new HashSet<PValue>();
        this.transforms.visit(visitor, visitedValues);
        if (!visitedValues.containsAll(this.values)) {
            throw new RuntimeException("internal error: should have visited all the values after visiting all the transforms");
        }
    }

    public static <InputT extends PInput, OutputT extends POutput> OutputT applyTransform(InputT input, PTransform<? super InputT, OutputT> transform) {
        return input.getPipeline().applyInternal(transform.getName(), input, transform);
    }

    public static <InputT extends PInput, OutputT extends POutput> OutputT applyTransform(String name, InputT input, PTransform<? super InputT, OutputT> transform) {
        return input.getPipeline().applyInternal(name, input, transform);
    }

    @Deprecated
    protected Pipeline(PipelineRunner<?> runner) {
        this(runner, PipelineOptionsFactory.create());
    }

    protected Pipeline(PipelineRunner<?> runner, PipelineOptions options) {
        this.runner = runner;
        this.options = options;
    }

    public String toString() {
        int n = this.hashCode();
        return new StringBuilder(20).append("Pipeline#").append(n).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <InputT extends PInput, OutputT extends POutput> OutputT applyInternal(String name, InputT input, PTransform<? super InputT, OutputT> transform) {
        input.finishSpecifying();
        TransformTreeNode parent = this.transforms.getCurrent();
        String namePrefix = parent.getFullName();
        String fullName = this.uniquifyInternal(namePrefix, name);
        boolean nameIsUnique = fullName.equals(this.buildName(namePrefix, name));
        if (!nameIsUnique) {
            switch (this.getOptions().getStableUniqueNames()) {
                case OFF: {
                    break;
                }
                case WARNING: {
                    LOG.warn("Transform {} does not have a stable unique name. This will prevent updating of pipelines.", (Object)fullName);
                    break;
                }
                case ERROR: {
                    throw new IllegalStateException(new StringBuilder(87 + String.valueOf(fullName).length()).append("Transform ").append(fullName).append(" does not have a stable unique name. ").append("This will prevent updating of pipelines.").toString());
                }
                default: {
                    String string = String.valueOf((Object)this.getOptions().getStableUniqueNames());
                    throw new IllegalArgumentException(new StringBuilder(44 + String.valueOf(string).length()).append("Unrecognized value for stable unique names: ").append(string).toString());
                }
            }
        }
        TransformTreeNode child = new TransformTreeNode(parent, transform, fullName, input);
        parent.addComposite(child);
        this.transforms.addInput(child, input);
        LOG.debug("Adding {} to {}", transform, (Object)this);
        try {
            this.transforms.pushNode(child);
            transform.validate(input);
            OutputT output = this.runner.apply(transform, input);
            this.transforms.setOutput(child, (POutput)output);
            AppliedPTransform<InputT, OutputT, PTransform<? super InputT, OutputT>> applied = AppliedPTransform.of(child.getFullName(), input, output, transform);
            this.transformApplicationsForTesting.put(transform, applied);
            output.recordAsOutput(applied);
            this.verifyOutputState((POutput)output, child);
            OutputT OutputT = output;
            return OutputT;
        }
        finally {
            this.transforms.popNode();
        }
    }

    private List<AppliedPTransform<?, ?, ?>> getProducingTransforms(POutput output) {
        ArrayList producingTransforms = new ArrayList();
        for (PValue pValue : output.expand()) {
            AppliedPTransform<?, ?, ?> transform = pValue.getProducingTransformInternal();
            if (transform == null) continue;
            producingTransforms.add(transform);
        }
        return producingTransforms;
    }

    private void verifyOutputState(POutput output, TransformTreeNode node) {
        if (!node.isCompositeNode()) {
            PTransform<?, ?> thisTransform = node.getTransform();
            List<AppliedPTransform<?, ?, ?>> producingTransforms = this.getProducingTransforms(output);
            for (AppliedPTransform<?, ?, ?> producingTransform : producingTransforms) {
                if (thisTransform == producingTransform.getTransform()) continue;
                String string = String.valueOf(thisTransform);
                String string2 = String.valueOf(producingTransform);
                throw new IllegalArgumentException(new StringBuilder(93 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Output of non-composite transform ").append(string).append(" is registered as being produced by").append(" a different transform: ").append(string2).toString());
            }
        } else {
            PTransform<?, ?> thisTransform = node.getTransform();
            List<AppliedPTransform<?, ?, ?>> producingTransforms = this.getProducingTransforms(output);
            for (AppliedPTransform<?, ?, ?> producingTransform : producingTransforms) {
                if (thisTransform != producingTransform.getTransform()) continue;
                String string = String.valueOf(thisTransform);
                throw new IllegalStateException(new StringBuilder(176 + String.valueOf(string).length()).append("Output of composite transform ").append(string).append(" is registered as being produced by it,").append(" but the output of every composite transform should be").append(" produced by a primitive transform contained therein.").toString());
            }
        }
    }

    public PipelineRunner<?> getRunner() {
        return this.runner;
    }

    public PipelineOptions getOptions() {
        return this.options;
    }

    @Deprecated
    public String getFullNameForTesting(PTransform<?, ?> transform) {
        Collection<AppliedPTransform<?, ?, ?>> uses = this.transformApplicationsForTesting.get(transform);
        boolean bl = uses.size() > 0;
        String string = String.valueOf(transform);
        Preconditions.checkState(bl, new StringBuilder(19 + String.valueOf(string).length()).append("Unknown transform: ").append(string).toString());
        string = String.valueOf(transform);
        Preconditions.checkState(uses.size() <= 1, new StringBuilder(31 + String.valueOf(string).length()).append("Transform used multiple times: ").append(string).toString());
        return Iterables.getOnlyElement(uses).getFullName();
    }

    private String uniquifyInternal(String namePrefix, String origName) {
        String name = origName;
        int suffixNum = 2;
        String candidate;
        while (!this.usedFullNames.add(candidate = this.buildName(namePrefix, name))) {
            int n = suffixNum++;
            name = new StringBuilder(11 + String.valueOf(origName).length()).append(origName).append(n).toString();
        }
        return candidate;
    }

    private String buildName(String namePrefix, String name) {
        return namePrefix.isEmpty() ? name : new StringBuilder(1 + String.valueOf(namePrefix).length() + String.valueOf(name).length()).append(namePrefix).append("/").append(name).toString();
    }

    public void addValueInternal(PValue value) {
        this.values.add(value);
        LOG.debug("Adding {} to {}", (Object)value, (Object)this);
    }

    public static interface PipelineVisitor {
        public void enterCompositeTransform(TransformTreeNode var1);

        public void leaveCompositeTransform(TransformTreeNode var1);

        public void visitTransform(TransformTreeNode var1);

        public void visitValue(PValue var1, TransformTreeNode var2);
    }

    public static class PipelineExecutionException
    extends RuntimeException {
        public PipelineExecutionException(Throwable cause) {
            super(cause);
        }
    }
}

