/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderProvider;
import com.google.cloud.dataflow.sdk.coders.StandardCoder;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.AvroEncode;
import org.apache.avro.reflect.AvroName;
import org.apache.avro.reflect.AvroSchema;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.reflect.Union;
import org.apache.avro.util.ClassUtils;
import org.apache.avro.util.Utf8;

public class AvroCoder<T>
extends StandardCoder<T> {
    public static final CoderProvider PROVIDER = new CoderProvider(){

        @Override
        public <T> Coder<T> getCoder(TypeDescriptor<T> typeDescriptor) {
            Class<T> rawType = typeDescriptor.getRawType();
            return AvroCoder.of(rawType);
        }
    };
    private final Class<T> type;
    private final Schema schema;
    private final List<String> nonDeterministicReasons;
    private final DatumWriter<T> writer;
    private final DatumReader<T> reader;
    private final EncoderFactory encoderFactory = new EncoderFactory();
    private final DecoderFactory decoderFactory = new DecoderFactory();

    public static <T> AvroCoder<T> of(TypeDescriptor<T> type) {
        Class<T> clazz = type.getRawType();
        return AvroCoder.of(clazz);
    }

    public static <T> AvroCoder<T> of(Class<T> clazz) {
        return new AvroCoder<T>(clazz, ReflectData.get().getSchema(clazz));
    }

    public static AvroCoder<GenericRecord> of(Schema schema) {
        return new AvroCoder<GenericRecord>(GenericRecord.class, schema);
    }

    public static <T> AvroCoder<T> of(Class<T> type, Schema schema) {
        return new AvroCoder<T>(type, schema);
    }

    @JsonCreator
    public static AvroCoder<?> of(@JsonProperty(value="type") String classType, @JsonProperty(value="schema") String schema) throws ClassNotFoundException {
        Schema.Parser parser = new Schema.Parser();
        return new AvroCoder(Class.forName(classType), parser.parse(schema));
    }

    protected AvroCoder(Class<T> type, Schema schema) {
        this.type = type;
        this.schema = schema;
        this.nonDeterministicReasons = new AvroDeterminismChecker().check(TypeDescriptor.of(type), schema);
        this.reader = this.createDatumReader();
        this.writer = this.createDatumWriter();
    }

    @Override
    public String getEncodingId() {
        return this.type.getName();
    }

    private Object writeReplace() {
        return new SerializedAvroCoderProxy<T>(this.type, this.schema.toString());
    }

    @Override
    public void encode(T value, OutputStream outStream, Coder.Context context) throws IOException {
        BinaryEncoder encoder = this.encoderFactory.directBinaryEncoder(outStream, null);
        this.writer.write(value, (Encoder)encoder);
        encoder.flush();
    }

    @Override
    public T decode(InputStream inStream, Coder.Context context) throws IOException {
        BinaryDecoder decoder = this.decoderFactory.directBinaryDecoder(inStream, null);
        return (T)this.reader.read(null, (Decoder)decoder);
    }

    @Override
    public List<? extends Coder<?>> getCoderArguments() {
        return null;
    }

    @Override
    public CloudObject asCloudObject() {
        CloudObject result = super.asCloudObject();
        Structs.addString((Map<String, Object>)((Object)result), "type", this.type.getName());
        Structs.addString((Map<String, Object>)((Object)result), "schema", this.schema.toString());
        return result;
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        if (!this.nonDeterministicReasons.isEmpty()) {
            throw new Coder.NonDeterministicException(this, this.nonDeterministicReasons);
        }
    }

    public DatumReader<T> createDatumReader() {
        if (this.type.equals(GenericRecord.class)) {
            return new GenericDatumReader(this.schema);
        }
        return new ReflectDatumReader(this.schema);
    }

    public DatumWriter<T> createDatumWriter() {
        if (this.type.equals(GenericRecord.class)) {
            return new GenericDatumWriter(this.schema);
        }
        return new ReflectDatumWriter(this.schema);
    }

    public Schema getSchema() {
        return this.schema;
    }

    protected static class AvroDeterminismChecker {
        private List<String> reasons = new ArrayList<String>();
        private Set<TypeDescriptor<?>> activeTypes = new HashSet();
        private Set<Schema> activeSchemas = new HashSet<Schema>();
        private static final Set<Class<?>> DETERMINISTIC_STRINGABLE_CLASSES = new HashSet();
        private static final Schema AVRO_NULL_SCHEMA;

        private void reportError(String context, String fmt, Object ... args) {
            String message = String.format(fmt, args);
            this.reasons.add(new StringBuilder(2 + String.valueOf(context).length() + String.valueOf(message).length()).append(context).append(": ").append(message).toString());
        }

        private static boolean isSubtypeOf(TypeDescriptor<?> type, Class<?> ... parents) {
            for (Class<?> parent : parents) {
                if (!type.isSubtypeOf(TypeDescriptor.of(parent))) continue;
                return true;
            }
            return false;
        }

        protected AvroDeterminismChecker() {
        }

        public List<String> check(TypeDescriptor<?> type, Schema schema) {
            this.recurse(type.getRawType().getName(), type, schema);
            return this.reasons;
        }

        private void recurse(String context, TypeDescriptor<?> type, Schema schema) {
            if (type.getRawType().isAnnotationPresent(AvroSchema.class)) {
                this.reportError(context, "Custom schemas are not supported -- remove @AvroSchema.", new Object[0]);
                return;
            }
            if (!this.activeTypes.add(type)) {
                this.reportError(context, "%s appears recursively", type);
                return;
            }
            if (AvroDeterminismChecker.isSubtypeOf(type, IndexedRecord.class)) {
                this.checkIndexedRecord(context, schema, null);
            } else {
                this.doCheck(context, type, schema);
            }
            this.activeTypes.remove(type);
        }

        private void doCheck(String context, TypeDescriptor<?> type, Schema schema) {
            switch (schema.getType()) {
                case ARRAY: {
                    this.checkArray(context, type, schema);
                    break;
                }
                case ENUM: {
                    break;
                }
                case FIXED: {
                    this.reportError(context, "FIXED encodings are not guaranteed to be deterministic", new Object[0]);
                    break;
                }
                case MAP: {
                    this.checkMap(context, type, schema);
                    break;
                }
                case RECORD: {
                    this.checkRecord(type, schema);
                    break;
                }
                case UNION: {
                    this.checkUnion(context, type, schema);
                    break;
                }
                case STRING: {
                    this.checkString(context, type);
                    break;
                }
                case BOOLEAN: 
                case BYTES: 
                case DOUBLE: 
                case INT: 
                case FLOAT: 
                case LONG: 
                case NULL: {
                    break;
                }
                default: {
                    this.reportError(context, "Unknown schema type %s may be non-deterministic", schema.getType());
                }
            }
        }

        private void checkString(String context, TypeDescriptor<?> type) {
            if (!DETERMINISTIC_STRINGABLE_CLASSES.contains(type.getRawType())) {
                this.reportError(context, "%s may not have deterministic #toString()", type);
            }
        }

        private void checkUnion(String context, TypeDescriptor<?> type, Schema schema) {
            List unionTypes = schema.getTypes();
            if (!type.getRawType().isAnnotationPresent(Union.class)) {
                if (unionTypes.size() == 2 && unionTypes.contains(AVRO_NULL_SCHEMA)) {
                    Schema nullableFieldSchema = ((Schema)unionTypes.get(0)).equals((Object)AVRO_NULL_SCHEMA) ? (Schema)unionTypes.get(1) : (Schema)unionTypes.get(0);
                    this.doCheck(context, type, nullableFieldSchema);
                    return;
                }
                this.reportError(context, "Expected type %s to have @Union annotation", type);
                return;
            }
            String baseClassContext = type.getRawType().getName();
            for (Schema concrete : unionTypes) {
                TypeDescriptor unionType = TypeDescriptor.of(ReflectData.get().getClass(concrete));
                this.recurse(baseClassContext, unionType, concrete);
            }
        }

        private void checkRecord(TypeDescriptor<?> type, Schema schema) {
            Class<?> clazz = type.getRawType();
            for (Schema.Field fieldSchema : schema.getFields()) {
                Field field = AvroDeterminismChecker.getField(clazz, fieldSchema.name());
                String string = String.valueOf(field.getDeclaringClass().getName());
                String string2 = String.valueOf(field.getName());
                String fieldContext = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("#").append(string2).toString();
                if (field.isAnnotationPresent(AvroEncode.class)) {
                    this.reportError(fieldContext, "Custom encoders may be non-deterministic -- remove @AvroEncode", new Object[0]);
                    continue;
                }
                if (!IndexedRecord.class.isAssignableFrom(field.getType()) && field.isAnnotationPresent(AvroSchema.class)) {
                    this.reportError(fieldContext, "Custom schemas are only supported for subtypes of IndexedRecord.", new Object[0]);
                    continue;
                }
                TypeDescriptor<?> fieldType = type.resolveType(field.getGenericType());
                this.recurse(fieldContext, fieldType, fieldSchema.schema());
            }
        }

        private void checkIndexedRecord(String context, Schema schema, @Nullable String specificClassStr) {
            if (!this.activeSchemas.add(schema)) {
                this.reportError(context, "%s appears recursively", schema.getName());
                return;
            }
            switch (schema.getType()) {
                case ARRAY: {
                    this.checkIndexedRecord(context, schema.getElementType(), null);
                    break;
                }
                case ENUM: {
                    break;
                }
                case FIXED: {
                    break;
                }
                case MAP: {
                    this.reportError(context, "GenericRecord and SpecificRecords use a HashMap to represent MAPs, so it is non-deterministic", new Object[0]);
                    break;
                }
                case RECORD: {
                    for (Schema.Field field : schema.getFields()) {
                        String string = String.valueOf(schema.getName());
                        String string2 = String.valueOf(field.name());
                        this.checkIndexedRecord(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString(), field.schema(), field.getProp("java-class"));
                    }
                    break;
                }
                case STRING: {
                    if (specificClassStr == null) break;
                    try {
                        Class specificClass = ClassUtils.forName((String)specificClassStr);
                        if (DETERMINISTIC_STRINGABLE_CLASSES.contains(specificClass)) break;
                        this.reportError(context, "Specific class %s is not known to be deterministic", specificClassStr);
                    }
                    catch (ClassNotFoundException e) {
                        this.reportError(context, "Specific class %s is not known to be deterministic", specificClassStr);
                    }
                    break;
                }
                case UNION: {
                    for (Schema subschema : schema.getTypes()) {
                        this.checkIndexedRecord(subschema.getName(), subschema, null);
                    }
                    break;
                }
                case BOOLEAN: 
                case BYTES: 
                case DOUBLE: 
                case INT: 
                case FLOAT: 
                case LONG: 
                case NULL: {
                    break;
                }
                default: {
                    this.reportError(context, "Unknown schema type %s may be non-deterministic", schema.getType());
                }
            }
            this.activeSchemas.remove(schema);
        }

        private void checkMap(String context, TypeDescriptor<?> type, Schema schema) {
            Class<?> keyType;
            if (!AvroDeterminismChecker.isSubtypeOf(type, SortedMap.class)) {
                this.reportError(context, "%s may not be deterministically ordered", type);
            }
            if (!String.class.equals(keyType = type.resolveType(Map.class.getTypeParameters()[0]).getRawType())) {
                this.reportError(context, "map keys should be Strings, but was %s", keyType);
            }
            this.recurse(context, type.resolveType(Map.class.getTypeParameters()[1]), schema.getValueType());
        }

        /*
         * Enabled aggressive block sorting
         */
        private void checkArray(String context, TypeDescriptor<?> type, Schema schema) {
            TypeDescriptor<?> elementType = null;
            if (type.isArray()) {
                elementType = type.getComponentType();
            } else {
                if (!AvroDeterminismChecker.isSubtypeOf(type, Collection.class)) {
                    this.reportError(context, "encoding %s as an ARRAY was unexpected", new Object[0]);
                    return;
                }
                if (!AvroDeterminismChecker.isSubtypeOf(type, List.class, SortedSet.class)) {
                    this.reportError(context, "%s may not be deterministically ordered", type);
                    return;
                }
                elementType = type.resolveType(Collection.class.getTypeParameters()[0]);
            }
            this.recurse(context, elementType, schema.getElementType());
        }

        private static Field getField(Class<?> clazz, String name) {
            while (clazz != null) {
                for (Field field : clazz.getDeclaredFields()) {
                    AvroName avroName = field.getAnnotation(AvroName.class);
                    if (avroName != null && name.equals(avroName.value())) {
                        return field;
                    }
                    if (avroName != null || !name.equals(field.getName())) continue;
                    return field;
                }
                clazz = clazz.getSuperclass();
            }
            String string = String.valueOf(clazz);
            throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(name).length() + String.valueOf(string).length()).append("Unable to get field ").append(name).append(" from class ").append(string).toString());
        }

        static {
            DETERMINISTIC_STRINGABLE_CLASSES.add(String.class);
            DETERMINISTIC_STRINGABLE_CLASSES.add(Utf8.class);
            DETERMINISTIC_STRINGABLE_CLASSES.add(BigDecimal.class);
            DETERMINISTIC_STRINGABLE_CLASSES.add(BigInteger.class);
            DETERMINISTIC_STRINGABLE_CLASSES.add(URI.class);
            DETERMINISTIC_STRINGABLE_CLASSES.add(URL.class);
            AVRO_NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
        }
    }

    private static class SerializedAvroCoderProxy<T>
    implements Serializable {
        private final Class<T> type;
        private final String schemaStr;

        public SerializedAvroCoderProxy(Class<T> type, String schemaStr) {
            this.type = type;
            this.schemaStr = schemaStr;
        }

        private Object readResolve() {
            Schema.Parser parser = new Schema.Parser();
            return new AvroCoder<T>(this.type, parser.parse(this.schemaStr));
        }
    }
}

