/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderFactory;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class CoderFactories {
    private CoderFactories() {
    }

    public static <T> CoderFactory fromStaticMethods(Class<T> clazz) {
        return new CoderFactoryFromStaticMethods(clazz);
    }

    public static <T> CoderFactory forCoder(Coder<T> coder) {
        return new CoderFactoryForCoder<T>(coder);
    }

    private static class CoderFactoryForCoder<T>
    implements CoderFactory {
        private Coder<T> coder;

        public CoderFactoryForCoder(Coder<T> coder) {
            this.coder = coder;
        }

        @Override
        public Coder<?> create(List<? extends Coder<?>> componentCoders) {
            return this.coder;
        }

        @Override
        public List<Object> getInstanceComponents(Object value) {
            return Collections.emptyList();
        }
    }

    private static class CoderFactoryFromStaticMethods
    implements CoderFactory {
        private Method factoryMethod;
        private Method getComponentsMethod;

        @Override
        public Coder<?> create(List<? extends Coder<?>> componentCoders) {
            try {
                return (Coder)this.factoryMethod.invoke(null, componentCoders.toArray());
            }
            catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException exn) {
                String string = String.valueOf(this.factoryMethod);
                throw new IllegalStateException(new StringBuilder(41 + String.valueOf(string).length()).append("error when invoking Coder factory method ").append(string).toString(), exn);
            }
        }

        @Override
        public List<Object> getInstanceComponents(Object value) {
            try {
                List components = (List)this.getComponentsMethod.invoke(null, value);
                return components;
            }
            catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException exn) {
                String string = String.valueOf(this.getComponentsMethod);
                throw new IllegalStateException(new StringBuilder(47 + String.valueOf(string).length()).append("error when invoking Coder getComponents method ").append(string).toString(), exn);
            }
        }

        private CoderFactoryFromStaticMethods(Class<?> coderClazz) {
            this.factoryMethod = this.getFactoryMethod(coderClazz);
            this.getComponentsMethod = this.getInstanceComponentsMethod(coderClazz);
        }

        private Method getFactoryMethod(Class<?> coderClazz) {
            Method factoryMethodCandidate;
            int numTypeParameters = coderClazz.getTypeParameters().length;
            Object[] factoryMethodArgTypes = new Class[numTypeParameters];
            Arrays.fill(factoryMethodArgTypes, Coder.class);
            try {
                factoryMethodCandidate = coderClazz.getDeclaredMethod("of", (Class<?>[])factoryMethodArgTypes);
            }
            catch (NoSuchMethodException | SecurityException exn) {
                String string = String.valueOf(coderClazz);
                throw new IllegalArgumentException(new StringBuilder(110 + String.valueOf(string).length()).append("cannot register Coder ").append(string).append(": ").append("does not have an accessible method named 'of' with ").append(numTypeParameters).append(" arguments of Coder type").toString(), exn);
            }
            if (!Modifier.isStatic(factoryMethodCandidate.getModifiers())) {
                String exn = String.valueOf(coderClazz);
                throw new IllegalArgumentException(new StringBuilder(96 + String.valueOf(exn).length()).append("cannot register Coder ").append(exn).append(": ").append("method named 'of' with ").append(numTypeParameters).append(" arguments of Coder type is not static").toString());
            }
            if (!coderClazz.isAssignableFrom(factoryMethodCandidate.getReturnType())) {
                String exn = String.valueOf(coderClazz);
                String string = String.valueOf(coderClazz);
                throw new IllegalArgumentException(new StringBuilder(101 + String.valueOf(exn).length() + String.valueOf(string).length()).append("cannot register Coder ").append(exn).append(": ").append("method named 'of' with ").append(numTypeParameters).append(" arguments of Coder type does not return a ").append(string).toString());
            }
            try {
                if (!factoryMethodCandidate.isAccessible()) {
                    factoryMethodCandidate.setAccessible(true);
                }
            }
            catch (SecurityException exn) {
                String string = String.valueOf(coderClazz);
                throw new IllegalArgumentException(new StringBuilder(100 + String.valueOf(string).length()).append("cannot register Coder ").append(string).append(": ").append("method named 'of' with ").append(numTypeParameters).append(" arguments of Coder type is not accessible").toString(), exn);
            }
            return factoryMethodCandidate;
        }

        private <T> Method getInstanceComponentsMethod(Class<?> coderClazz) {
            TypeDescriptor<?> coderType = TypeDescriptor.of(coderClazz);
            TypeDescriptor<T> argumentType = this.getCodedType(coderType);
            for (TypeDescriptor supertype : coderType.getClasses()) {
                for (Method method : supertype.getRawType().getDeclaredMethods()) {
                    TypeDescriptor<?> formalArgumentType;
                    if (!method.getName().equals("getInstanceComponents") || !(formalArgumentType = supertype.getArgumentTypes(method).get(0)).getRawType().isAssignableFrom(argumentType.getRawType())) continue;
                    return method;
                }
            }
            String string = String.valueOf(coderType);
            throw new IllegalArgumentException(new StringBuilder(94 + String.valueOf(string).length()).append("cannot create a CoderFactory from ").append(string).append(": ").append("does not have an accessible method ").append("'getInstanceComponents'").toString());
        }

        private <T> TypeDescriptor<T> getCodedType(TypeDescriptor<?> coderType) {
            for (TypeDescriptor ifaceType : coderType.getInterfaces()) {
                if (!ifaceType.getRawType().equals(Coder.class)) continue;
                ParameterizedType coderIface = (ParameterizedType)ifaceType.getType();
                TypeDescriptor<?> token = TypeDescriptor.of(coderIface.getActualTypeArguments()[0]);
                return token;
            }
            String string = String.valueOf(coderType);
            throw new IllegalArgumentException(new StringBuilder(77 + String.valueOf(string).length()).append("cannot build CoderFactory from class ").append(string).append(": does not implement Coder<T> for any T.").toString());
        }
    }
}

